/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.logical;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ide.ui.internal.logical.HistoryIterator;
import com.ibm.team.filesystem.ide.ui.internal.logical.IChangeSetFilter;
import com.ibm.team.filesystem.ide.ui.internal.logical.PartialFileSystemView;
import com.ibm.team.filesystem.ide.ui.internal.logical.RemoteFileSystemView;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMFileRevision;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMResourceDiff;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMResourceMappingContext;
import com.ibm.team.filesystem.ide.ui.internal.logical.SCMWorkspaceConnectionState;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class ComponentResourceMappingContext {
    final SCMWorkspaceConnectionState connection;
    final IComponentHandle componentHandle;
    private final Collection<ICopyFileArea> copyFileAreasToUpdate;
    private final Map<UUID, IItemConflictReport> conflicts = new HashMap<UUID, IItemConflictReport>();
    private PartialFileSystemView ancestorFileView;
    private final Map<UUID, Map<UUID, DisposableInputStreamProvider>> buffers = new HashMap<UUID, Map<UUID, DisposableInputStreamProvider>>();
    private RemoteFileSystemView remoteFileView;

    public ComponentResourceMappingContext(SCMWorkspaceConnectionState connection, IComponentHandle handle, Collection<ICopyFileArea> copyFileAreasToUpdate) {
        this.connection = connection;
        this.componentHandle = handle;
        this.copyFileAreasToUpdate = copyFileAreasToUpdate;
    }

    public IWorkspaceConnection getConnection() {
        return this.connection.getConnection();
    }

    public void add(IItemConflictReport conflict) {
        this.conflicts.put(conflict.item().getItemId(), conflict);
    }

    public void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final Map<UUID, IChangeSet> setsToDiscard = this.findSetsToDiscard(progress.newChild(25));
        IComponent component = (IComponent)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.componentHandle, 0, (IProgressMonitor)progress.newChild(25));
        this.ancestorFileView = new PartialFileSystemView(this.connection.getConnection(), component);
        this.ancestorFileView.discardChangeSets(new IChangeSetFilter(){

            @Override
            public boolean excludeChangeSet(IChangeSet changeSet) {
                boolean discard;
                boolean bl = discard = setsToDiscard.remove(changeSet.getItemId()) != null;
                return discard || !this.allDiscarded();
            }

            @Override
            public boolean allDiscarded() {
                return setsToDiscard.isEmpty();
            }
        }, (IProgressMonitor)progress.newChild(25));
        this.remoteFileView = new RemoteFileSystemView(this.connection, (IComponentHandle)component, this.ancestorFileView, this.conflicts);
    }

    private Map<UUID, IChangeSet> findSetsToDiscard(SubMonitor progress) throws TeamRepositoryException {
        progress.setWorkRemaining(20);
        List<IChangeSet> changeSetsForAllConflict = this.fetchChangeSetsConveringConflicts(progress.newChild(10));
        Map<UUID, IChangeSet> changeSets = this.findChangeSetsToDiscard(changeSetsForAllConflict, progress.newChild(10));
        return changeSets;
    }

    private Map<UUID, IChangeSet> findChangeSetsToDiscard(List<IChangeSet> changeSetsForAllConflict, SubMonitor progress) {
        HashMap<UUID, IChangeSet> excludedChangeSets = new HashMap<UUID, IChangeSet>();
        HashSet<UUID> excludedUuids = new HashSet<UUID>();
        HashMap<UUID, UUID> ancestorStates = new HashMap<UUID, UUID>();
        for (IItemConflictReport conflict : this.conflicts.values()) {
            IVersionableHandle commonAncestorState = conflict.getCommonAncestorState();
            if (commonAncestorState == null) {
                excludedUuids.add(conflict.item().getItemId());
                continue;
            }
            ancestorStates.put(conflict.item().getItemId(), commonAncestorState.getStateId());
        }
        ListIterator<IChangeSet> i = changeSetsForAllConflict.listIterator(changeSetsForAllConflict.size());
        while (i.hasPrevious()) {
            IChangeSet changeSet = i.previous();
            if (!this.shouldExcludeChangeSet(changeSet, excludedUuids, ancestorStates)) continue;
            this.excludeChangeSet(changeSet, excludedUuids);
            excludedChangeSets.put(changeSet.getItemId(), changeSet);
        }
        return excludedChangeSets;
    }

    private void excludeChangeSet(IChangeSet changeSet, Set<UUID> excludedUuids) {
        for (Object o : changeSet.changes()) {
            IChange change = (IChange)o;
            excludedUuids.add(change.item().getItemId());
        }
    }

    private boolean shouldExcludeChangeSet(IChangeSet changeSet, Set<UUID> excludedUuids, Map<UUID, UUID> ancestorStates) {
        for (Object o : changeSet.changes()) {
            IChange change = (IChange)o;
            if (excludedUuids.contains(change.item().getItemId())) {
                return true;
            }
            UUID stateId = ancestorStates.get(change.item().getItemId());
            if (change.beforeState() == null || !change.beforeState().getStateId().equals((Object)stateId)) continue;
            return true;
        }
        return false;
    }

    private List<IChangeSet> fetchChangeSetsConveringConflicts(SubMonitor progress) throws TeamRepositoryException {
        progress.setWorkRemaining(2100);
        int workLeft = 1000;
        ArrayList<IChangeSet> changeSets = new ArrayList<IChangeSet>();
        HashMap<UUID, UUID> ancestorStates = new HashMap<UUID, UUID>();
        HashSet<UUID> conflictingAdds = new HashSet<UUID>();
        for (IItemConflictReport conflict : this.conflicts.values()) {
            IVersionableHandle commonAncestorState = conflict.getCommonAncestorState();
            if (commonAncestorState == null) {
                conflictingAdds.add(conflict.item().getItemId());
                continue;
            }
            ancestorStates.put(conflict.item().getItemId(), commonAncestorState.getStateId());
        }
        HistoryIterator iterator = new HistoryIterator(this.connection.getConnection(), this.componentHandle);
        while (!ancestorStates.isEmpty() || !conflictingAdds.isEmpty()) {
            int ticks = workLeft / 2;
            workLeft -= ticks;
            SubMonitor subProgress = progress.newChild(ticks);
            subProgress.beginTask("", 100);
            List<IChangeHistoryEntryChange> recentHist = iterator.nextEntry(subProgress.newChild(30));
            if (recentHist == null) break;
            ListIterator<IChangeHistoryEntryChange> i = recentHist.listIterator(recentHist.size());
            while (i.hasPrevious()) {
                IChangeHistoryEntryChange entry = i.previous();
                IChangeSet cs = iterator.getChangeSet(entry.changeSet(), subProgress.newChild(1));
                boolean recordCS = false;
                for (IChange change : cs.changes()) {
                    IVersionableHandle afterState;
                    UUID itemId = change.item().getItemId();
                    UUID ancestorStateId = (UUID)ancestorStates.get(itemId);
                    if (ancestorStateId != null && (afterState = change.afterState()) != null && afterState.getStateId().equals((Object)ancestorStateId)) {
                        ancestorStates.remove(itemId);
                    }
                    if (change.beforeState() != null || !conflictingAdds.contains(itemId)) continue;
                    conflictingAdds.remove(itemId);
                    recordCS = true;
                }
                if (ancestorStates.isEmpty() && conflictingAdds.isEmpty()) {
                    if (!recordCS) break;
                    changeSets.add(cs);
                    break;
                }
                changeSets.add(cs);
            }
            subProgress.done();
        }
        return changeSets;
    }

    public IVersionableHandle getLocalState(IResource resource, SubMonitor monitor) throws FileSystemException {
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable != null) {
            return shareable.getRemote((IProgressMonitor)monitor);
        }
        return null;
    }

    private IShareable getShareable(IResource resource) {
        return (IShareable)resource.getAdapter(IShareable.class);
    }

    public IVersionableHandle getAncestorState(IResource resource, SubMonitor monitor) throws FileSystemException {
        String searchPath;
        IContainer parent;
        if (resource.getType() == 1) {
            parent = resource.getParent();
            searchPath = resource.getName();
        } else {
            parent = (IContainer)resource;
            searchPath = "";
        }
        IVersionableHandle remote = null;
        monitor.setWorkRemaining(10);
        while (parent.getType() != 8 && remote == null) {
            IShareable parentShareable = (IShareable)parent.getAdapter(IShareable.class);
            if (parentShareable == null) {
                return null;
            }
            remote = parentShareable.getRemote((IProgressMonitor)monitor.newChild(1));
            if (remote != null) continue;
            searchPath = PathUtils.appendPath((String)parentShareable.getLocalPath().getName(), (String)searchPath);
        }
        if (remote != null) {
            try {
                if (PathUtils.isEmptyPath((String)searchPath)) {
                    return this.ancestorFileView.getItem(remote, (IProgressMonitor)monitor.newChild(1));
                }
                String shareRemotePath = this.ancestorFileView.getPath(remote, false, (IProgressMonitor)monitor.newChild(1));
                if (shareRemotePath != null) {
                    return this.ancestorFileView.locate(PathUtils.appendPath((String)shareRemotePath, (String)searchPath), (IProgressMonitor)monitor.newChild(1));
                }
            }
            catch (ItemNotFoundException shareRemotePath) {
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        return null;
    }

    public IVersionableHandle getRemoteState(IResource resource, SubMonitor monitor) throws ComponentNotInWorkspaceException, TeamRepositoryException, FileSystemException {
        IShareable shareable = this.getShareable(resource);
        if (shareable != null) {
            return this.remoteFileView.getState(shareable, monitor);
        }
        return null;
    }

    public IFolderHandle getFolderHandle(IContainer resource, SubMonitor monitor) throws TeamRepositoryException {
        monitor.setWorkRemaining(4);
        IVersionableHandle localState = this.getLocalState((IResource)resource, monitor.newChild(1));
        if (localState != null) {
            return (IFolderHandle)localState;
        }
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable != null) {
            IVersionableHandle state = this.ancestorFileView.getState(shareable, monitor.newChild(1));
            if (state instanceof IFolderHandle) {
                return (IFolderHandle)state;
            }
            state = this.remoteFileView.getState(shareable, monitor.newChild(1));
            if (state instanceof IFolderHandle) {
                return (IFolderHandle)state;
            }
        }
        return null;
    }

    public IVersionableHandle getAncestorState(IVersionableHandle handle, SubMonitor monitor) throws TeamRepositoryException {
        IItemConflictReport conflict = this.getConflict(handle);
        if (conflict != null) {
            return conflict.getCommonAncestorState();
        }
        try {
            return this.ancestorFileView.getItem(handle, (IProgressMonitor)monitor);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public Collection<? extends IResource> members(IContainer container, SubMonitor monitor) throws FileSystemException, TeamRepositoryException {
        monitor.setWorkRemaining(3);
        IFolderHandle handle = this.getFolderHandle(container, monitor.newChild(1));
        HashSet<Object> members = new HashSet<Object>();
        if (handle instanceof IFolderHandle) {
            try {
                Map<String, IVersionableHandle> children = this.ancestorFileView.getChildren(handle, (IProgressMonitor)monitor);
                for (Map.Entry<String, IVersionableHandle> entry : children.entrySet()) {
                    if (entry.getValue() instanceof IFileItemHandle) {
                        members.add(container.getFile((IPath)new Path(entry.getKey())));
                        continue;
                    }
                    if (!(entry.getValue() instanceof IFolderHandle)) continue;
                    members.add(container.getFolder((IPath)new Path(entry.getKey())));
                }
            }
            catch (ItemNotFoundException children) {
                // empty catch block
            }
            try {
                Map childEntries = this.remoteFileView.childEntries(handle, (IProgressMonitor)monitor.newChild(1));
                for (Map.Entry<String, Object> key : childEntries.keySet()) {
                    String name = (String)((Object)key);
                    if (childEntries.get(name) instanceof IFileItemHandle) {
                        members.add(container.getFile((IPath)new Path(name)));
                        continue;
                    }
                    if (!(childEntries.get(name) instanceof IFolderHandle)) continue;
                    members.add(container.getFolder((IPath)new Path(name)));
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return members;
    }

    public IStorage fetchRemoteContents(IResource resource, SubMonitor monitor) throws TeamRepositoryException, FileSystemException {
        monitor.setWorkRemaining(3);
        IVersionableHandle state = this.getRemoteState(resource, monitor.newChild(1));
        IFileItem file = this.getFileItem(state, monitor.newChild(1));
        return this.getStorage(file, (IProgressMonitor)monitor.newChild(1));
    }

    public IStorage getStorage(IFileItem file, IProgressMonitor monitor) throws FileSystemException {
        if (file != null) {
            try {
                DisposableInputStreamProvider buffer = this.getBuffer(file);
                if (buffer == null) {
                    buffer = TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)new FileContentInputStreamProvider(this.getTeamRepository(), (IFileItemHandle)file, file.getContent()), (IProgressMonitor)monitor);
                    this.putBuffer(file, buffer);
                }
                return new InputStreamStorage((IInputStreamProvider)buffer);
            }
            catch (IOException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        return null;
    }

    IFileItem getFileItem(IVersionableHandle state, SubMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        if (state instanceof IFileItem) {
            return (IFileItem)state;
        }
        if (state instanceof IFileItemHandle) {
            return (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository()).versionableManager().fetchCompleteState(state, (IProgressMonitor)monitor);
        }
        return null;
    }

    private ITeamRepository getTeamRepository() {
        return this.getConnection().teamRepository();
    }

    public IStorage fetchAncestorContents(IResource resource, SubMonitor monitor) throws TeamRepositoryException, FileSystemException {
        monitor.setWorkRemaining(3);
        IVersionableHandle state = this.getAncestorState(resource, monitor.newChild(1));
        IFileItem file = this.getFileItem(state, monitor.newChild(1));
        return this.getStorage(file, (IProgressMonitor)monitor.newChild(1));
    }

    private void putBuffer(IFileItem file, DisposableInputStreamProvider buffer) {
        Map<UUID, DisposableInputStreamProvider> fileBuffers = this.buffers.get(file.getItemId());
        if (fileBuffers == null) {
            fileBuffers = new HashMap<UUID, DisposableInputStreamProvider>();
            this.buffers.put(file.getItemId(), fileBuffers);
        }
        fileBuffers.put(file.getStateId(), buffer);
    }

    private DisposableInputStreamProvider getBuffer(IFileItem file) {
        Map<UUID, DisposableInputStreamProvider> fileBuffers = this.buffers.get(file.getItemId());
        if (fileBuffers != null) {
            return fileBuffers.get(file.getStateId());
        }
        return null;
    }

    public void dispose() {
        for (Map<UUID, DisposableInputStreamProvider> fileBuffers : this.buffers.values()) {
            for (DisposableInputStreamProvider buffer : fileBuffers.values()) {
                try {
                    buffer.dispose();
                }
                catch (IOException e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                }
            }
        }
    }

    public boolean hasLocalChange(IResource resource, SubMonitor progress) throws FileSystemException, TeamRepositoryException {
        progress.setWorkRemaining(3);
        IVersionableHandle local = this.getLocalState(resource, progress.newChild(1));
        if (local != null && this.isConflict(local)) {
            return true;
        }
        IVersionableHandle ancestor = this.getAncestorState(resource, progress.newChild(1));
        return !SCMResourceMappingContext.sameState(local, ancestor);
    }

    private boolean isConflict(IVersionableHandle handle) {
        return this.getConflict(handle) != null;
    }

    IItemConflictReport getConflict(IVersionableHandle handle) {
        return this.conflicts.get(handle.getItemId());
    }

    public boolean hasRemoteChange(IResource resource, SubMonitor progress) throws TeamRepositoryException, FileSystemException {
        progress.setWorkRemaining(3);
        IVersionableHandle ancestor = this.getAncestorState(resource, progress.newChild(1));
        if (ancestor != null && this.isConflict(ancestor)) {
            return true;
        }
        IVersionableHandle remote = this.getRemoteState(resource, progress.newChild(1));
        return !SCMResourceMappingContext.sameState(ancestor, remote);
    }

    public Collection<ResourceMapping> getConflictingMappings(SubMonitor monitor) {
        monitor.setWorkRemaining(this.conflicts.size());
        ArrayList<ResourceMapping> mappings = new ArrayList<ResourceMapping>(this.conflicts.size());
        for (IItemConflictReport conflict : this.conflicts.values()) {
            try {
                ResourceMapping mapping;
                IResource resource = this.findResource(conflict.item(), (IProgressMonitor)monitor);
                if (resource == null || resource.getType() != 1 || (mapping = this.getResourceMapping(resource)) == null) continue;
                mappings.add(mapping);
            }
            catch (FileSystemException e) {
                this.reportException(NLS.bind((String)"An error occurred attempting to obtain a resource for item {0}", (Object)conflict.item().getItemId().getUuidValue()), (Exception)((Object)e));
            }
            catch (TeamRepositoryException e) {
                this.reportException(NLS.bind((String)"An error occurred attempting to obtain a resource for item {0}", (Object)conflict.item().getItemId().getUuidValue()), (Exception)((Object)e));
            }
        }
        return mappings;
    }

    private ResourceMapping getResourceMapping(IResource resource) {
        return (ResourceMapping)resource.getAdapter(ResourceMapping.class);
    }

    public IResource findResource(IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IResource resource = this.findResourceFromShareable(handle, (IProgressMonitor)progress.newChild(10));
        if (resource != null) {
            return resource;
        }
        String path = this.ancestorFileView.getPath(handle, false, (IProgressMonitor)progress.newChild(10));
        if (path != null) {
            String parentPath = path;
            String relativePath = "";
            IVersionable parent = null;
            while (!PathUtils.isEmptyPath((String)parentPath)) {
                progress.setWorkRemaining(100);
                relativePath = PathUtils.appendPath((String)PathUtils.getBaseName((String)parentPath), (String)relativePath);
                parentPath = PathUtils.getParentFolderPath((String)parentPath);
                parent = this.ancestorFileView.locate(parentPath, (IProgressMonitor)progress.newChild(5));
                resource = this.findResourceFromShareable((IVersionableHandle)parent, (IProgressMonitor)progress.newChild(5));
                if (resource == null) continue;
                if (resource.getType() == 1) {
                    return null;
                }
                if (handle instanceof IFileItemHandle) {
                    return ((IContainer)resource).getFile((IPath)new Path(relativePath));
                }
                if (!(handle instanceof IFolderHandle)) continue;
                return ((IContainer)resource).getFolder((IPath)new Path(relativePath));
            }
        }
        return this.findResourceForRemoteHandle(handle, progress);
    }

    private IResource findResourceForRemoteHandle(IVersionableHandle handle, SubMonitor progress) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException, FileSystemException {
        List reports = this.remoteFileView.determineAncestorsInHistory(Collections.singletonList(handle), (IProgressMonitor)progress.newChild(5));
        IAncestorReport ancestorReport = (IAncestorReport)reports.get(0);
        List ancestors = ancestorReport.getNameItemPairs();
        if (ancestors.size() > 0) {
            String relativePath = ((INameItemPair)ancestors.get(ancestors.size() - 1)).getName();
            int i = ancestors.size() - 2;
            while (i >= 0) {
                INameItemPair nameItemPair = (INameItemPair)ancestors.get(i);
                IResource resource = this.findResourceFromShareable(nameItemPair.getItem(), (IProgressMonitor)progress.newChild(10));
                if (resource != null) {
                    if (resource.getType() == 1) {
                        return null;
                    }
                    if (handle instanceof IFileItemHandle) {
                        return ((IContainer)resource).getFile((IPath)new Path(relativePath));
                    }
                    if (handle instanceof IFolderHandle) {
                        return ((IContainer)resource).getFolder((IPath)new Path(relativePath));
                    }
                }
                relativePath = PathUtils.appendPath((String)nameItemPair.getName(), (String)relativePath);
                --i;
            }
        }
        return null;
    }

    private IResource findResourceFromShareable(IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemException {
        for (ICopyFileArea cfa : this.copyFileAreasToUpdate) {
            Object adapter;
            Sandbox sandbox = new Sandbox(cfa);
            IShareable shareable = sandbox.findShareable(this.getConnection().getContextHandle(), this.componentHandle, handle, monitor);
            if (shareable == null || !((adapter = shareable.getAdapter(IResource.class)) instanceof IResource)) continue;
            IResource resource = (IResource)adapter;
            return resource;
        }
        return null;
    }

    public IDiff getDiff(IResource resource, SubMonitor monitor) throws FileSystemException, TeamRepositoryException {
        IItemConflictReport conflict;
        IVersionableHandle state;
        IPath moveToPath;
        IPath moveFromPath;
        int kind;
        int flags;
        if (resource.getType() != 1) {
            return null;
        }
        IFileRevision ancestorRevision = null;
        IVersionableHandle ancestorState = null;
        SCMResourceDiff local = null;
        SCMResourceDiff remote = null;
        if (this.hasLocalChange(resource, monitor.newChild(1))) {
            ancestorState = this.getAncestorState(resource, monitor.newChild(1));
            IVersionableHandle localState = this.getLocalState(resource, monitor.newChild(1));
            ancestorRevision = this.getFileRevision(ancestorState, monitor.newChild(1));
            IFileRevision after = FileRevision.getFileRevisionFor((IFile)((IFile)resource));
            flags = 256;
            kind = ancestorRevision == null || !ancestorRevision.exists() ? 1 : (after == null || !after.exists() ? 2 : 4);
            moveFromPath = null;
            moveToPath = null;
            if (ancestorState == null || localState == null || !ancestorState.sameItemId((IItemHandle)localState)) {
                if (!(localState == null || ancestorState != null && ancestorState.sameItemId((IItemHandle)localState) || (moveFromPath = this.getLocalMoveFromPath(resource, localState, monitor.newChild(1))) == null)) {
                    flags |= 0x200;
                }
                if (!(ancestorState == null || localState != null && ancestorState.sameItemId((IItemHandle)localState) || (moveToPath = this.getLocalMoveToPath(resource, ancestorState, monitor.newChild(1))) == null)) {
                    flags |= 0x400;
                }
            }
            local = new SCMResourceDiff(resource, kind, flags, ancestorRevision, after, moveFromPath, moveToPath);
            state = localState == null ? ancestorState : localState;
            conflict = this.conflicts.get(state.getItemId());
            if (conflict != null) {
                local.setConflict(conflict);
            }
        }
        if (this.hasRemoteChange(resource, monitor.newChild(1))) {
            if (ancestorState == null) {
                ancestorState = this.getAncestorState(resource, monitor.newChild(1));
            }
            if (ancestorRevision == null) {
                ancestorRevision = this.getFileRevision(ancestorState, monitor.newChild(1));
            }
            IVersionableHandle remoteState = this.getRemoteState(resource, monitor.newChild(1));
            IFileRevision remoteRevision = this.getFileRevision(remoteState, monitor.newChild(1));
            flags = 256;
            kind = ancestorRevision == null || !ancestorRevision.exists() ? 1 : (remoteRevision == null || !remoteRevision.exists() ? 2 : 4);
            moveFromPath = null;
            moveToPath = null;
            if (ancestorState == null || remoteState == null || !ancestorState.sameItemId((IItemHandle)remoteState)) {
                if (!(remoteState == null || ancestorState != null && ancestorState.sameItemId((IItemHandle)remoteState) || (moveFromPath = this.getRemoteMoveFromPath(resource, remoteState, monitor.newChild(1))) == null || moveFromPath.equals((Object)resource.getFullPath()))) {
                    flags |= 0x200;
                }
                if (!(ancestorState == null || remoteState != null && ancestorState.sameItemId((IItemHandle)remoteState) || (moveToPath = this.getRemoteMoveToPath(resource, ancestorState, monitor.newChild(1))) == null || moveToPath.equals((Object)resource.getFullPath()))) {
                    flags |= 0x400;
                }
            }
            remote = new SCMResourceDiff(resource, kind, flags, ancestorRevision, remoteRevision, moveFromPath, moveToPath);
            state = remoteState == null ? ancestorState : remoteState;
            conflict = this.conflicts.get(state.getItemId());
            if (conflict != null) {
                remote.setConflict(conflict);
            }
        }
        if (local != null || remote != null) {
            return new ThreeWayDiff(local, remote);
        }
        return null;
    }

    private IPath getRemoteMoveToPath(IResource resource, IVersionableHandle ancestorState, SubMonitor monitor) throws ComponentNotInWorkspaceException, TeamRepositoryException, FileSystemException {
        try {
            Object adapter;
            IShareable shareable;
            IVersionable remoteItem = this.remoteFileView.getItem(ancestorState, monitor.newChild(1));
            if (remoteItem != null && (shareable = this.remoteFileView.getShareable((IVersionableHandle)remoteItem, monitor.newChild(1))) != null && (adapter = shareable.getAdapter(IResource.class)) instanceof IResource) {
                return ((IResource)adapter).getFullPath();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private IPath getRemoteMoveFromPath(IResource resource, IVersionableHandle remoteState, SubMonitor monitor) throws TeamRepositoryException, FileSystemException {
        try {
            Object adapter;
            IShareable shareable;
            IVersionable ancestorItem = this.ancestorFileView.getItem(remoteState, (IProgressMonitor)monitor.newChild(1));
            if (ancestorItem != null && (shareable = this.remoteFileView.getShareable((IVersionableHandle)ancestorItem.getParent(), monitor.newChild(1))) != null && (adapter = shareable.getAdapter(IResource.class)) instanceof IResource) {
                return ((IResource)adapter).getFullPath().append(ancestorItem.getName());
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private IPath getLocalMoveToPath(IResource resource, IVersionableHandle ancestorState, SubMonitor monitor) throws FileSystemException {
        IResource source = this.findResourceFromShareable(ancestorState, (IProgressMonitor)monitor.newChild(1));
        if (source != null) {
            return source.getFullPath();
        }
        return null;
    }

    private IPath getLocalMoveFromPath(IResource resource, IVersionableHandle localState, SubMonitor monitor) throws TeamRepositoryException, FileSystemException {
        try {
            IVersionable ancestorItem = this.ancestorFileView.getItem(localState, (IProgressMonitor)monitor.newChild(1));
            if (ancestorItem != null) {
                IFolderHandle parent = ancestorItem.getParent();
                String relativePath = ancestorItem.getName();
                while (parent != null) {
                    IResource parentResource = this.findResourceFromShareable((IVersionableHandle)parent, (IProgressMonitor)monitor.newChild(1));
                    if (parentResource != null) {
                        return parentResource.getFullPath().append(relativePath);
                    }
                    IVersionable parentItem = this.ancestorFileView.getItem((IVersionableHandle)parent, (IProgressMonitor)monitor.newChild(1));
                    relativePath = PathUtils.appendPath((String)parentItem.getName(), (String)relativePath);
                    parent = parentItem.getParent();
                }
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private IFileRevision getFileRevision(IVersionableHandle state, SubMonitor monitor) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        IFileItem fileItem = this.getFileItem(state, monitor);
        if (fileItem != null) {
            return new SCMFileRevision(this, fileItem);
        }
        return null;
    }

    private void reportException(String message, Exception e) {
        StatusUtil.log((Object)this, (String)message, (Throwable)e);
    }
}

