/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.query.baselines;

import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.baselines.BaselineQueryEditorInput;
import com.ibm.team.filesystem.ui.operations.query.CreateQueryItemOperation;
import com.ibm.team.filesystem.ui.operations.query.EditBaselineQueryOperation;
import com.ibm.team.filesystem.ui.operations.query.EditQueryItemOperation;
import com.ibm.team.filesystem.ui.operations.query.NewBaselineQueryOperation;
import com.ibm.team.filesystem.ui.wrapper.BaselineQueryWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchCriteria;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;

public class BaselineQueryWorkingCopy
extends ScmQueryWorkingCopy {
    public BaselineQueryWorkingCopy(Object editorInput, IOperationRunner runner, Shell shell) {
        super(editorInput, Messages.BaselineQueryWorkingCopy_WORKING_COPY_NAME, runner, shell);
    }

    @Override
    protected void validateEditorInputType(Object editorInput) throws IllegalArgumentException {
        if (!(editorInput instanceof BaselineQueryEditorInput)) {
            throw new IllegalArgumentException(Messages.BaselineQueryWorkingCopy_INVALID_EDITOR_INPUT_TYPE_MSG);
        }
    }

    public BaselineQueryWrapper getBaselineQueryWrapper() {
        return (BaselineQueryWrapper)this.getQueryItemWrapper();
    }

    @Override
    public String getNewQueryName() {
        return Messages.BaselineQueryWorkingCopy_NEW_QUERY_NAME;
    }

    @Override
    public AbstractSearchInput getQuerySearchCriteria() {
        if (this.fQuerySearchCriteria != null) {
            return this.fQuerySearchCriteria;
        }
        ITeamRepository originalRepo = this.getOriginalRepository();
        IBaselineSearchCriteria originalSearchCriteria = this.getOriginalBaselineSearchCriteria();
        if (originalRepo != null && originalSearchCriteria != null) {
            return BaselineSearchCriteria.createFromSearchCriteriaDTO(originalRepo, originalSearchCriteria);
        }
        return null;
    }

    public BaselineSearchCriteria getBaselineSearchCriteria() {
        return (BaselineSearchCriteria)this.getQuerySearchCriteria();
    }

    public IBaselineSearchCriteria getOriginalBaselineSearchCriteria() {
        return (IBaselineSearchCriteria)this.getOriginalQuerySearchCriteria();
    }

    @Override
    public IStatus validateForSave() {
        if (!super.validateForSave().isOK()) {
            return super.validateForSave();
        }
        if (!this.isSearchCriteriaValid()) {
            BaselineSearchCriteria criteria = this.getBaselineSearchCriteria();
            String message = criteria != null && criteria.getComponentHandle() == null ? Messages.BaselineQueryWorkingCopy_SEARCH_CRITERIA_MISSING_COMP_MSG : Messages.BaselineQueryWorkingCopy_SEARCH_CRITERIA_INCOMPLETE_MSG;
            return StatusUtil.newStatus((Object)((Object)this), (String)message);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isSearchCriteriaValid() {
        if (!super.isSearchCriteriaValid()) {
            return false;
        }
        BaselineSearchCriteria criteria = this.getBaselineSearchCriteria();
        return criteria == null ? false : criteria.isValid();
    }

    @Override
    public CreateQueryItemOperation getNewScmQueryOperation() {
        return new NewBaselineQueryOperation(this);
    }

    @Override
    public EditQueryItemOperation getEditScmQueryOperation() {
        return new EditBaselineQueryOperation(this);
    }
}

