/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.query;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryEditorInput;
import com.ibm.team.filesystem.ui.operations.query.CreateQueryItemOperation;
import com.ibm.team.filesystem.ui.operations.query.EditQueryItemOperation;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.ProcessAreaWrapper;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import com.ibm.team.scm.common.IQueryCriteria;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ISearchCriteria;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public abstract class ScmQueryWorkingCopy
extends ScmItemWorkingCopy {
    private MODE fMode;
    private boolean fIsBusy;
    private ITeamRepository fOriginalRepository;
    private QueryItemWrapper fOriginalQueryItemWrapper;
    private QueryItemWrapper fQueryItemWrapper;
    private String fOriginalQueryName = "";
    private String fQueryName;
    private String fOriginalQueryDescription = "";
    private String fQueryDescription;
    private IAuditable fOriginalQueryOwner;
    private IAuditable fQueryOwner;
    private IAuditable fOriginalQueryParentOwner;
    private IAuditable fQueryParentOwner;
    private IReadScope fOriginalQueryReadScope;
    private IReadScope fQueryReadScope;
    protected AbstractSearchInput fQuerySearchCriteria;
    protected ISearchCriteria fOriginalQuerySearchCriteria;
    private int fBusyCounter = 0;
    protected ISharedItemChangeListener fItemListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (Object event : events) {
                boolean nameChanged;
                QueryItemWrapper currentWrapper;
                ISharedItemChangeEvent changeEvent;
                if (!(event instanceof ISharedItemChangeEvent) || (changeEvent = (ISharedItemChangeEvent)event).getSharedItem().getItemType() != IQueryItem.ITEM_TYPE || (currentWrapper = ScmQueryWorkingCopy.this.getQueryItemWrapper()) == null) continue;
                IQueryItem query = currentWrapper.getQueryItem();
                if (!changeEvent.getSharedItem().sameItemId((IItemHandle)query)) continue;
                IQueryItem beforeState = (IQueryItem)changeEvent.getBeforeState();
                IQueryItem afterState = (IQueryItem)changeEvent.getAfterState();
                if (beforeState == null || afterState == null) continue;
                boolean bl = nameChanged = !beforeState.getName().equals(afterState.getName());
                boolean descChanged = !(beforeState.getDescription() == null ? afterState.getDescription() == null : beforeState.getDescription().equals(afterState.getDescription()));
                boolean ownerChanged = !beforeState.getOwner().sameItemId((IItemHandle)afterState.getOwner());
                boolean visibilityChanged = !ReadScopeUtils.equals((IReadScope)beforeState.getReadScope(), (IReadScope)afterState.getReadScope());
                boolean searchCriteriaChanged = false;
                if (beforeState.getSearchCriteria() == null) {
                    searchCriteriaChanged = afterState.getSearchCriteria() != null;
                } else {
                    IQueryCriteria afterCriteria = null;
                    if (afterState.getSearchCriteria() != null) {
                        afterCriteria = afterState.getSearchCriteria().asQueryCriteria();
                    }
                    boolean bl2 = searchCriteriaChanged = !beforeState.getSearchCriteria().asQueryCriteria().sameAs(afterCriteria);
                }
                if (!nameChanged && !descChanged && !ownerChanged && !visibilityChanged && !searchCriteriaChanged) continue;
                ScmQueryWorkingCopy.this.synchronizeToRepository();
                return;
            }
        }
    };

    public ScmQueryWorkingCopy(Object editorInput, String name, IOperationRunner runner, Shell shell) {
        super(name, runner, shell);
        this.init(editorInput);
    }

    protected abstract void validateEditorInputType(Object var1) throws IllegalArgumentException;

    private void init(Object editorInput) {
        this.validateEditorInputType(editorInput);
        ScmQueryEditorInput input = (ScmQueryEditorInput)editorInput;
        this.setOriginalRepository(input.getRepository());
        this.setParentFolder((IItemContainerHandle)input.getParentFolder());
        this.setShouldAddToRootFolder(input.shouldAddToRootFolder());
        this.setFolderOwner(input.getFolderOwner());
        if (input.isCreation()) {
            AbstractWrapper owner;
            this.setMode(MODE.NEW_QUERY);
            IReadScope readScope = null;
            if (input.getQueryItemWrapper() != null) {
                QueryItemWrapper wrapper = input.getQueryItemWrapper();
                this.setOriginalQueryItemWrapper(wrapper);
                this.setOriginalQueryName(NLS.bind((String)Messages.ScmQueryWorkingCopy_DuplicatedQueryName, (Object)wrapper.getQueryItem().getName()));
                this.setOriginalQueryDescription(wrapper.getQueryItem().getDescription());
                this.setOriginalQuerySearchCriteria((ISearchCriteria)wrapper.getQueryItem().getSearchCriteria());
            }
            if ((owner = input.getOwner()) instanceof ProcessAreaWrapper) {
                ProcessAreaWrapper tw = (ProcessAreaWrapper)input.getOwner();
                this.setQueryOwner((IAuditable)tw.getItem());
                readScope = IReadScope.FACTORY.createProcessAreaScope();
            }
            if (owner instanceof ContributorWrapper) {
                ContributorWrapper cw = (ContributorWrapper)owner;
                this.setQueryOwner((IAuditable)cw.getContributor());
                readScope = IReadScope.FACTORY.createPrivateScope();
            }
            if (input.getReadScope() != null) {
                readScope = input.getReadScope();
            }
            this.setQueryReadScope(readScope);
            this.initForCreation();
        } else {
            this.setMode(MODE.EDIT_QUERY);
            QueryItemWrapper queryWrapper = input.getQueryItemWrapper();
            this.setQueryItemWrapper(queryWrapper);
            this.setOriginalQueryName(queryWrapper.getQueryItem().getName());
            this.setOriginalQueryDescription(queryWrapper.getQueryItem().getDescription());
            this.setOriginalQuerySearchCriteria((ISearchCriteria)queryWrapper.getQueryItem().getSearchCriteria());
            this.setOriginalQueryReadScope(queryWrapper.getQueryItem().getReadScope());
            this.initForEdit();
            this.setDirty(false);
        }
        this.setValid(this.checkValid());
    }

    private void initForCreation() {
        if (this.getOriginalQueryItemWrapper() != null) {
            this.initializeFromOriginal(this.getOriginalQueryItemWrapper());
            this.stateChanged();
            this.setDirty(true);
        }
    }

    private void initializeFromOriginal(final QueryItemWrapper originalQuery) {
        if (originalQuery == null) {
            return;
        }
        UIOperation<QueryItemData> op = new UIOperation<QueryItemData>(this){

            @Override
            protected QueryItemData runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    return ScmQueryWorkingCopy.loadFromRepository(originalQuery, true, monitor);
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(QueryItemData queryItemData) {
                if (queryItemData != null) {
                    this.setOriginalQueryName(NLS.bind((String)Messages.ScmQueryWorkingCopy_DuplicatedQueryName, (Object)queryItemData.getName()));
                    this.setOriginalQueryDescription(queryItemData.getDescription());
                    this.setOriginalQueryOwner(queryItemData.getOwner());
                    this.setOriginalQueryParentOwner(queryItemData.getParentOwner());
                    this.setOriginalQueryReadScope(queryItemData.getReadScope());
                    this.setOriginalQuerySearchCriteria(queryItemData.getSearchCriteria());
                }
                this.setDirty(true);
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.ScmQueryWorkingCopy_LOADING_QUERY_JOB_NAME, (Object)originalQuery.getQueryItem().getName()));
    }

    private void initForEdit() {
        final QueryItemWrapper queryWrapper = this.getQueryItemWrapper();
        if (queryWrapper == null) {
            return;
        }
        UIOperation<QueryItemData> op = new UIOperation<QueryItemData>(this){

            @Override
            protected QueryItemData runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    QueryItemData result = ScmQueryWorkingCopy.loadFromRepository(queryWrapper, true, monitor);
                    ITeamRepository repoToListenTo = queryWrapper.getRepository();
                    repoToListenTo.itemManager().addItemChangeListener(IQueryItem.ITEM_TYPE, fItemListener);
                    return result;
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(QueryItemData queryItemData) {
                if (queryItemData != null) {
                    this.setOriginalQueryName(queryItemData.getName());
                    this.setOriginalQueryDescription(queryItemData.getDescription());
                    this.setOriginalQueryOwner(queryItemData.getOwner());
                    this.setOriginalQueryParentOwner(queryItemData.getParentOwner());
                    this.setOriginalQueryReadScope(queryItemData.getReadScope());
                    this.setOriginalQuerySearchCriteria(queryItemData.getSearchCriteria());
                }
                this.setDirty(false);
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.ScmQueryWorkingCopy_LOADING_QUERY_JOB_NAME, (Object)queryWrapper.getQueryItem().getName()));
    }

    protected void synchronizeToRepository() {
        final QueryItemWrapper queryItemWrapper = this.getQueryItemWrapper();
        if (queryItemWrapper == null) {
            return;
        }
        UIOperation<QueryItemData> op = new UIOperation<QueryItemData>(this){

            @Override
            protected QueryItemData runInBackground(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                try {
                    return ScmQueryWorkingCopy.loadFromRepository(queryItemWrapper, false, reporter);
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(QueryItemData queryItemData) {
                if (queryItemData != null) {
                    this.setOriginalQueryName(queryItemData.getName());
                    this.setOriginalQueryDescription(queryItemData.getDescription());
                    this.setOriginalQueryOwner(queryItemData.getOwner());
                    this.setOriginalQueryParentOwner(queryItemData.getParentOwner());
                    this.setOriginalQueryReadScope(queryItemData.getReadScope());
                    this.setOriginalQuerySearchCriteria(queryItemData.getSearchCriteria());
                }
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.ScmQueryWorkingCopy_UPDATING_QUERY_JOB_NAME, (Object)queryItemWrapper.getQueryItem().getName()));
    }

    private static QueryItemData loadFromRepository(QueryItemWrapper queryWrapper, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String queryItemName = "";
        String queryItemDescription = "";
        IAuditable queryItemOwner = null;
        IAuditable parentOwner = null;
        IReadScope queryItemReadScope = null;
        IItemSearchCriteria searchCriteria = null;
        int refreshFlag = refresh ? 1 : 0;
        ITeamRepository repo = queryWrapper.getRepository();
        IQueryItem queryItem = queryWrapper.getQueryItem();
        if (!repo.loggedIn()) {
            repo.login((IProgressMonitor)progress.newChild(15));
        }
        progress.setWorkRemaining(85);
        IItemManager itemManager = repo.itemManager();
        IQueryItem fetchedQueryItem = null;
        fetchedQueryItem = (IQueryItem)itemManager.fetchCompleteItem(queryItem.getItemHandle(), refreshFlag, (IProgressMonitor)progress.newChild(15));
        if (fetchedQueryItem != null) {
            queryItemName = fetchedQueryItem.getName();
            queryItemDescription = fetchedQueryItem.getDescription();
            try {
                IAuditableHandle ownerHandle = fetchedQueryItem.getOwner();
                queryItemOwner = (IAuditable)itemManager.fetchCompleteItem((IItemHandle)ownerHandle, refreshFlag, (IProgressMonitor)progress.newChild(20));
            }
            catch (ItemNotFoundException ownerHandle) {
                // empty catch block
            }
            progress.setWorkRemaining(35);
            try {
                if (queryItemOwner instanceof ITeamArea) {
                    IProcessArea teamArea = (IProcessArea)queryItemOwner;
                    parentOwner = (IAuditable)itemManager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), refreshFlag, (IProgressMonitor)progress.newChild(20));
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            queryItemReadScope = fetchedQueryItem.getReadScope();
            searchCriteria = fetchedQueryItem.getSearchCriteria();
        }
        return new QueryItemData(queryItemName, queryItemDescription, queryItemOwner, parentOwner, queryItemReadScope, (ISearchCriteria)searchCriteria);
    }

    public MODE getMode() {
        return this.fMode;
    }

    public boolean isInMode(MODE mode) {
        return this.fMode == mode;
    }

    protected void setMode(MODE newMode) {
        this.fMode = newMode;
    }

    @Override
    public boolean isBusy() {
        return this.fIsBusy;
    }

    @Override
    public boolean isCreation() {
        return this.fMode.isCreation();
    }

    public String getToolTipText() {
        return this.fQueryName != null ? this.fQueryName : this.getOriginalQueryName();
    }

    public abstract String getNewQueryName();

    public String getOriginalQueryName() {
        return this.fOriginalQueryName;
    }

    protected void setOriginalQueryName(String name) {
        Assert.isNotNull((Object)name);
        if (!name.equals(this.fOriginalQueryName)) {
            String currentName = this.getQueryName();
            this.fOriginalQueryName = name;
            if (currentName == null && this.getQueryName() != null || currentName != null && !currentName.equals(this.getQueryName())) {
                this.notifyListeners((Object)PROPERTY.QUERY_NAME);
            }
        }
    }

    public String getQueryName() {
        return this.fQueryName != null ? this.fQueryName : this.getOriginalQueryName();
    }

    public void setQueryName(String newName) {
        if (newName != null && (newName = newName.trim()).length() == 0) {
            newName = null;
        }
        if (this.fOriginalQueryName != null && this.fOriginalQueryName.equals(newName)) {
            newName = null;
        }
        if (newName == null && this.fQueryName != null || newName != null && !newName.equals(this.fQueryName)) {
            String oldName = this.getQueryName();
            this.fQueryName = newName;
            this.stateChanged();
            if (oldName == null && this.getQueryName() != null || oldName != null && !oldName.equals(this.getQueryName())) {
                this.notifyListeners((Object)PROPERTY.QUERY_NAME);
            }
        }
    }

    private String getOriginalQueryDescription() {
        return this.fOriginalQueryDescription;
    }

    protected void setOriginalQueryDescription(String text) {
        Assert.isNotNull((Object)text);
        if (!text.equals(this.fOriginalQueryDescription)) {
            String currentDescription = this.getQueryDescription();
            this.fOriginalQueryDescription = text;
            if (currentDescription == null && this.getQueryDescription() != null || currentDescription != null && !currentDescription.equals(this.getQueryDescription())) {
                this.notifyListeners((Object)PROPERTY.QUERY_DESCRIPTION);
            }
        }
    }

    public String getQueryDescription() {
        return this.fQueryDescription != null ? this.fQueryDescription : this.getOriginalQueryDescription();
    }

    public void setQueryDescription(String newDescription) {
        if (this.fOriginalQueryDescription != null && this.fOriginalQueryDescription.equals(newDescription)) {
            newDescription = null;
        }
        if (newDescription == null && this.fQueryDescription != null || newDescription != null && !newDescription.equals(this.fQueryDescription)) {
            String oldDescription = this.getQueryDescription();
            this.fQueryDescription = newDescription;
            this.stateChanged();
            if (oldDescription == null && this.getQueryDescription() != null || oldDescription != null && !oldDescription.equals(this.getQueryDescription())) {
                this.notifyListeners((Object)PROPERTY.QUERY_DESCRIPTION);
            }
        }
    }

    public IAuditable getOriginalQueryOwner() {
        return this.fOriginalQueryOwner;
    }

    protected void setOriginalQueryOwner(IAuditable owner) {
        if (owner == null ? this.fOriginalQueryOwner != null : !owner.sameItemId((IItemHandle)this.fOriginalQueryOwner)) {
            IAuditable currentOwner = this.getQueryOwner();
            this.fOriginalQueryOwner = owner;
            if (currentOwner == null && this.getQueryOwner() != null || currentOwner != null && !currentOwner.equals((Object)this.getQueryOwner())) {
                this.notifyListeners((Object)PROPERTY.QUERY_OWNER);
            }
        }
    }

    public IAuditable getQueryOwner() {
        return this.fQueryOwner != null ? this.fQueryOwner : this.getOriginalQueryOwner();
    }

    public void setQueryOwner(IAuditable newOwner) {
        if (this.fOriginalQueryOwner != null && this.fOriginalQueryOwner.sameItemId((IItemHandle)newOwner)) {
            newOwner = null;
        }
        if (newOwner == null && this.fQueryOwner != null || newOwner != null && !newOwner.sameItemId((IItemHandle)this.fQueryOwner)) {
            IAuditable oldOwner = this.getQueryOwner();
            this.fQueryOwner = newOwner;
            this.stateChanged();
            if (oldOwner == null && this.getQueryOwner() != null || oldOwner != null && !oldOwner.sameItemId((IItemHandle)this.getQueryOwner())) {
                this.notifyListeners((Object)PROPERTY.QUERY_OWNER);
            }
        }
    }

    public IAuditable getOriginalQueryParentOwner() {
        return this.fOriginalQueryParentOwner;
    }

    protected void setOriginalQueryParentOwner(IAuditable parentOwner) {
        Assert.isLegal((parentOwner == null || parentOwner instanceof IProjectArea ? 1 : 0) != 0);
        if (parentOwner == null ? this.fOriginalQueryParentOwner != null : !parentOwner.sameItemId((IItemHandle)this.fOriginalQueryParentOwner)) {
            IAuditable currentParentOwner = this.getQueryParentOwner();
            this.fOriginalQueryParentOwner = parentOwner;
            if (currentParentOwner == null && this.getQueryParentOwner() != null || currentParentOwner != null && !currentParentOwner.equals((Object)this.getQueryParentOwner())) {
                this.notifyListeners((Object)PROPERTY.QUERY_VISIBILITY);
            }
        }
    }

    public IAuditable getQueryParentOwner() {
        return this.fQueryParentOwner != null ? this.fQueryParentOwner : this.getOriginalQueryParentOwner();
    }

    public void setParentOwner(IAuditable newParentOwner) {
        if (this.fOriginalQueryParentOwner != null && this.fOriginalQueryParentOwner.sameItemId((IItemHandle)newParentOwner)) {
            newParentOwner = null;
        }
        Assert.isLegal((newParentOwner == null || newParentOwner instanceof IProjectArea ? 1 : 0) != 0);
        if (newParentOwner == null && this.fQueryParentOwner != null || newParentOwner != null && !newParentOwner.sameItemId((IItemHandle)this.fQueryParentOwner)) {
            IAuditable oldParentOwner = this.getQueryParentOwner();
            this.fQueryParentOwner = newParentOwner;
            this.stateChanged();
            if (oldParentOwner == null && this.getQueryParentOwner() != null || oldParentOwner != null && !oldParentOwner.equals((Object)this.getQueryParentOwner())) {
                this.notifyListeners((Object)PROPERTY.QUERY_VISIBILITY);
            }
        }
    }

    public IReadScope getOriginalQueryReadScope() {
        return this.fOriginalQueryReadScope;
    }

    protected void setOriginalQueryReadScope(IReadScope readScope) {
        if (readScope == null ? this.fOriginalQueryReadScope != null : !ReadScopeUtils.equals((IReadScope)readScope, (IReadScope)this.fOriginalQueryReadScope)) {
            IReadScope currentReadScope = this.getQueryReadScope();
            this.fOriginalQueryReadScope = readScope;
            if (currentReadScope == null && this.getQueryReadScope() != null || currentReadScope != null && !ReadScopeUtils.equals((IReadScope)currentReadScope, (IReadScope)this.getQueryReadScope())) {
                this.notifyListeners((Object)PROPERTY.QUERY_VISIBILITY);
            }
        }
    }

    public IReadScope getQueryReadScope() {
        return this.fQueryReadScope != null ? this.fQueryReadScope : this.getOriginalQueryReadScope();
    }

    public void setQueryReadScope(IReadScope newReadScope) {
        if (ReadScopeUtils.equals((IReadScope)newReadScope, (IReadScope)this.fOriginalQueryReadScope)) {
            newReadScope = null;
        }
        if (!ReadScopeUtils.equals((IReadScope)newReadScope, (IReadScope)this.fQueryReadScope)) {
            IReadScope oldReadScope = this.getQueryReadScope();
            this.fQueryReadScope = newReadScope;
            this.stateChanged();
            if (!ReadScopeUtils.equals((IReadScope)this.getQueryReadScope(), (IReadScope)oldReadScope)) {
                this.notifyListeners((Object)PROPERTY.QUERY_VISIBILITY);
            }
        }
    }

    public ISearchCriteria getOriginalQuerySearchCriteria() {
        return this.fOriginalQuerySearchCriteria;
    }

    protected void setOriginalQuerySearchCriteria(ISearchCriteria searchCriteria) {
        Assert.isNotNull((Object)searchCriteria);
        boolean isDifferent = false;
        if (searchCriteria instanceof IItemSearchCriteria) {
            if (this.fOriginalQuerySearchCriteria == null) {
                isDifferent = true;
            } else if (this.fOriginalQuerySearchCriteria instanceof IItemSearchCriteria) {
                IItemSearchCriteria newOriginal = (IItemSearchCriteria)searchCriteria;
                IItemSearchCriteria oldOriginal = (IItemSearchCriteria)this.fOriginalQuerySearchCriteria;
                isDifferent = !newOriginal.asQueryCriteria().sameAs(oldOriginal.asQueryCriteria());
            } else {
                isDifferent = true;
            }
        } else if (searchCriteria != this.fOriginalQuerySearchCriteria) {
            isDifferent = true;
        }
        if (isDifferent) {
            AbstractSearchInput currentSearchCriteria = this.getQuerySearchCriteria();
            this.fOriginalQuerySearchCriteria = searchCriteria;
            if (currentSearchCriteria == null && this.getQuerySearchCriteria() != null || currentSearchCriteria != null && !currentSearchCriteria.isEquivalentTo(this.getQuerySearchCriteria())) {
                this.notifyListeners((Object)PROPERTY.QUERY_SEARCH_CRITERIA);
            }
        }
    }

    public abstract AbstractSearchInput getQuerySearchCriteria();

    public void setQuerySearchCriteria(AbstractSearchInput newSearchCriteria) {
        boolean wasNewSearchCriteriaNull;
        boolean bl = wasNewSearchCriteriaNull = newSearchCriteria == null;
        if (newSearchCriteria != null && newSearchCriteria.isEquivalentTo(this.fOriginalQuerySearchCriteria)) {
            newSearchCriteria = null;
        }
        if (newSearchCriteria != null && this.fQuerySearchCriteria == null || this.fQuerySearchCriteria != null && !this.fQuerySearchCriteria.isEquivalentTo(newSearchCriteria)) {
            AbstractSearchInput oldSearchCriteria = this.getQuerySearchCriteria();
            this.fQuerySearchCriteria = newSearchCriteria;
            this.stateChanged();
            if (oldSearchCriteria == null && this.getQuerySearchCriteria() != null || oldSearchCriteria != null && !oldSearchCriteria.isEquivalentTo(this.getQuerySearchCriteria())) {
                this.notifyListeners((Object)PROPERTY.QUERY_SEARCH_CRITERIA);
                if (wasNewSearchCriteriaNull && oldSearchCriteria != null) {
                    this.notifyListeners((Object)PROPERTY.INIT_QUERY_SEARCH_CRITERIA);
                }
            }
        }
    }

    public boolean isSearchCriteriaValid() {
        return this.getQuerySearchCriteria() != null;
    }

    public ITeamRepository getOriginalRepository() {
        return this.fOriginalRepository;
    }

    public void setOriginalRepository(ITeamRepository originalRepository) {
        this.fOriginalRepository = originalRepository;
    }

    public QueryItemWrapper getOriginalQueryItemWrapper() {
        return this.fOriginalQueryItemWrapper;
    }

    protected void setOriginalQueryItemWrapper(QueryItemWrapper queryItemWrapper) {
        this.fOriginalQueryItemWrapper = queryItemWrapper;
    }

    public QueryItemWrapper getQueryItemWrapper() {
        return this.fQueryItemWrapper;
    }

    public void setQueryItemWrapper(QueryItemWrapper queryItemWrapper) {
        this.fQueryItemWrapper = queryItemWrapper;
    }

    private void stateChanged() {
        this.updateDirtyState();
        this.setValid(this.checkValid());
    }

    private void updateDirtyState() {
        boolean isDirty = this.isCreation() || this.fQuerySearchCriteria != null || this.fQueryName != null || this.fQueryDescription != null || this.fQueryOwner != null || this.fQueryParentOwner != null || this.fQueryReadScope != null;
        this.setDirty(isDirty);
    }

    public boolean checkValid() {
        return this.getQueryItemWrapper() != null && this.getQueryName() != null && this.getQueryName().length() > 0 && this.getQueryOwner() != null && this.getQueryReadScope() != null && this.isSearchCriteriaValid();
    }

    @Override
    public IStatus validateForSave() {
        if (this.getQueryName() == null || this.getQueryName().equals("")) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.ScmQueryWorkingCopy_QUERY_NAME_REQUIRED_MSG);
        }
        if (this.getQueryOwner() == null) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.ScmQueryWorkingCopy_QUERY_OWNER_REQUIRED_MSG);
        }
        if (this.getQueryReadScope() == null) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.ScmQueryWorkingCopy_QUERY_VISIBILITY_REQUIRED_MSG);
        }
        if (this.getQuerySearchCriteria() == null) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.ScmQueryWorkingCopy_QUERY_SEARCH_CRITERIA_REQUIRED_MSG);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void saveStarting() {
        this.setBusy(true);
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        StatusCollector problems = new StatusCollector();
        if (this.isInMode(MODE.NEW_QUERY)) {
            CreateQueryItemOperation op = this.getNewScmQueryOperation();
            if (op != null) {
                op.run(monitor, (IStatusCollector)problems);
            }
        } else if (this.isInMode(MODE.EDIT_QUERY)) {
            EditQueryItemOperation op = this.getEditScmQueryOperation();
            if (op != null) {
                op.run(monitor, (IStatusCollector)problems);
            }
        } else {
            Assert.isTrue((boolean)false, (String)Messages.ScmQueryWorkingCopy_UNEXPECTED_WORKING_COPY_MODE_MSG);
        }
        if (!problems.getStatus().isOK()) {
            StatusUtil.log((IStatus)problems.getStatus());
        }
    }

    public abstract CreateQueryItemOperation getNewScmQueryOperation();

    public abstract EditQueryItemOperation getEditScmQueryOperation();

    @Override
    public void saveSucceeded() {
        this.onSaved();
    }

    @Override
    public void saveDone() {
        this.setBusy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBusyCounter() {
        PROPERTY pROPERTY = PROPERTY.BUSY;
        synchronized (pROPERTY) {
            return this.fBusyCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementBusyCounter() {
        PROPERTY pROPERTY = PROPERTY.BUSY;
        synchronized (pROPERTY) {
            ++this.fBusyCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementBusyCounter() {
        PROPERTY pROPERTY = PROPERTY.BUSY;
        synchronized (pROPERTY) {
            --this.fBusyCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setBusy(boolean busy) {
        boolean toNotify = false;
        PROPERTY pROPERTY = PROPERTY.BUSY;
        synchronized (pROPERTY) {
            if (busy) {
                this.incrementBusyCounter();
            } else {
                this.decrementBusyCounter();
            }
            if (this.getBusyCounter() > 0) {
                if (!this.fIsBusy) {
                    toNotify = true;
                    this.fIsBusy = true;
                }
            } else if (this.fIsBusy) {
                toNotify = true;
                this.fIsBusy = false;
            }
        }
        if (toNotify) {
            this.notifyListeners((Object)PROPERTY.BUSY);
        }
    }

    @Override
    protected void onSaved() {
        if (this.isInMode(MODE.NEW_QUERY)) {
            this.setMode(MODE.EDIT_QUERY);
        }
        this.setOriginalQueryItemWrapper(null);
        this.setDirty(false);
    }

    @Override
    public void refresh() {
        if (this.isCreation()) {
            return;
        }
        this.reloadFromRepository();
        this.setDirty(false);
    }

    protected void reloadFromRepository() {
        this.setQueryName(null);
        this.setQueryDescription(null);
        this.setQueryOwner(null);
        this.setParentOwner(null);
        this.setQueryReadScope(null);
        this.init(ScmQueryEditor.getEditorInput(this.getQueryItemWrapper()));
        this.setQuerySearchCriteria(null);
    }

    @Override
    public void dispose() {
        QueryItemWrapper wrapper = this.getQueryItemWrapper();
        if (wrapper != null) {
            IItemManager itemManager = wrapper.getRepository().itemManager();
            itemManager.removeItemChangeListener(IQueryItem.ITEM_TYPE, this.fItemListener);
        }
        this.fItemListener = null;
        super.dispose();
    }

    public static enum MODE {
        NEW_QUERY(true),
        EDIT_QUERY(false);

        private boolean fIsCreation;

        private MODE(boolean isCreation) {
            this.fIsCreation = isCreation;
        }

        public boolean isCreation() {
            return this.fIsCreation;
        }
    }

    public static enum PROPERTY {
        QUERY_NAME,
        QUERY_DESCRIPTION,
        QUERY_OWNER,
        QUERY_VISIBILITY,
        QUERY_SEARCH_CRITERIA,
        INIT_QUERY_SEARCH_CRITERIA,
        BUSY;

    }

    protected static class QueryItemData {
        private String fName;
        private String fDescription;
        private IAuditable fOwner;
        private IAuditable fParentOwner;
        private IReadScope fReadScope;
        private ISearchCriteria fSearchCriteria;

        public QueryItemData(String name, String description, IAuditable owner, IAuditable parentOwner, IReadScope readScope, ISearchCriteria searchCriteria) {
            this.fName = name;
            this.fDescription = description;
            this.fOwner = owner;
            this.fParentOwner = parentOwner;
            this.fReadScope = readScope;
            this.fSearchCriteria = searchCriteria;
        }

        public String getName() {
            return this.fName;
        }

        public String getDescription() {
            return this.fDescription;
        }

        public IAuditable getOwner() {
            return this.fOwner;
        }

        public IAuditable getParentOwner() {
            return this.fParentOwner;
        }

        public IReadScope getReadScope() {
            return this.fReadScope;
        }

        public ISearchCriteria getSearchCriteria() {
            return this.fSearchCriteria;
        }
    }

    public abstract class UIOperation<BridgeType>
    implements Operation {
        public final void enqueue(IOperationRunner runner, String operationName) {
            if (runner != null) {
                ScmQueryWorkingCopy.this.setBusy(true);
                runner.enqueue(operationName, (Operation)this);
            }
        }

        public final void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
            try {
                final BridgeType result = this.runInBackground(monitor, problems);
                ScmQueryWorkingCopy.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UIOperation.this.updateUI(result);
                        }
                        finally {
                            ScmQueryWorkingCopy.this.setBusy(false);
                        }
                    }
                });
            }
            catch (OperationFailedException e) {
                ScmQueryWorkingCopy.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScmQueryWorkingCopy.this.setBusy(false);
                    }
                });
                throw e;
            }
        }

        protected abstract BridgeType runInBackground(IProgressMonitor var1, IStatusCollector var2) throws OperationFailedException;

        protected abstract void updateUI(BridgeType var1);
    }
}

