/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.query;

import com.ibm.team.filesystem.ide.ui.internal.actions.search.AbstractSearchAction;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorPage;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryWorkingCopy;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.parts.NullMnemonicGenerator;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.AbstractControlSite;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ScmQuerySearchCriteriaPage
extends ScmItemEditorPage {
    private ScmQueryWorkingCopy fWorkingCopy;
    private Composite fPageBody;
    private Section fSearchCriteriaSection;
    private AbstractSearchCriteriaPart fSearchCriteriaPart;
    private AbstractSearchCriteriaPart.ISearchCriteriaListener fUIChangeListener;
    private IChangeListener fChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == ScmQueryWorkingCopy.PROPERTY.INIT_QUERY_SEARCH_CRITERIA && ScmQuerySearchCriteriaPage.this.fSearchCriteriaSection != null) {
                ScmQuerySearchCriteriaPage.this.disposeUiChangeListener();
                ScmQuerySearchCriteriaPage.this.fSearchCriteriaSection.dispose();
                ScmQuerySearchCriteriaPage.this.fSearchCriteriaSection = ScmQuerySearchCriteriaPage.this.createSearchCriteriaSection(ScmQuerySearchCriteriaPage.this.fPageBody);
                ScmQuerySearchCriteriaPage.this.fSearchCriteriaSection.getParent().layout();
            }
            ScmQuerySearchCriteriaPage.this.updateEnablement();
        }
    };

    public ScmQuerySearchCriteriaPage(FormEditor editor, String pageId, ScmQueryWorkingCopy workingCopy, IOperationRunner runner) {
        super(editor, pageId, Messages.ScmQuerySearchCriteriaPage_PAGE_TITLE, runner);
        this.fWorkingCopy = workingCopy;
        this.fWorkingCopy.addListener(this.fChangeListener);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        this.fPageBody = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(this.fPageBody);
        this.fSearchCriteriaSection = this.createSearchCriteriaSection(this.fPageBody);
        this.updateEnablement();
    }

    public ScmQueryWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    protected ITeamRepository getDefaultRepository() {
        ITeamRepository repo = null;
        if (this.getWorkingCopy().getQueryItemWrapper() != null) {
            repo = this.getWorkingCopy().getQueryItemWrapper().getRepository();
        } else if (this.getEditorInput() instanceof ScmQueryEditorInput) {
            ScmQueryEditorInput input = (ScmQueryEditorInput)this.getEditorInput();
            repo = input.getRepository();
        }
        if (repo == null) {
            repo = AbstractSearchAction.getRepository(null);
        }
        return repo;
    }

    private Section createSearchCriteriaSection(Composite parent) {
        AbstractSearchCriteriaPart searchCriteriaPart;
        ScmQueryWorkingCopy workingCopy = this.getWorkingCopy();
        FileSystemEditorToolkit toolkit = (FileSystemEditorToolkit)this.getManagedForm().getToolkit();
        Section queryCriteriaSection = this.createSection(toolkit, parent, 256, Messages.ScmQuerySearchCriteriaPage_SEARCH_CRITERIA_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)queryCriteriaSection);
        Composite searchCriteriaComposite = toolkit.createComposite((Composite)queryCriteriaSection);
        queryCriteriaSection.setClient((Control)searchCriteriaComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(LayoutConstants.getSpacing()).applyTo(searchCriteriaComposite);
        EditorPageControlSite site = new EditorPageControlSite(searchCriteriaComposite);
        this.fSearchCriteriaPart = searchCriteriaPart = this.createSearchCriteriaPart(site);
        if (workingCopy.getOriginalQuerySearchCriteria() == null) {
            workingCopy.setQuerySearchCriteria((AbstractSearchInput)this.fSearchCriteriaPart.getResult());
        }
        this.fUIChangeListener = new AbstractSearchCriteriaPart.ISearchCriteriaListener(){

            @Override
            public void searchCriteriaUpdated() {
                Object part;
                if (!ScmQuerySearchCriteriaPage.this.fSearchCriteriaSection.isDisposed() && (part = ScmQuerySearchCriteriaPage.this.fSearchCriteriaPart.getResult()) != null) {
                    ScmQuerySearchCriteriaPage.this.getWorkingCopy().setQuerySearchCriteria((AbstractSearchInput)part);
                }
            }
        };
        this.fSearchCriteriaPart.addListener(this.fUIChangeListener);
        queryCriteriaSection.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (searchCriteriaPart != null && ScmQuerySearchCriteriaPage.this.fUIChangeListener != null) {
                    searchCriteriaPart.removeListener(ScmQuerySearchCriteriaPage.this.fUIChangeListener);
                }
            }
        });
        return queryCriteriaSection;
    }

    private void disposeUiChangeListener() {
        if (this.fSearchCriteriaPart != null && this.fUIChangeListener != null) {
            this.fSearchCriteriaPart.removeListener(this.fUIChangeListener);
        }
    }

    protected abstract AbstractSearchCriteriaPart createSearchCriteriaPart(EditorPageControlSite var1);

    private void updateEnablement() {
        if (this.fSearchCriteriaSection != null && this.fSearchCriteriaSection.isDisposed()) {
            return;
        }
        if (this.fSearchCriteriaPart != null) {
            boolean isBusy = this.fWorkingCopy.isBusy();
            boolean isCreation = this.fWorkingCopy.isCreation();
            this.fSearchCriteriaPart.setEnabled(!isBusy);
            RepositoryCombo repoCombo = this.fSearchCriteriaPart.getRepositoryCombo();
            if (repoCombo != null) {
                repoCombo.setEnabled(!isBusy && isCreation);
            }
        }
    }

    @Override
    public void dispose() {
        this.disposeUiChangeListener();
        this.fWorkingCopy.removeListener(this.fChangeListener);
        this.fWorkingCopy = null;
        this.fChangeListener = null;
        this.initialize(null);
        super.dispose();
    }

    protected class EditorPageControlSite
    extends AbstractControlSite {
        public EditorPageControlSite(Composite theControl) {
            super(theControl);
        }

        public void close() {
        }

        public void setStatus(IStatus statusMessage) {
        }

        public void setName(String newName) {
        }

        public void setContentDescription(String contentDescription) {
        }

        protected MnemonicGenerator createMnemonicGenerator() {
            return new MnemonicGenerator((IMnemonicGenerationAlgorithm)new NullMnemonicGenerator());
        }
    }
}

