/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.query;

import com.ibm.team.containers.common.IItemContainer;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IReadScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public abstract class ScmQueryEditorInput
implements IEditorInput {
    private QueryItemWrapper fQueryItemWrapper;
    private ITeamRepository fDefaultRepository;
    private AbstractWrapper fDefaultOwner;
    private IReadScope fDefaultReadScope;
    private IItemContainer parentFolder;
    private boolean addToRootFolder = false;
    private IAuditable folderOwner;
    private boolean fIsCreation;

    public ScmQueryEditorInput() {
        this.fIsCreation = true;
    }

    public ScmQueryEditorInput(QueryItemWrapper queryWrapper) {
        Assert.isLegal((queryWrapper != null ? 1 : 0) != 0);
        QueryItemWrapper newWrapper = QueryItemWrapper.newWrapper(queryWrapper.getRepository(), queryWrapper.getQueryItem());
        newWrapper.setAllowFolderActions(false);
        this.fQueryItemWrapper = newWrapper;
        this.fIsCreation = false;
    }

    public ITeamRepository getRepository() {
        return this.fQueryItemWrapper != null ? this.fQueryItemWrapper.getRepository() : this.fDefaultRepository;
    }

    public IQueryItem getQueryItem() {
        return this.fQueryItemWrapper != null ? this.fQueryItemWrapper.getQueryItem() : null;
    }

    public QueryItemWrapper getQueryItemWrapper() {
        return this.fQueryItemWrapper;
    }

    public ScmQueryEditorInput setQueryItemWrapper(QueryItemWrapper queryWrapper) {
        QueryItemWrapper newWrapper = QueryItemWrapper.newWrapper(queryWrapper.getRepository(), queryWrapper.getQueryItem());
        newWrapper.setAllowFolderActions(false);
        this.fQueryItemWrapper = newWrapper;
        return this;
    }

    public ScmQueryEditorInput setDefaultRepository(ITeamRepository repo) {
        this.fDefaultRepository = repo;
        return this;
    }

    public AbstractWrapper getOwner() {
        return this.fDefaultOwner;
    }

    public ScmQueryEditorInput setOwner(AbstractWrapper owner) {
        this.fDefaultOwner = owner;
        return this;
    }

    public IReadScope getReadScope() {
        return this.fDefaultReadScope;
    }

    public final ScmQueryEditorInput setReadScope(IReadScope readScope) {
        this.fDefaultReadScope = readScope;
        return this;
    }

    public IItemContainer getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(IItemContainer parentFolder) {
        this.parentFolder = parentFolder;
    }

    public boolean shouldAddToRootFolder() {
        return this.addToRootFolder;
    }

    public void setAddToRootFolder(boolean shouldAddToRootFolder) {
        this.addToRootFolder = shouldAddToRootFolder;
    }

    public IAuditable getFolderOwner() {
        return this.folderOwner;
    }

    public void setFolderOwner(IAuditable folderOwner) {
        this.folderOwner = folderOwner;
    }

    public boolean isCreation() {
        return this.fIsCreation;
    }

    public boolean exists() {
        return true;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fQueryItemWrapper == null ? 0 : this.fQueryItemWrapper.hashCode());
        result = 31 * result + (this.fIsCreation ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScmQueryEditorInput other = (ScmQueryEditorInput)obj;
        if (this.fIsCreation || other.fIsCreation) {
            return super.equals(obj);
        }
        return !(this.fQueryItemWrapper == null ? other.fQueryItemWrapper != null : !this.fQueryItemWrapper.equals((Object)other.fQueryItemWrapper));
    }
}

