/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.query;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.baselines.BaselineQueryEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.baselines.BaselineQueryEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.changesets.ChangeSetQueryEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.changesets.ChangeSetQueryEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.components.ComponentQueryEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.components.ComponentQueryEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.locks.LockQueryEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.locks.LockQueryEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.snapshots.SnapshotQueryEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.snapshots.SnapshotQueryEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.workspaces.WorkspaceQueryEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.workspaces.WorkspaceQueryEditorInput;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.domain.MyWorkspacesDomain;
import com.ibm.team.filesystem.ui.domain.StreamsDomain;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.queries.RepositoryNode;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.LockQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ProcessAreaWrapper;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceQueryWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.internal.utils.WorkbenchUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.ui.editor.TeamFormEditor;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.IJobRunnable;

public abstract class ScmQueryEditor
extends TeamFormEditor
implements ISaveablesSource {
    private PartSiteJobRunner fRunner;
    private ResourceManager fResourceManager;
    private TextActionHandler fTextActionHandler;
    private ScmQueryEditorHeader fHeader;
    private ISharedItemChangeListener fQueryItemDeletedListener;
    private IChangeListener fChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == ScmQueryWorkingCopy.PROP_DIRTY) {
                ScmQueryEditor.this.firePropertyChange(257);
            }
            ScmQueryEditor.this.removeSaveErrorIfValid();
            ScmQueryEditor.this.updateTitle();
        }
    };

    public static void openEditor(final IWorkbenchPage page, final QueryItemWrapper wrapper) {
        page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (wrapper instanceof BaselineQueryWrapper) {
                    BaselineQueryEditor.open(page, BaselineQueryEditorInput.newForEdit((BaselineQueryWrapper)wrapper));
                } else if (wrapper instanceof ChangeSetQueryWrapper) {
                    ChangeSetQueryEditor.open(page, ChangeSetQueryEditorInput.newForEdit((ChangeSetQueryWrapper)wrapper));
                } else if (wrapper instanceof ComponentQueryWrapper) {
                    ComponentQueryEditor.open(page, ComponentQueryEditorInput.newForEdit((ComponentQueryWrapper)wrapper));
                } else if (wrapper instanceof LockQueryWrapper) {
                    LockQueryEditor.open(page, LockQueryEditorInput.newForEdit((LockQueryWrapper)wrapper));
                } else if (wrapper instanceof SnapshotQueryWrapper) {
                    SnapshotQueryEditor.open(page, SnapshotQueryEditorInput.newForEdit((SnapshotQueryWrapper)wrapper));
                } else if (wrapper instanceof WorkspaceQueryWrapper) {
                    WorkspaceQueryEditor.open(page, WorkspaceQueryEditorInput.newForEdit((WorkspaceQueryWrapper)wrapper));
                } else {
                    throw new IllegalArgumentException("Unknown query type.");
                }
            }
        });
    }

    public static void openEditor(final IWorkbenchPage page, final ScmQueryEditorInput input) {
        page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (input instanceof BaselineQueryEditorInput) {
                    BaselineQueryEditor.open(page, (BaselineQueryEditorInput)input);
                } else if (input instanceof ChangeSetQueryEditorInput) {
                    ChangeSetQueryEditor.open(page, (ChangeSetQueryEditorInput)input);
                } else if (input instanceof ComponentQueryEditorInput) {
                    ComponentQueryEditor.open(page, (ComponentQueryEditorInput)input);
                } else if (input instanceof LockQueryEditorInput) {
                    LockQueryEditor.open(page, (LockQueryEditorInput)input);
                } else if (input instanceof SnapshotQueryEditorInput) {
                    SnapshotQueryEditor.open(page, (SnapshotQueryEditorInput)input);
                } else if (input instanceof WorkspaceQueryEditorInput) {
                    WorkspaceQueryEditor.open(page, (WorkspaceQueryEditorInput)input);
                } else {
                    throw new IllegalArgumentException("Unknown query type.");
                }
            }
        });
    }

    public static void openEditorForDuplication(final IWorkbenchPage page, final QueryItemWrapper queryItemWrapper, final Object parentNode, IOperationRunner runner) {
        runner.enqueue(Messages.ScmQueryEditorInput_DuplicateJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                ITeamRepository repo = queryItemWrapper.getRepository();
                IReadScope readScope = queryItemWrapper.getQueryItem().getReadScope();
                AbstractWrapper owner = null;
                try {
                    IAuditableHandle ownerHandle = queryItemWrapper.getQueryItem().getOwner();
                    if (ownerHandle instanceof IProcessAreaHandle) {
                        IProcessArea processArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)ownerHandle, 0, monitor);
                        owner = new ProcessAreaWrapper((IItem)processArea, repo);
                    } else if (ownerHandle instanceof IContributorHandle) {
                        IContributor user = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)ownerHandle, 0, monitor);
                        owner = new ContributorWrapper(repo, user);
                    }
                }
                catch (TeamRepositoryException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                }
                ScmQueryEditorInput input = ScmQueryEditor.getEditorInput(queryItemWrapper);
                if (queryItemWrapper instanceof BaselineQueryWrapper) {
                    input = BaselineQueryEditorInput.newBaselineQuery();
                } else if (queryItemWrapper instanceof ChangeSetQueryWrapper) {
                    input = ChangeSetQueryEditorInput.newChangeSetQuery();
                } else if (queryItemWrapper instanceof ComponentQueryWrapper) {
                    input = ComponentQueryEditorInput.newComponentQuery();
                } else if (queryItemWrapper instanceof LockQueryWrapper) {
                    input = LockQueryEditorInput.newLockQuery();
                } else if (queryItemWrapper instanceof SnapshotQueryWrapper) {
                    input = SnapshotQueryEditorInput.newSnapshotQuery();
                } else if (queryItemWrapper instanceof WorkspaceQueryWrapper) {
                    input = WorkspaceQueryEditorInput.newWorkspaceQuery();
                } else {
                    throw new IllegalArgumentException("Unknown query type.");
                }
                input.setOwner(owner);
                input.setReadScope(readScope);
                input.setQueryItemWrapper(queryItemWrapper);
                if (parentNode instanceof RepositoryNode) {
                    input.setAddToRootFolder(true);
                    input.setFolderOwner((IAuditable)repo.loggedInContributor());
                } else if (parentNode instanceof DomainSubtreeRoot) {
                    DomainSubtreeRoot rootNode = (DomainSubtreeRoot)parentNode;
                    if (rootNode.getDomain() instanceof MyWorkspacesDomain) {
                        input.setAddToRootFolder(true);
                        input.setFolderOwner((IAuditable)repo.loggedInContributor());
                    } else if (rootNode.getDomain() instanceof StreamsDomain) {
                        input.setAddToRootFolder(true);
                        if (rootNode.getCategoryElement() instanceof IProjectArea) {
                            IProjectArea projectArea = (IProjectArea)rootNode.getCategoryElement();
                            input.setFolderOwner((IAuditable)projectArea);
                        }
                    }
                } else if (parentNode instanceof FolderNode) {
                    FolderNode folderNode = (FolderNode)parentNode;
                    input.setParentFolder(folderNode.getItem());
                }
                ScmQueryEditor.openEditor(page, input);
            }
        });
    }

    public static ScmQueryEditorInput getEditorInput(QueryItemWrapper wrapper) {
        ScmQueryEditorInput input = null;
        if (wrapper instanceof BaselineQueryWrapper) {
            return BaselineQueryEditorInput.newForEdit((BaselineQueryWrapper)wrapper);
        }
        if (wrapper instanceof ChangeSetQueryWrapper) {
            return ChangeSetQueryEditorInput.newForEdit((ChangeSetQueryWrapper)wrapper);
        }
        if (wrapper instanceof ComponentQueryWrapper) {
            return ComponentQueryEditorInput.newForEdit((ComponentQueryWrapper)wrapper);
        }
        if (wrapper instanceof LockQueryWrapper) {
            return LockQueryEditorInput.newForEdit((LockQueryWrapper)wrapper);
        }
        if (wrapper instanceof SnapshotQueryWrapper) {
            return SnapshotQueryEditorInput.newForEdit((SnapshotQueryWrapper)wrapper);
        }
        if (wrapper instanceof WorkspaceQueryWrapper) {
            return WorkspaceQueryEditorInput.newForEdit((WorkspaceQueryWrapper)wrapper);
        }
        return input;
    }

    public abstract String getQueryType();

    public abstract ScmQueryWorkingCopy getWorkingCopy();

    public abstract ImageDescriptor getQueryEditorImage();

    public abstract void createWorkingCopy();

    protected FormToolkit createToolkit(Display display) {
        return new FileSystemEditorToolkit(UiPlugin.getDefault().getSharedFormColors(display));
    }

    protected void createPages() {
        super.createPages();
        this.fTextActionHandler = new TextActionHandler(this.getEditorSite().getActionBars());
        this.fHeader.addTextControls(this.fTextActionHandler);
    }

    protected Composite createPageContainer(final Composite parent) {
        final Display display = parent.getDisplay();
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fRunner = new PartSiteJobRunner(this.getSite(), false){

            protected boolean reportProblem(final String opName, Operation op, final IStatus reason) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!parent.isDisposed()) {
                            String message;
                            IStatus adjustedReason = reason;
                            if (reason.getException() instanceof ItemNotFoundException) {
                                message = NLS.bind((String)Messages.ScmQueryEditor_QUERY_DELETED_MSG, (Object)ScmQueryEditor.this.getQueryType(), (Object)ScmQueryEditor.this.getWorkingCopy().getQueryName());
                                adjustedReason = StatusUtil.newStatus((Object)this, (String)message, (Throwable)new CoreException(StatusUtil.newStatus((Object)this, (String)message, (Throwable)reason.getException())));
                            }
                            if (reason.getException() instanceof LicenseNotGrantedException) {
                                message = NLS.bind((String)Messages.ScmQueryEditor_NO_LICENSE_FOR_EDIT_MSG, (Object)ScmQueryEditor.this.getQueryType(), (Object)ScmQueryEditor.this.getWorkingCopy().getQueryName());
                                adjustedReason = StatusUtil.newStatus((Object)this, (String)message, (Throwable)new CoreException(StatusUtil.newStatus((Object)this, (String)message, (Throwable)reason.getException())));
                            }
                            ErrorDialog.openError((Shell)ScmQueryEditor.this.getSite().getShell(), (String)NLS.bind((String)Messages.ScmQueryEditor_ERROR_RUNNING_JOB_MSG, (Object)opName), null, (IStatus)adjustedReason);
                        }
                    }
                });
                return false;
            }
        };
        this.createWorkingCopy();
        this.getWorkingCopy().addListener(this.fChangeListener);
        this.registerQueryItemDeletedListener(this.getWorkingCopy().getQueryItemWrapper());
        this.updateTitle();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        return super.createPageContainer(parent);
    }

    public abstract String getHelpContextId();

    private void updateTitle() {
        String name = "";
        if (this.getWorkingCopy() != null) {
            name = this.getWorkingCopy().getMode().isCreation() ? this.getWorkingCopy().getNewQueryName() : this.getWorkingCopy().getQueryName();
        }
        this.setPartName(name);
        this.setTitleImage(this.getResourceManager().createImageWithDefault(this.getQueryEditorImage()));
    }

    public boolean isDirty() {
        return this.getWorkingCopy() != null && this.getWorkingCopy().isDirty() || super.isDirty();
    }

    protected void registerQueryItemDeletedListener(QueryItemWrapper wrapper) {
        if (wrapper == null || this.fQueryItemDeletedListener != null) {
            return;
        }
        ITeamRepository repo = wrapper.getRepository();
        IQueryItem query = wrapper.getQueryItem();
        ScmQueryEditor editor = this;
        this.fQueryItemDeletedListener = new ISharedItemChangeListener((IEditorPart)editor){
            private final /* synthetic */ IEditorPart val$editor;
            {
                this.val$editor = iEditorPart;
            }

            public void itemsChanged(List events) {
                for (Object changeEvent : events) {
                    ISharedItemChangeEvent event;
                    if (!(changeEvent instanceof ISharedItemChangeEvent) || (event = (ISharedItemChangeEvent)changeEvent).getAfterState() != null || ScmQueryEditor.this.getSite().getWorkbenchWindow().getActivePage() == null) continue;
                    ScmQueryEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ScmQueryEditor.this.getSite().getWorkbenchWindow().getActivePage().closeEditor(val$editor, false);
                        }
                    });
                }
            }
        };
        repo.itemManager().addItemChangeListener((IItem)query, this.fQueryItemDeletedListener);
    }

    public PartSiteJobRunner getRunner() {
        return this.fRunner;
    }

    public ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    public ScmQueryEditorHeader getHeader() {
        return this.fHeader;
    }

    protected void setHeader(ScmQueryEditorHeader header) {
        this.fHeader = header;
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public void removeSaveErrorIfValid() {
        IStatus status;
        ScmQueryWorkingCopy workingCopy = this.getWorkingCopy();
        ScmQueryEditorHeader header = this.getHeader();
        if (workingCopy != null && header != null && !workingCopy.isShowingSavePermissionError() && (status = ((ScmItemWorkingCopy)workingCopy).validateForSave()) != null && status.isOK()) {
            header.setSaveError(null);
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void commit(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    public void dispose() {
        ScmQueryWorkingCopy workingCopy = this.getWorkingCopy();
        if (workingCopy != null) {
            QueryItemWrapper wrapper = workingCopy.getQueryItemWrapper();
            if (this.fQueryItemDeletedListener != null && wrapper != null) {
                wrapper.getRepository().itemManager().removeItemChangeListener((IItem)wrapper.getQueryItem(), this.fQueryItemDeletedListener);
                this.fQueryItemDeletedListener = null;
            }
            workingCopy.removeListener(this.fChangeListener);
        }
        this.fChangeListener = null;
        this.fRunner.dispose();
        this.fRunner = null;
        this.setHeader(null);
        super.dispose();
    }

    public boolean isDisposed() {
        return this.getWorkingCopy() == null;
    }

    protected abstract class ScmQuerySaveable
    extends Saveable {
        private final ScmQueryWorkingCopy fSaveableWorkingCopy;

        protected ScmQuerySaveable(ScmQueryWorkingCopy workingCopy) {
            Assert.isNotNull((Object)((Object)workingCopy));
            this.fSaveableWorkingCopy = workingCopy;
        }

        public ScmQueryWorkingCopy getSaveableWorkingCopy() {
            return this.fSaveableWorkingCopy;
        }

        public String getName() {
            String name = null;
            ScmQueryWorkingCopy wc = this.getSaveableWorkingCopy();
            name = wc.getMode().isCreation() ? wc.getNewQueryName() : wc.getQueryName();
            if (name == null) {
                name = "";
            }
            return name;
        }

        public String getToolTipText() {
            String toolTip = null;
            ScmQueryWorkingCopy wc = this.getSaveableWorkingCopy();
            toolTip = wc.getMode().isCreation() ? wc.getNewQueryName() : wc.getToolTipText();
            if (toolTip == null) {
                toolTip = "";
            }
            return toolTip;
        }

        public ImageDescriptor getImageDescriptor() {
            return ScmQueryEditor.this.getQueryEditorImage();
        }

        public boolean isDirty() {
            return this.getSaveableWorkingCopy().isDirty();
        }

        public void doSave(IProgressMonitor monitor) throws CoreException {
            throw new UnsupportedOperationException();
        }

        public IJobRunnable doSave(IProgressMonitor monitor, IShellProvider shellProvider) throws CoreException {
            ScmQueryEditor.this.commit(monitor);
            IStatus status = this.getSaveableWorkingCopy().validateForSave();
            if (!status.isOK()) {
                ScmQueryEditor.this.getHeader().setSaveError(NLS.bind((String)Messages.ScmQueryEditor_SAVE_ERROR_MSG, (Object)status.getMessage()));
                monitor.setCanceled(true);
                return null;
            }
            ScmQueryEditor.this.getHeader().setSaveError(null);
            final Display display = shellProvider.getShell().getDisplay();
            final String queryName = this.getSaveableWorkingCopy().getQueryName();
            return new IJobRunnable(){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        if (Display.getCurrent() == null) {
                            ScmQuerySaveable.this.getSaveableWorkingCopy().save(monitor);
                        } else {
                            ScmQuerySaveable.this.getSaveableWorkingCopy().saveStarting();
                            WorkbenchUtil.runBackgroundSave((IProgressMonitor)monitor, (Operation)new Operation(){

                                public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                                    try {
                                        ScmQuerySaveable.this.getSaveableWorkingCopy().save(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                                    }
                                }
                            }, (String)NLS.bind((String)Messages.ScmQueryEditor_SAVING_QUERY_MSG, (Object)ScmQueryEditor.this.getQueryType(), (Object)queryName));
                            ScmQuerySaveable.this.getSaveableWorkingCopy().saveDone();
                        }
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ScmQueryEditor.this.isDisposed()) {
                                    return;
                                }
                                ScmQuerySaveable.this.getSaveableWorkingCopy().saveSucceeded();
                                ScmQueryEditor.this.setInput(ScmQueryEditor.getEditorInput(ScmQuerySaveable.this.getSaveableWorkingCopy().getQueryItemWrapper()));
                            }
                        });
                        ScmQueryEditor.this.registerQueryItemDeletedListener(ScmQuerySaveable.this.getSaveableWorkingCopy().getQueryItemWrapper());
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        final Throwable rootException = e.getStatus().getException();
                        if (rootException instanceof TeamOperationCanceledException) {
                            return Status.OK_STATUS;
                        }
                        if (rootException instanceof PermissionDeniedException) {
                            boolean showSaveError = true;
                            Object data = ((PermissionDeniedException)rootException).getData();
                            if (data != null && data.equals("com.ibm.team.internal.filesystem.ui.operations.permission.denied") && ScmQueryEditor.this.getWorkingCopy().getQueryItemWrapper() != null) {
                                showSaveError = false;
                                ScmQueryEditor.this.getWorkingCopy().saveSucceeded();
                            }
                            if (showSaveError) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!ScmQueryEditor.this.isDisposed()) {
                                            ScmQueryEditor.this.fHeader.setSaveError(NLS.bind((String)Messages.TeamPlacePart2_ErrorDuringSave, (Object)rootException.getMessage()));
                                            ScmQueryEditor.this.getWorkingCopy().setShowingSavePermissionError(true);
                                        }
                                    }
                                });
                            }
                            return Status.OK_STATUS;
                        }
                        if (rootException instanceof ItemNotFoundException) {
                            String message = NLS.bind((String)Messages.ScmQueryEditor_QUERY_DELETED_MSG, (Object)ScmQueryEditor.this.getQueryType(), (Object)queryName);
                            return StatusUtil.newStatus((Object)this, (String)message, (Throwable)new CoreException(StatusUtil.newStatus((Object)this, (String)message, (Throwable)rootException)));
                        }
                        return e.getStatus();
                    }
                    catch (OperationCanceledException e) {
                        return Status.CANCEL_STATUS;
                    }
                }
            };
        }

        public void disableUI(IWorkbenchPart[] parts, boolean closing) {
            this.getSaveableWorkingCopy().saveStarting();
            super.disableUI(parts, closing);
        }

        public void enableUI(IWorkbenchPart[] parts) {
            this.getSaveableWorkingCopy().saveDone();
            super.enableUI(parts);
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }
}

