/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.query;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorPage;
import com.ibm.team.filesystem.ide.ui.internal.editors.query.ScmQueryWorkingCopy;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.OwnerPicker;
import com.ibm.team.internal.filesystem.ui.picker.VisibilityPicker;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.scm.client.IReadScopeDescriber;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.internal.dto.ProcessAreaScope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ScmQueryDetailsPage
extends ScmItemEditorPage {
    public static final int QUERY_DESCRIPTION_LIMIT = 32768;
    private ScmQueryWorkingCopy fWorkingCopy;
    private OwnerControl fOwnerControl;
    private Button fBrowseOwnerButton;
    private Label fVisibilityControl;
    private Button fChangeVisibilityButton;
    private Text fDescriptionText;
    private static final int DESCRIPTION_HEIGHT = 10;
    private IChangeListener fChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            ScmQueryDetailsPage.this.updateEnablement();
            if (property == ScmQueryWorkingCopy.PROPERTY.QUERY_OWNER) {
                ScmQueryDetailsPage.this.updateOwner();
            } else if (property == ScmQueryWorkingCopy.PROPERTY.QUERY_VISIBILITY) {
                ScmQueryDetailsPage.this.updateVisibility();
            } else if (property == ScmQueryWorkingCopy.PROPERTY.QUERY_DESCRIPTION) {
                ScmQueryDetailsPage.this.updateDescription();
            } else if (property == ScmQueryWorkingCopy.PROPERTY.QUERY_SEARCH_CRITERIA) {
                ITeamRepository oldRepo;
                ITeamRepository newRepo;
                IAuditable currentOwner = ScmQueryDetailsPage.this.fWorkingCopy.getQueryOwner();
                AbstractSearchInput searchCriteria = ScmQueryDetailsPage.this.fWorkingCopy.getQuerySearchCriteria();
                if (currentOwner != null && searchCriteria != null && (newRepo = searchCriteria.getRepository()) != null && currentOwner.getOrigin() != null && currentOwner.getOrigin() instanceof ITeamRepository && !(oldRepo = (ITeamRepository)currentOwner.getOrigin()).equals(newRepo)) {
                    ScmQueryDetailsPage.this.fWorkingCopy.setQueryOwner(null);
                    ScmQueryDetailsPage.this.fWorkingCopy.setOriginalQueryOwner(null);
                    ScmQueryDetailsPage.this.fWorkingCopy.setParentOwner(null);
                    ScmQueryDetailsPage.this.fWorkingCopy.setOriginalQueryParentOwner(null);
                    ScmQueryDetailsPage.this.fWorkingCopy.setQueryReadScope(null);
                    ScmQueryDetailsPage.this.fWorkingCopy.setOriginalQueryReadScope(null);
                    ScmQueryDetailsPage.this.updateOwner();
                    ScmQueryDetailsPage.this.updateVisibility();
                }
            }
        }
    };

    public ScmQueryDetailsPage(FormEditor editor, String pageID, ScmQueryWorkingCopy workingCopy, IOperationRunner runner) {
        super(editor, pageID, Messages.ScmQueryDetailsPage_PAGE_NAME, runner);
        this.fWorkingCopy = workingCopy;
        this.fWorkingCopy.addListener(this.fChangeListener);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(body);
        Section detailsSection = this.createDetailsSection(body);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)detailsSection);
        this.updateEnablement();
    }

    private Section createDetailsSection(Composite parent) {
        FileSystemEditorToolkit toolkit = (FileSystemEditorToolkit)this.getManagedForm().getToolkit();
        Section detailsSection = this.createSection(toolkit, parent, 384, Messages.ScmQueryDetailsPage_DETAILS_SECTION_TITLE);
        detailsSection.setDescription(Messages.ScmQueryDetailsPage_DETAILS_SECTION_DESCRIPTION);
        Composite detailsComposite = toolkit.createComposite((Composite)detailsSection);
        detailsSection.setClient((Control)detailsComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(LayoutConstants.getSpacing()).extendedMargins(0, 0, 10, 0).applyTo(detailsComposite);
        toolkit.createLabel(detailsComposite, Messages.ScmQueryDetailsPage_OWNED_BY_LABEL);
        this.fOwnerControl = new OwnerControl(toolkit, detailsComposite, "owner");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fOwnerControl);
        this.fBrowseOwnerButton = this.createPushButton(detailsComposite, Messages.ScmQueryDetailsPage_BROWSE_OWNER_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScmQueryDetailsPage.this.doBrowseOwner();
            }
        });
        toolkit.createLabel(detailsComposite, Messages.ScmQueryDetailsPage_VISIBILITY_LABEL);
        this.fVisibilityControl = toolkit.createLabel(detailsComposite, "");
        GridDataFactory.swtDefaults().hint(350, -1).applyTo((Control)this.fVisibilityControl);
        this.fChangeVisibilityButton = this.createPushButton(detailsComposite, Messages.ScmQueryDetailsPage_CHANGE_VISIBILITY_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScmQueryDetailsPage.this.doChangeVisibility();
            }
        });
        Label textLabel = toolkit.createLabel(detailsComposite, Messages.ScmQueryDetailsPage_DESCRIPTION_LABEL);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)textLabel);
        this.fDescriptionText = toolkit.createText(detailsComposite, "", 2626);
        this.fDescriptionText.setTextLimit(32768);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScmQueryDetailsPage.this.fWorkingCopy.setQueryDescription(ScmQueryDetailsPage.this.fDescriptionText.getText());
            }
        });
        int h = this.calcTextHeight(this.fDescriptionText, 10);
        GridDataFactory.fillDefaults().grab(true, true).hint(1, h).span(2, 1).applyTo((Control)this.fDescriptionText);
        this.updateOwner();
        this.updateVisibility();
        this.updateDescription();
        return detailsSection;
    }

    private ITeamRepository getRepository() {
        ITeamRepository repo = null;
        QueryItemWrapper wrapper = this.fWorkingCopy.getQueryItemWrapper();
        if (!this.fWorkingCopy.isCreation() && wrapper != null) {
            repo = wrapper.getRepository();
        } else {
            ITeamRepository[] repos;
            block7: {
                try {
                    AbstractSearchInput searchCriteria = this.fWorkingCopy.getQuerySearchCriteria();
                    repo = searchCriteria != null ? searchCriteria.getRepository() : this.fWorkingCopy.getOriginalRepository();
                    if (repo != null) break block7;
                    ITeamRepository[] repos2 = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
                    int i = 0;
                    while (i < repos2.length) {
                        ITeamRepository teamRepository = repos2[i];
                        if (teamRepository.loggedIn()) {
                            repo = teamRepository;
                            break;
                        }
                        ++i;
                    }
                }
                catch (IllegalArgumentException e) {
                    repo = null;
                }
            }
            if (repo == null && (repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories()).length > 0) {
                repo = repos[0];
            }
        }
        return repo;
    }

    private void doBrowseOwner() {
        Display display = Display.getCurrent();
        final ITeamRepository repo = this.getRepository();
        OwnerPicker ownerPicker = new OwnerPicker(this.getSite().getShell(), repo, Messages.ScmQueryDetailsPage_OWNER_PICKER_DESCRIPTION);
        if (ownerPicker.open() == 0) {
            IAuditable owner = ownerPicker.getOwner();
            IReadScope readScope = ownerPicker.getReadScope();
            if (owner != null) {
                this.getOperationRunner().enqueue(Messages.ScmQueryDetailsPage_CHANGE_OWNER_JOB_NAME, (Operation)new RepositoryOperation((IAuditableHandle)owner, display, readScope){
                    private final /* synthetic */ IAuditableHandle val$owner;
                    private final /* synthetic */ Display val$display;
                    private final /* synthetic */ IReadScope val$readScope;
                    {
                        this.val$owner = iAuditableHandle;
                        this.val$display = display;
                        this.val$readScope = iReadScope;
                    }

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        final IAuditable ownerItem = (IAuditable)repo.itemManager().fetchCompleteItem((IItemHandle)this.val$owner, 0, monitor);
                        if (ownerItem != null) {
                            SWTUtil.greedyExec((Display)this.val$display, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ScmQueryDetailsPage.this.doSetOwner(ownerItem);
                                    if (val$readScope != null) {
                                        ProcessAreaScope processAreaScope;
                                        if (val$owner instanceof ITeamArea && val$readScope instanceof ProcessAreaScope) {
                                            processAreaScope = (ProcessAreaScope)val$readScope;
                                            processAreaScope.setProcessArea(null);
                                        }
                                        if (val$owner instanceof IProjectArea && val$readScope instanceof ProcessAreaScope) {
                                            processAreaScope = (ProcessAreaScope)val$readScope;
                                            processAreaScope.setProcessArea(val$owner);
                                        }
                                        ScmQueryDetailsPage.this.fWorkingCopy.setQueryReadScope(val$readScope);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    private void doSetOwner(IAuditable owner) {
        this.fWorkingCopy.setQueryOwner(owner);
        if (owner != null && owner instanceof ITeamArea) {
            this.doSetParentOwner((ITeamArea)owner);
        }
    }

    private void doSetParentOwner(final ITeamArea owner) {
        if (owner != null) {
            final Display d = Display.getCurrent();
            this.getOperationRunner().enqueue(Messages.ScmQueryDetailsPage_FETCH_PROJECT_AREA_JOB_NAME, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    ITeamRepository repo = ScmQueryDetailsPage.this.getRepository();
                    IProjectAreaHandle projectArea = owner.getProjectArea();
                    final IAuditable fetchedProjectArea = (IAuditable)repo.itemManager().fetchCompleteItem((IItemHandle)projectArea, 0, monitor);
                    SWTUtil.greedyExec((Display)d, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ScmQueryDetailsPage.this.fWorkingCopy.setParentOwner(fetchedProjectArea);
                        }
                    });
                }
            });
        }
    }

    private void updateOwner() {
        if (this.fOwnerControl != null && !this.fOwnerControl.isDisposed()) {
            IAuditable owner = this.fWorkingCopy.getQueryOwner();
            this.fOwnerControl.setOwner(owner);
            if (owner instanceof ITeamArea) {
                this.doSetParentOwner((ITeamArea)owner);
            }
        }
    }

    private void doChangeVisibility() {
        IAuditable owner = this.fWorkingCopy.getQueryOwner();
        IProjectArea projectArea = null;
        ITeamArea teamArea = null;
        if (owner instanceof IProjectArea) {
            projectArea = (IProjectArea)owner;
        } else if (owner instanceof ITeamArea) {
            teamArea = (ITeamArea)owner;
            projectArea = (IProjectArea)this.fWorkingCopy.getQueryParentOwner();
        }
        VisibilityPicker picker = new VisibilityPicker((IShellProvider)this.getSite(), this.getRepository(), this.fWorkingCopy.getQueryReadScope(), VisibilityPicker.PickerMode.QUERY, Messages.ScmQueryDetailsPage_0);
        picker.setOwner(owner);
        picker.setProcessAreas(projectArea, teamArea);
        if (picker.open() == 0) {
            this.fWorkingCopy.setQueryReadScope(picker.getReadScope());
        }
    }

    private void updateVisibility() {
        if (this.fVisibilityControl != null && !this.fVisibilityControl.isDisposed()) {
            IReadScope readScope = this.fWorkingCopy.getQueryReadScope();
            if (readScope != null) {
                String text = IReadScopeDescriber.FACTORY.shortDescription(readScope);
                IAuditableHandle scope = null;
                if (readScope instanceof IContributorDeferringScope) {
                    scope = ((IContributorDeferringScope)readScope).getScope();
                } else if (readScope instanceof ITeamAreaPrivateScope) {
                    scope = ((ITeamAreaPrivateScope)readScope).getTeamArea();
                } else if (readScope instanceof IProcessAreaScope) {
                    scope = ((IProcessAreaScope)readScope).getProcessArea();
                }
                if (scope != null && scope instanceof IProcessArea) {
                    text = String.valueOf(text) + " (" + ((IProcessArea)scope).getName() + ")";
                }
                this.fVisibilityControl.setText(text);
            } else {
                this.fVisibilityControl.setText(Messages.ScmQueryDetailsPage_NO_VISIBILITY_LABEL);
            }
        }
    }

    private void updateDescription() {
        String description = this.fWorkingCopy.getQueryDescription();
        if (description != null && this.fDescriptionText != null && !this.fDescriptionText.isDisposed() && !description.equals(this.fDescriptionText.getText())) {
            this.fDescriptionText.setText(description);
        }
    }

    public void setFocus() {
        if (this.getLastActivePart() != null) {
            this.getLastActivePart().setFocus();
        } else if (this.fBrowseOwnerButton != null) {
            this.fBrowseOwnerButton.setFocus();
        }
    }

    private void updateEnablement() {
        OwnerControl first = this.fOwnerControl;
        if (first != null && first.isDisposed()) {
            return;
        }
        boolean isBusy = this.fWorkingCopy.isBusy();
        if (this.fOwnerControl != null) {
            this.fOwnerControl.setEnabled(!isBusy);
        }
        if (this.fBrowseOwnerButton != null) {
            this.fBrowseOwnerButton.setEnabled(!isBusy);
        }
        if (this.fChangeVisibilityButton != null) {
            this.fChangeVisibilityButton.setEnabled(!isBusy);
        }
        if (this.fDescriptionText != null) {
            this.fDescriptionText.setEnabled(!isBusy);
        }
    }

    @Override
    public void dispose() {
        this.fWorkingCopy.removeListener(this.fChangeListener);
        this.fWorkingCopy = null;
        this.fChangeListener = null;
        this.fOwnerControl = null;
        this.initialize(null);
        super.dispose();
    }

    private class OwnerControl
    extends Composite {
        private Label fMissingLabel;
        private StandardControlLabelProvider fLabelProvider;

        public OwnerControl(FileSystemEditorToolkit toolkit, Composite parent, String id) {
            super(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo((Composite)this);
            this.fMissingLabel = new Label((Composite)this, 0);
            this.fMissingLabel.setText(Messages.ScmQueryDetailsPage_OWNER_MISSING_LABEL);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.fMissingLabel);
            this.fLabelProvider = toolkit.createDecoratedImageHyperlink(this, ScmQueryDetailsPage.this.getSite(), String.valueOf(ScmQueryDetailsPage.this.getSite().getId()) + "." + id);
            GridDataFactory.fillDefaults().minSize(100, 0).align(4, 0x1000000).grab(true, true).applyTo(this.fLabelProvider.getControl());
        }

        public void setOwner(IAuditable owner) {
            this.fLabelProvider.setTextAware(true);
            this.fLabelProvider.setElement((Object)owner);
            Control labelControl = this.fLabelProvider.getControl();
            if (labelControl instanceof ImageHyperlink) {
                final String ownerText = ((ImageHyperlink)labelControl).getText();
                this.fLabelProvider.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                    public void getName(AccessibleEvent e) {
                        e.result = NLS.bind((String)Messages.ScmQueryDetailsPage_OWNED_BY_ACCESSIBILITY_LABEL, (Object)ownerText);
                    }
                });
            }
            if (owner instanceof ITeamArea) {
                this.fLabelProvider.setTextAware(false);
            }
            boolean hasOwner = owner != null;
            Label c1 = this.fMissingLabel;
            Control c2 = this.fLabelProvider.getControl();
            c1.setVisible(!hasOwner);
            c2.setVisible(hasOwner);
            ((GridData)c1.getLayoutData()).exclude = hasOwner;
            ((GridData)c2.getLayoutData()).exclude = !hasOwner;
            this.layout();
        }

        public void setEnabled(boolean enabled) {
            if (enabled != this.fLabelProvider.getControl().getEnabled()) {
                this.fLabelProvider.getControl().setEnabled(enabled);
            }
        }
    }
}

