/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.component;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.ui.operations.EditComponentOperation;
import com.ibm.team.filesystem.ui.operations.NewComponentOperation;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.ProcessAreaWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ComponentWorkingCopy
extends ScmItemWorkingCopy {
    private MODE fMode;
    private ComponentWrapper fOriginalComponentWrapper;
    private ComponentWrapper fComponentWrapper;
    private String fOriginalComponentName = "";
    private String fComponentName;
    private IAuditable fOriginalComponentOwner;
    private IAuditable fComponentOwner;
    private boolean isOwnerInaccessible = false;
    private IReadScope fOriginalComponentReadScope;
    private IReadScope fComponentReadScope;
    private IAuditable fOriginalParentOwner;
    private IAuditable fParentOwner;
    private ISharedItemChangeListener fSharedItemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            ComponentWrapper componentWrapper = ComponentWorkingCopy.this.getComponentWrapper();
            if (componentWrapper != null) {
                boolean synchronizeToRepository = false;
                for (Object event : events) {
                    if (!(event instanceof ISharedItemChangeEvent)) continue;
                    ISharedItemChangeEvent changeEvent = (ISharedItemChangeEvent)event;
                    if (!componentWrapper.getComponent().sameItemId((IItemHandle)changeEvent.getSharedItem())) continue;
                    synchronizeToRepository = true;
                    break;
                }
                if (synchronizeToRepository) {
                    ComponentWorkingCopy.this.synchronizeToRepository();
                }
            }
        }
    };
    private IListener fOwnerVizListener = new IListener(){

        public void handleEvents(List events) {
            ComponentWrapper wrapper = ComponentWorkingCopy.this.getComponentWrapper();
            if (wrapper != null) {
                IComponent currentComponent = wrapper.getComponent();
                boolean needsUpdate = false;
                for (Object obj : events) {
                    IComponentHandle component;
                    PropertyChangeEvent event;
                    if (needsUpdate || !(obj instanceof PropertyChangeEvent) || !((event = (PropertyChangeEvent)obj).getObject() instanceof IComponentHandle) || !(component = (IComponentHandle)event.getObject()).sameItemId((IItemHandle)currentComponent) || !event.getProperty().equals("component_owner") && !event.getProperty().equals("component_visibility")) continue;
                    needsUpdate = true;
                    break;
                }
                if (needsUpdate) {
                    ComponentWorkingCopy.this.synchronizeToRepository();
                }
            }
        }
    };

    public ComponentWorkingCopy(Object input, IOperationRunner runner, Shell shell) {
        super(Messages.ComponentWorkingCopy_ComponentWorkingCopyName, runner, shell);
        this.init(input);
    }

    private void init(Object editorInput) {
        if (editorInput instanceof ComponentEditorInput) {
            ComponentEditorInput input = (ComponentEditorInput)editorInput;
            if (input.isCreation()) {
                AbstractWrapper owner;
                this.setMode(MODE.NEW_COMPONENT);
                IReadScope readScope = null;
                if (input.getComponentWrapper() != null) {
                    this.setOriginalComponentWrapper(input.getComponentWrapper());
                }
                if ((owner = input.getOwner()) instanceof ProcessAreaWrapper) {
                    ProcessAreaWrapper tw = (ProcessAreaWrapper)input.getOwner();
                    this.setComponentOwner((IAuditable)tw.getItem());
                    readScope = IReadScope.FACTORY.createProcessAreaScope();
                }
                if (owner instanceof ContributorWrapper) {
                    ContributorWrapper cw = (ContributorWrapper)owner;
                    this.setComponentOwner((IAuditable)cw.getContributor());
                    readScope = IReadScope.FACTORY.createPublicScope();
                }
                if (input.getReadScope() != null) {
                    readScope = input.getReadScope();
                }
                this.setComponentReadScope(readScope);
                this.initForCreation();
            } else {
                this.setMode(MODE.EDIT_COMPONENT);
                ComponentWrapper component = input.getComponentWrapper();
                this.setComponentWrapper(component);
                this.setOriginalComponentName(component.getComponent().getName());
                this.initForEdit();
                this.setDirty(false);
            }
        } else {
            throw new IllegalArgumentException(Messages.ComponentWorkingCopy_WrongInput);
        }
        this.setValid(this.checkValid());
    }

    private void initForCreation() {
        if (this.getOriginalComponentWrapper() != null) {
            this.initializeFromOriginal(this.getOriginalComponentWrapper(), false);
            this.stateChanged();
        }
    }

    private void initializeFromOriginal(ComponentWrapper originalComponent, boolean notifyStateChanged) {
    }

    private void initForEdit() {
        final ComponentWrapper componentWrapper = this.getComponentWrapper();
        if (componentWrapper == null) {
            return;
        }
        ScmItemWorkingCopy.UIOperation<ComponentData> op = new ScmItemWorkingCopy.UIOperation<ComponentData>((ScmItemWorkingCopy)this){

            @Override
            protected ComponentData runInBackground(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                try {
                    ComponentData result = ComponentWorkingCopy.loadFromRepository(componentWrapper, true, reporter);
                    ITeamRepository repoToListenTo = componentWrapper.getRepository();
                    repoToListenTo.itemManager().addItemChangeListener((IItem)componentWrapper.getComponent(), ComponentWorkingCopy.this.fSharedItemChangeListener);
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repoToListenTo);
                    wm.addGenericListener((Object)"component_owner", ComponentWorkingCopy.this.fOwnerVizListener);
                    wm.addGenericListener((Object)"component_visibility", ComponentWorkingCopy.this.fOwnerVizListener);
                    return result;
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(ComponentData componentData) {
                if (componentData != null) {
                    ComponentWorkingCopy.this.setOriginalComponentName(componentData.getName());
                    ComponentWorkingCopy.this.setOriginalComponentOwner(componentData.getOwner());
                    ComponentWorkingCopy.this.setOwnerInaccessible(componentData.isOwnerInaccessible());
                    ComponentWorkingCopy.this.setOriginalParentOwner(componentData.getParentOwner());
                    ComponentWorkingCopy.this.setOriginalComponentReadScope(componentData.getReadScope());
                }
                ComponentWorkingCopy.this.setDirty(false);
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.ComponentWorkingCopy_LoadingData, (Object)componentWrapper.getComponent().getName()));
    }

    private void synchronizeToRepository() {
        final ComponentWrapper componentWrapper = this.getComponentWrapper();
        if (componentWrapper == null) {
            return;
        }
        ScmItemWorkingCopy.UIOperation<ComponentData> op = new ScmItemWorkingCopy.UIOperation<ComponentData>((ScmItemWorkingCopy)this){

            @Override
            protected ComponentData runInBackground(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                try {
                    return ComponentWorkingCopy.loadFromRepository(componentWrapper, false, reporter);
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(ComponentData componentData) {
                if (componentData != null) {
                    ComponentWorkingCopy.this.setOriginalComponentName(componentData.getName());
                    ComponentWorkingCopy.this.setOriginalComponentOwner(componentData.getOwner());
                    ComponentWorkingCopy.this.setOwnerInaccessible(componentData.isOwnerInaccessible());
                    ComponentWorkingCopy.this.setOriginalParentOwner(componentData.getParentOwner());
                    ComponentWorkingCopy.this.setOriginalComponentReadScope(componentData.getReadScope());
                }
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.ComponentWorkingCopy_UpdatingData, (Object)componentWrapper.getComponent().getName()));
    }

    private static ComponentData loadFromRepository(ComponentWrapper componentWrapper, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int refreshFlag = refresh ? 1 : 0;
        ITeamRepository repo = componentWrapper.getRepository();
        IComponent component = componentWrapper.getComponent();
        ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
        componentHandles.add((IComponentHandle)component.getItemHandle());
        if (!repo.loggedIn()) {
            repo.login((IProgressMonitor)progress.newChild(15));
        }
        progress.setWorkRemaining(85);
        IItemManager itemManager = repo.itemManager();
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        String componentName = "";
        IComponent fetchedComponent = null;
        fetchedComponent = (IComponent)itemManager.fetchCompleteItem(component.getItemHandle(), refreshFlag, (IProgressMonitor)progress.newChild(15));
        if (fetchedComponent != null) {
            componentName = fetchedComponent.getName();
        }
        IAuditable componentOwner = null;
        boolean isOwnerInaccessible = false;
        try {
            List componentOwners = wm.findOwnersForComponents(componentHandles, (IProgressMonitor)progress.newChild(15));
            if (componentOwners.size() > 0) {
                componentOwner = (IAuditable)itemManager.fetchCompleteItem((IItemHandle)componentOwners.get(0), refreshFlag, (IProgressMonitor)progress.newChild(20));
            }
        }
        catch (PermissionDeniedException e) {
            isOwnerInaccessible = true;
        }
        catch (ItemNotFoundException e) {
            // empty catch block
        }
        progress.setWorkRemaining(35);
        IReadScope readScope = null;
        try {
            List componentVisibilities = wm.findReadScopeForComponents(componentHandles, (IProgressMonitor)progress.newChild(15));
            if (componentVisibilities.size() > 0) {
                readScope = (IReadScope)componentVisibilities.get(0);
            }
        }
        catch (ItemNotFoundException componentVisibilities) {
            // empty catch block
        }
        IAuditable parentOwner = null;
        try {
            if (componentOwner instanceof ITeamArea) {
                IProcessArea teamArea = (IProcessArea)componentOwner;
                parentOwner = (IAuditable)itemManager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), refreshFlag, (IProgressMonitor)progress.newChild(20));
            }
            if (readScope instanceof IContributorDeferringScope) {
                IAuditableHandle scope = ((IContributorDeferringScope)readScope).getScope();
                parentOwner = (IAuditable)itemManager.fetchCompleteItem((IItemHandle)scope, refreshFlag, (IProgressMonitor)progress.newChild(20));
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return new ComponentData(componentName, componentOwner, isOwnerInaccessible, parentOwner, readScope);
    }

    public MODE getMode() {
        return this.fMode;
    }

    public boolean isInMode(MODE mode) {
        return this.fMode == mode;
    }

    private void setMode(MODE newMode) {
        this.fMode = newMode;
    }

    @Override
    public boolean isCreation() {
        return this.fMode.isCreation();
    }

    public String getToolTipText() {
        return this.fComponentName != null ? this.fComponentName : this.getOriginalComponentName();
    }

    public String getOriginalComponentName() {
        return this.fOriginalComponentName;
    }

    private void setOriginalComponentName(String name) {
        Assert.isNotNull((Object)name);
        if (!name.equals(this.fOriginalComponentName)) {
            String currentName = this.getComponentName();
            this.fOriginalComponentName = name;
            if (!currentName.equals(this.getComponentName())) {
                this.notifyListeners((Object)PROPERTY.COMPONENT_NAME);
            }
        }
    }

    public String getComponentName() {
        return this.fComponentName != null ? this.fComponentName : this.getOriginalComponentName();
    }

    public void setComponentName(String componentName) {
        if (this.fOriginalComponentName.equals(componentName)) {
            componentName = null;
        }
        if (componentName == null ? this.fComponentName != null : !componentName.equals(this.fComponentName)) {
            String oldComponentName = this.getComponentName();
            this.fComponentName = componentName;
            this.stateChanged();
            if (!oldComponentName.equals(this.getComponentName())) {
                this.notifyListeners((Object)PROPERTY.COMPONENT_NAME);
            }
        }
    }

    public String getNewComponentName() {
        return Messages.ComponentWorkingCopy_NewComponentName;
    }

    public IAuditable getOriginalComponentOwner() {
        return this.fOriginalComponentOwner;
    }

    private void setOriginalComponentOwner(IAuditable owner) {
        if (this.fOriginalComponentOwner != owner) {
            IAuditable currentOwner = this.getComponentOwner();
            this.fOriginalComponentOwner = owner;
            if (currentOwner == null ? this.getComponentOwner() != null : !currentOwner.equals((Object)this.getComponentOwner())) {
                this.notifyListeners((Object)PROPERTY.COMPONENT_OWNER);
            }
        }
    }

    public IAuditable getComponentOwner() {
        return this.fComponentOwner != null ? this.fComponentOwner : this.getOriginalComponentOwner();
    }

    public void setComponentOwner(IAuditable owner) {
        if (this.fOriginalComponentOwner == null ? owner == null : this.fOriginalComponentOwner.sameItemId((IItemHandle)owner)) {
            owner = null;
        }
        if (this.fComponentOwner == null ? owner != null : !this.fComponentOwner.sameItemId((IItemHandle)owner)) {
            IAuditable oldOwner = this.getComponentOwner();
            this.fComponentOwner = owner;
            this.stateChanged();
            if (oldOwner == null ? this.getComponentOwner() != null : !oldOwner.equals((Object)this.getComponentOwner())) {
                this.notifyListeners((Object)PROPERTY.COMPONENT_OWNER);
            }
        }
    }

    public boolean isOwnerInaccessible() {
        return this.isOwnerInaccessible;
    }

    public void setOwnerInaccessible(boolean isInaccessible) {
        boolean originalValue = this.isOwnerInaccessible;
        this.isOwnerInaccessible = isInaccessible;
        if (isInaccessible != originalValue) {
            this.notifyListeners((Object)PROPERTY.COMPONENT_OWNER);
        }
    }

    public IAuditable getOriginalParentOwner() {
        return this.fOriginalParentOwner;
    }

    private void setOriginalParentOwner(IAuditable parentOwner) {
        Assert.isLegal((parentOwner == null || parentOwner instanceof IProjectArea ? 1 : 0) != 0);
        if (this.fOriginalParentOwner != parentOwner) {
            IAuditable oldParentOwner = this.getParentOwner();
            this.fOriginalParentOwner = parentOwner;
            if (oldParentOwner == null ? this.getParentOwner() != null : !oldParentOwner.equals((Object)this.getParentOwner())) {
                this.notifyListeners((Object)PROPERTY.COMPONENT_VISIBILITY);
            }
        }
    }

    public IAuditable getParentOwner() {
        return this.fParentOwner != null ? this.fParentOwner : this.getOriginalParentOwner();
    }

    public void setParentOwner(IAuditable parentOwner) {
        if (this.fOriginalParentOwner == null ? parentOwner == null : this.fOriginalParentOwner.sameItemId((IItemHandle)parentOwner)) {
            parentOwner = null;
        }
        Assert.isLegal((parentOwner == null || parentOwner instanceof IProjectArea ? 1 : 0) != 0);
        if (this.fParentOwner == null ? parentOwner != null : !this.fParentOwner.sameItemId((IItemHandle)parentOwner)) {
            IAuditable oldParentOwner = this.getParentOwner();
            this.fParentOwner = parentOwner;
            this.stateChanged();
            if (oldParentOwner == null ? this.getParentOwner() != null : !oldParentOwner.equals((Object)this.getParentOwner())) {
                this.notifyListeners((Object)PROPERTY.COMPONENT_VISIBILITY);
            }
        }
    }

    public IReadScope getOriginalComponentReadScope() {
        return this.fOriginalComponentReadScope;
    }

    private void setOriginalComponentReadScope(IReadScope readScope) {
        Assert.isLegal((readScope != null ? 1 : 0) != 0);
        if (!ReadScopeUtils.equals((IReadScope)this.fOriginalComponentReadScope, (IReadScope)readScope)) {
            IReadScope oldReadScope = this.getComponentReadScope();
            this.fOriginalComponentReadScope = readScope;
            if (oldReadScope == null ? this.getComponentReadScope() != null : !ReadScopeUtils.equals((IReadScope)oldReadScope, (IReadScope)this.getComponentReadScope())) {
                this.notifyListeners((Object)PROPERTY.COMPONENT_VISIBILITY);
            }
        }
    }

    public IReadScope getComponentReadScope() {
        return this.fComponentReadScope != null ? this.fComponentReadScope : this.getOriginalComponentReadScope();
    }

    public void setComponentReadScope(IReadScope readScope) {
        if (ReadScopeUtils.equals((IReadScope)this.getComponentReadScope(), (IReadScope)readScope)) {
            return;
        }
        this.fComponentReadScope = readScope;
        this.stateChanged();
        this.notifyListeners((Object)PROPERTY.COMPONENT_VISIBILITY);
    }

    private ComponentWrapper getOriginalComponentWrapper() {
        return this.fOriginalComponentWrapper;
    }

    private void setOriginalComponentWrapper(ComponentWrapper componentWrapper) {
        this.fOriginalComponentWrapper = componentWrapper;
    }

    public ComponentWrapper getComponentWrapper() {
        return this.fComponentWrapper;
    }

    public void setComponentWrapper(ComponentWrapper componentWrapper) {
        this.fComponentWrapper = componentWrapper;
    }

    private void stateChanged() {
        this.setDirty(true);
        this.setValid(this.checkValid());
    }

    private boolean checkValid() {
        return this.getComponentWrapper() != null && this.getComponentName() != null && this.getComponentName().length() > 0 && this.getComponentOwner() != null && this.getComponentReadScope() != null;
    }

    @Override
    public IStatus validateForSave() {
        if (this.getComponentName().equals("")) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.ComponentWorkingCopy_MissingName);
        }
        if (this.getComponentOwner() == null) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.ComponentWorkingCopy_MissingOwner);
        }
        if (this.getComponentReadScope() == null) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.ComponentWorkingCopy_MissingVisibility);
        }
        return Status.OK_STATUS;
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        StatusCollector problems = new StatusCollector();
        if (this.isInMode(MODE.NEW_COMPONENT)) {
            new NewComponentOperation(this).run(monitor, (IStatusCollector)problems);
        } else if (this.isInMode(MODE.EDIT_COMPONENT)) {
            new EditComponentOperation(this).run(monitor, (IStatusCollector)problems);
        } else {
            Assert.isTrue((boolean)false, (String)Messages.ComponentWorkingCopy_UnexpectedMode);
        }
        if (!problems.getStatus().isOK()) {
            StatusUtil.log((IStatus)problems.getStatus());
        }
    }

    @Override
    protected void onSaved() {
        if (this.isInMode(MODE.NEW_COMPONENT)) {
            this.setMode(MODE.EDIT_COMPONENT);
        }
        this.setOriginalComponentWrapper(null);
        this.setDirty(false);
    }

    @Override
    public void refresh() {
        if (this.isCreation()) {
            return;
        }
        this.reloadFromRepository();
        this.setDirty(false);
    }

    private void reloadFromRepository() {
        this.setComponentName(null);
        this.setComponentOwner(null);
        this.setOwnerInaccessible(false);
        this.setParentOwner(null);
        this.setComponentReadScope(null);
        this.init(ComponentEditorInput.newForEdit(this.getComponentWrapper()));
    }

    @Override
    public void dispose() {
        ComponentWrapper wrapper = this.getComponentWrapper();
        if (wrapper != null) {
            IItemManager itemManager = wrapper.getRepository().itemManager();
            itemManager.removeItemChangeListener((IItem)wrapper.getComponent(), this.fSharedItemChangeListener);
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
            wm.removeGenericListener((Object)"component_owner", this.fOwnerVizListener);
            wm.removeGenericListener((Object)"component_visibility", this.fOwnerVizListener);
        }
        this.fSharedItemChangeListener = null;
        this.fOwnerVizListener = null;
        super.dispose();
    }

    private static class ComponentData {
        private String name;
        private IAuditable owner;
        private boolean isOwnerInaccessible;
        private IAuditable parentOwner;
        private IReadScope readScope;

        public ComponentData(String name, IAuditable owner, boolean isOwnerInaccessible, IAuditable parentOwner, IReadScope readScope) {
            this.name = name;
            this.owner = owner;
            this.isOwnerInaccessible = isOwnerInaccessible;
            this.parentOwner = parentOwner;
            this.readScope = readScope;
        }

        public String getName() {
            return this.name;
        }

        public IReadScope getReadScope() {
            return this.readScope;
        }

        public IAuditable getOwner() {
            return this.owner;
        }

        public boolean isOwnerInaccessible() {
            return this.owner == null && this.isOwnerInaccessible;
        }

        public IAuditable getParentOwner() {
            return this.parentOwner;
        }
    }

    public static enum MODE {
        NEW_COMPONENT(true),
        EDIT_COMPONENT(false);

        private boolean isCreation;

        private MODE(boolean isCreation) {
            this.isCreation = isCreation;
        }

        public boolean isCreation() {
            return this.isCreation;
        }
    }

    public static enum PROPERTY {
        COMPONENT_NAME,
        COMPONENT_OWNER,
        COMPONENT_VISIBILITY;

    }
}

