/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.component;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentWorkingCopy;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.OwnerPicker;
import com.ibm.team.internal.filesystem.ui.picker.VisibilityPicker;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.scm.client.IReadScopeDescriber;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.ui.editor.TeamFormPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ComponentEditorOverviewPage
extends TeamFormPage {
    public static final String PAGE_ID = "com.ibm.team.filesystem.ide.ui.ComponentEditor.ComponentOverviewPage";
    private ComponentWorkingCopy fWorkingCopy;
    private IOperationRunner fRunner;
    private Section fDetailsSection;
    private OwnerControl fOwnerControl;
    private Button fBrowseOwnerButton;
    private Label fVisibilityControl;
    private Button fChangeVisibilityButton;
    private IChangeListener fChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            ComponentEditorOverviewPage.this.updateEnablement();
            if (property == ComponentWorkingCopy.PROPERTY.COMPONENT_OWNER) {
                ComponentEditorOverviewPage.this.updateOwner();
            } else if (property == ComponentWorkingCopy.PROPERTY.COMPONENT_VISIBILITY) {
                ComponentEditorOverviewPage.this.updateVisibility();
            }
        }
    };

    public ComponentEditorOverviewPage(FormEditor editor, ComponentWorkingCopy workingCopy, IOperationRunner runner) {
        super(editor, PAGE_ID, Messages.ComponentEditorOverviewPage_PageTitle);
        this.fWorkingCopy = workingCopy;
        this.fRunner = runner;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(body);
        Section detailsSection = this.createDetailsSection(body);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)detailsSection);
        this.fWorkingCopy.addListener(this.fChangeListener);
        this.updateEnablement();
    }

    private Section createDetailsSection(Composite parent) {
        FileSystemEditorToolkit toolkit = (FileSystemEditorToolkit)this.getManagedForm().getToolkit();
        this.fDetailsSection = this.createSection(toolkit, parent, 256, Messages.ComponentEditorOverviewPage_DetailsSectionTitle);
        Composite detailsComposite = toolkit.createComposite((Composite)this.fDetailsSection);
        this.fDetailsSection.setClient((Control)detailsComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(LayoutConstants.getSpacing()).applyTo(detailsComposite);
        toolkit.createLabel(detailsComposite, Messages.ComponentEditorOverviewPage_OwnedByLabel);
        this.fOwnerControl = new OwnerControl(toolkit, detailsComposite, "owner");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fOwnerControl);
        this.fBrowseOwnerButton = this.createPushButton(detailsComposite, Messages.ComponentEditorOverviewPage_BrowseOwnerButtonText, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentEditorOverviewPage.this.doBrowseOwner();
            }
        });
        toolkit.createLabel(detailsComposite, Messages.ComponentEditorOverviewPage_VisibilityLabel);
        this.fVisibilityControl = toolkit.createLabel(detailsComposite, "", 64);
        GridDataFactory.defaultsFor((Control)this.fVisibilityControl).align(1, 0x1000000).hint(-1, -1).applyTo((Control)this.fVisibilityControl);
        this.fChangeVisibilityButton = this.createPushButton(detailsComposite, Messages.ComponentEditorOverviewPage_ChangeVisibilityButtonText, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentEditorOverviewPage.this.doChangeContributorVisibility();
            }
        });
        GridDataFactory.defaultsFor((Control)this.fChangeVisibilityButton).align(1, 0x1000000).applyTo((Control)this.fChangeVisibilityButton);
        this.updateOwner();
        return this.fDetailsSection;
    }

    private void doBrowseOwner() {
        OwnerPicker ownerPicker;
        Display display = Display.getCurrent();
        final ITeamRepository repo = this.fWorkingCopy.getComponentWrapper().getRepository();
        String pickerDescription = null;
        if (this.fWorkingCopy.getComponentName() != null) {
            pickerDescription = NLS.bind((String)Messages.ComponentEditorOverviewPage_OwnerPickerDialogMessage, (Object)this.fWorkingCopy.getComponentName());
        }
        if ((ownerPicker = new OwnerPicker(this.getSite().getShell(), repo, pickerDescription)).open() == 0) {
            IAuditable owner = ownerPicker.getOwner();
            IReadScope readScope = ownerPicker.getReadScope();
            if (owner != null) {
                this.getOperationRunner().enqueue(Messages.ComponentEditorOverviewPage_FetchComponentOwnerJobName, (Operation)new RepositoryOperation((IAuditableHandle)owner, display, readScope){
                    private final /* synthetic */ IAuditableHandle val$owner;
                    private final /* synthetic */ Display val$display;
                    private final /* synthetic */ IReadScope val$readScope;
                    {
                        this.val$owner = iAuditableHandle;
                        this.val$display = display;
                        this.val$readScope = iReadScope;
                    }

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        final IAuditable ownerItem = (IAuditable)repo.itemManager().fetchCompleteItem((IItemHandle)this.val$owner, 0, monitor);
                        if (ownerItem != null) {
                            SWTUtil.greedyExec((Display)this.val$display, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ComponentEditorOverviewPage.this.doSetOwner(ownerItem);
                                    if (val$readScope != null) {
                                        ComponentEditorOverviewPage.this.fWorkingCopy.setComponentReadScope(val$readScope);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    private void doSetOwner(IAuditable owner) {
        this.fWorkingCopy.setComponentOwner(owner);
        if (owner != null && owner instanceof ITeamArea) {
            this.doSetParentOwner((ITeamArea)owner);
        }
    }

    private void doSetParentOwner(final ITeamArea owner) {
        if (owner != null) {
            final Display d = Display.getCurrent();
            this.getOperationRunner().enqueue(Messages.ComponentEditorOverviewPage_FetchProjectAreaJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    ITeamRepository repo = ComponentEditorOverviewPage.this.fWorkingCopy.getComponentWrapper().getRepository();
                    IProjectAreaHandle projectArea = owner.getProjectArea();
                    final IAuditable fetchedProjectArea = (IAuditable)repo.itemManager().fetchCompleteItem((IItemHandle)projectArea, 0, monitor);
                    SWTUtil.greedyExec((Display)d, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ComponentEditorOverviewPage.this.fWorkingCopy.setParentOwner(fetchedProjectArea);
                        }
                    });
                }
            });
        }
    }

    private void updateOwner() {
        if (this.fOwnerControl != null && !this.fOwnerControl.isDisposed()) {
            this.fOwnerControl.setOwner(this.fWorkingCopy.getComponentOwner(), this.fWorkingCopy.isOwnerInaccessible());
        }
        this.updateVisibility();
    }

    private void doChangeContributorVisibility() {
        IAuditable owner = this.fWorkingCopy.getComponentOwner();
        IProjectArea projectArea = null;
        ITeamArea teamArea = null;
        if (owner instanceof IProjectArea) {
            projectArea = (IProjectArea)owner;
        } else if (owner instanceof ITeamArea) {
            teamArea = (ITeamArea)owner;
            projectArea = (IProjectArea)this.fWorkingCopy.getParentOwner();
        }
        VisibilityPicker picker = new VisibilityPicker((IShellProvider)this.getSite(), this.fWorkingCopy.getComponentWrapper().getRepository(), this.fWorkingCopy.getComponentReadScope(), VisibilityPicker.PickerMode.COMPONENT, Messages.ComponentEditorOverviewPage_VisibilityPickerDescription);
        picker.setOwner(owner);
        picker.setProcessAreas(projectArea, teamArea);
        if (picker.open() == 0) {
            this.fWorkingCopy.setComponentReadScope(picker.getReadScope());
        }
    }

    private void updateVisibility() {
        IReadScope readScope;
        if (this.fVisibilityControl != null && !this.fVisibilityControl.isDisposed() && (readScope = this.fWorkingCopy.getComponentReadScope()) != null) {
            String shortDescription;
            String labelText = shortDescription = IReadScopeDescriber.FACTORY.shortDescription(readScope);
            if (readScope instanceof IContributorDeferringScope) {
                IAuditableHandle scope = ((IContributorDeferringScope)readScope).getScope();
                if (scope instanceof IProcessAreaHandle) {
                    if (scope instanceof IProcessArea) {
                        labelText = NLS.bind((String)Messages.ComponentEditorOverviewPage_VisibilityScopeAndName, (Object)shortDescription, (Object)((IProcessArea)scope).getName());
                    } else {
                        IAuditable parentOwner = this.fWorkingCopy.getParentOwner();
                        if (parentOwner != null && parentOwner.sameItemId((IItemHandle)scope)) {
                            labelText = NLS.bind((String)Messages.ComponentEditorOverviewPage_VisibilityScopeAndName, (Object)shortDescription, (Object)((IProcessArea)parentOwner).getName());
                        }
                    }
                }
            } else if (readScope instanceof IAccessGroupScope) {
                final IAccessGroupScope accessGroupScope = (IAccessGroupScope)readScope;
                this.fRunner.enqueue(Messages.ComponentEditorOverviewPage_FetchingAccessGroupJobName, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                        IAccessGroupClientService accessGroupService = (IAccessGroupClientService)ComponentEditorOverviewPage.this.fWorkingCopy.getComponentWrapper().getRepository().getClientLibrary(IAccessGroupClientService.class);
                        IAccessGroup accessGroup = accessGroupService.getAccessGroupForGroupContextId(accessGroupScope.getAccessGroupId(), monitor);
                        if (accessGroup != null) {
                            final String name = accessGroup.getName();
                            Display display = ComponentEditorOverviewPage.this.fVisibilityControl.getDisplay();
                            if (name != null && !display.isDisposed()) {
                                SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!ComponentEditorOverviewPage.this.fVisibilityControl.isDisposed()) {
                                            ComponentEditorOverviewPage.this.fVisibilityControl.setText(NLS.bind((String)Messages.ComponentEditorOverviewPage_VisibilityScopeAndName, (Object)shortDescription, (Object)name));
                                            ComponentEditorOverviewPage.this.fDetailsSection.layout(true, true);
                                        }
                                    }
                                });
                            }
                        }
                    }
                });
            }
            this.fVisibilityControl.setText(labelText);
        }
        if (this.fDetailsSection != null && !this.fDetailsSection.isDisposed()) {
            this.fDetailsSection.layout(true, true);
        }
    }

    public void setFocus() {
        if (this.getLastActivePart() != null) {
            this.getLastActivePart().setFocus();
        } else {
            ScmItemEditorHeader formPart = ((ComponentEditor)this.getEditor()).getEditorHeader();
            formPart.setFocus();
        }
    }

    private void updateEnablement() {
        OwnerControl first = this.fOwnerControl;
        if (first != null && first.isDisposed()) {
            return;
        }
        boolean isBusy = this.fWorkingCopy.isBusy();
        if (this.fOwnerControl != null) {
            this.fOwnerControl.setEnabled(!isBusy);
        }
        if (this.fBrowseOwnerButton != null) {
            this.fBrowseOwnerButton.setEnabled(!isBusy);
        }
        if (this.fChangeVisibilityButton != null) {
            this.fChangeVisibilityButton.setEnabled(!isBusy);
        }
    }

    private Button createPushButton(Composite parent, String text, SelectionListener listener) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Button button = toolkit.createButton(parent, text, 8);
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    private Section createSection(FormToolkit toolkit, Composite parent, int style, String title) {
        Section section = toolkit.createSection(parent, style | 0x2000);
        section.setText(title);
        return section;
    }

    private IOperationRunner getOperationRunner() {
        return this.fRunner;
    }

    public void dispose() {
        this.fWorkingCopy.removeListener(this.fChangeListener);
        this.fWorkingCopy = null;
        this.fChangeListener = null;
        this.fOwnerControl = null;
        this.fRunner = null;
        this.initialize(null);
        super.dispose();
    }

    private class OwnerControl
    extends Composite {
        private Label fMissingLabel;
        private StandardControlLabelProvider fLabelProvider;

        public OwnerControl(FileSystemEditorToolkit toolkit, Composite parent, String id) {
            super(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo((Composite)this);
            this.fMissingLabel = new Label((Composite)this, 0);
            this.fMissingLabel.setText(Messages.ComponentEditorOverviewPage_OwnerNone);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.fMissingLabel);
            this.fLabelProvider = toolkit.createDecoratedImageHyperlink(this, ComponentEditorOverviewPage.this.getSite(), String.valueOf(ComponentEditorOverviewPage.this.getSite().getId()) + "." + id);
            GridDataFactory.fillDefaults().minSize(100, 0).align(4, 0x1000000).grab(true, true).applyTo(this.fLabelProvider.getControl());
        }

        public void setOwner(IAuditable owner, boolean isInaccessible) {
            this.fLabelProvider.setTextAware(owner != null);
            this.fLabelProvider.setElement((Object)owner);
            Control labelControl = this.fLabelProvider.getControl();
            if (labelControl instanceof ImageHyperlink) {
                final String ownerText = ((ImageHyperlink)labelControl).getText();
                this.fLabelProvider.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                    public void getName(AccessibleEvent e) {
                        e.result = NLS.bind((String)Messages.ComponentEditorOverviewPage_OwnerAccessibleLabel, (Object)ownerText);
                    }
                });
            }
            if (owner == null) {
                if (isInaccessible) {
                    this.fMissingLabel.setText(Messages.ComponentEditorOverviewPage_OwnerInaccessible);
                } else {
                    this.fMissingLabel.setText(Messages.ComponentEditorOverviewPage_OwnerNone);
                }
            } else if (owner instanceof ITeamArea) {
                this.fLabelProvider.setTextAware(false);
            }
            boolean hasOwner = owner != null;
            Label c1 = this.fMissingLabel;
            Control c2 = this.fLabelProvider.getControl();
            c1.setVisible(!hasOwner);
            c2.setVisible(hasOwner);
            ((GridData)c1.getLayoutData()).exclude = hasOwner;
            ((GridData)c2.getLayoutData()).exclude = !hasOwner;
            this.layout();
        }

        public void setEnabled(boolean enabled) {
            if (enabled != this.fLabelProvider.getControl().getEnabled()) {
                this.fLabelProvider.getControl().setEnabled(enabled);
            }
        }
    }
}

