/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.component;

import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IReadScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ComponentEditorInput
implements IEditorInput {
    private ComponentWrapper fComponent;
    private AbstractWrapper fDefaultOwner;
    private IReadScope fDefaultReadScope;
    private boolean fIsCreation;

    public static ComponentEditorInput newForEdit(ComponentWrapper component) {
        return new ComponentEditorInput(false, component);
    }

    public static ComponentEditorInput newForEdit(WorkspaceComponentWrapper component) {
        return new ComponentEditorInput(false, component);
    }

    private ComponentEditorInput(boolean isCreation, ComponentWrapper component) {
        if (!isCreation) {
            Assert.isLegal((component != null ? 1 : 0) != 0);
            this.fComponent = component;
        }
        this.fIsCreation = isCreation;
    }

    private ComponentEditorInput(boolean isCreation, WorkspaceComponentWrapper component) {
        if (!isCreation) {
            Assert.isLegal((component != null ? 1 : 0) != 0);
            this.fComponent = new ComponentWrapper(component.getRepository(), component.getComponent());
        }
        this.fIsCreation = isCreation;
    }

    public ITeamRepository getRepository() {
        return this.fComponent != null ? this.fComponent.getRepository() : null;
    }

    public IComponent getComponent() {
        return this.fComponent != null ? this.fComponent.getComponent() : null;
    }

    public ComponentWrapper getComponentWrapper() {
        return this.fComponent;
    }

    public AbstractWrapper getOwner() {
        return this.fDefaultOwner;
    }

    public ComponentEditorInput setOwner(AbstractWrapper owner) {
        this.fDefaultOwner = owner;
        return this;
    }

    public IReadScope getReadScope() {
        return this.fDefaultReadScope;
    }

    public final ComponentEditorInput setReadScope(IReadScope readScope) {
        this.fDefaultReadScope = readScope;
        return this;
    }

    public boolean isCreation() {
        return this.fIsCreation;
    }

    public String getName() {
        if (this.fComponent != null) {
            return this.fComponent.getComponent().getName();
        }
        return Messages.ComponentEditorInput_NewComponent;
    }

    public String getToolTipText() {
        if (this.fComponent != null) {
            return this.fComponent.getComponent().getName();
        }
        return Messages.ComponentEditorInput_NewComponent;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImagePool.COMPONENT;
    }

    public boolean exists() {
        return true;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fComponent == null ? 0 : this.fComponent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentEditorInput other = (ComponentEditorInput)obj;
        return !(this.fComponent == null ? other.fComponent != null : !this.fComponent.equals((Object)other.fComponent));
    }
}

