/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.component;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentNamePart;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentWorkingCopy;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.common.IChangeListener;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;

public class ComponentEditorHeader
extends ScmItemEditorHeader {
    private ComponentWorkingCopy fComponentWorkingCopy;
    private IMenuListener fMenuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.remove("com.ibm.team.filesystem.actions.renamecomponent");
            manager.remove("com.ibm.team.filesystem.actions.setowner");
            manager.remove("com.ibm.team.filesystem.actions.changevisibilitycomponent");
        }
    };

    public ComponentEditorHeader(IEditorPart editor, IManagedForm header, ComponentWorkingCopy workingCopy) {
        super(editor, header, workingCopy, new ComponentNamePart(header, workingCopy));
        this.fComponentWorkingCopy = workingCopy;
        this.createEditorHeader();
        IMenuManager menuManager = this.getHeader().getForm().getForm().getMenuManager();
        if (menuManager != null) {
            menuManager.addMenuListener(this.fMenuListener);
        }
    }

    @Override
    public IChangeListener getDirtyListener() {
        return new IChangeListener(){

            public void changed(Object source, Object property) {
                if (property == ComponentWorkingCopy.PROP_DIRTY) {
                    ComponentEditorHeader.this.onDirtyStateChanged();
                }
            }
        };
    }

    @Override
    public String getTitleText() {
        return Messages.ComponentEditorHeader_HeaderTitle;
    }

    @Override
    public ImageDescriptor getTitleImageDescriptor() {
        return ImagePool.COMPONENT;
    }

    @Override
    public boolean isMenuNeeded() {
        return !this.isMenuCreated() && !this.fComponentWorkingCopy.isCreation();
    }

    @Override
    public ISelectionProvider getMenuSelectionProvider() {
        return new ISelectionProvider(){

            public ISelection getSelection() {
                if (ComponentEditorHeader.this.fComponentWorkingCopy.getComponentWrapper() != null) {
                    return new StructuredSelection((Object)ComponentEditorHeader.this.fComponentWorkingCopy.getComponentWrapper());
                }
                return StructuredSelection.EMPTY;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
    }

    @Override
    public boolean isDragSupportNeeded() {
        return !this.isDragSupportAdded() && !this.fComponentWorkingCopy.isCreation();
    }

    @Override
    public Object getDragObject() {
        return this.fComponentWorkingCopy.getComponentWrapper();
    }

    @Override
    public void dispose() {
        IMenuManager menuManager = this.getHeader().getForm().getForm().getMenuManager();
        if (menuManager != null) {
            menuManager.removeMenuListener(this.fMenuListener);
        }
        super.dispose();
    }
}

