/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.component;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorOverviewPage;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.WorkbenchUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.IComponent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.progress.IJobRunnable;

public class ComponentEditor
extends ScmItemEditor {
    public static final String ID = "com.ibm.team.filesystem.ide.ui.ComponentEditor";
    private ComponentWorkingCopy fWorkingCopy;
    private ComponentEditorHeader fHeader;
    private ComponentEditorOverviewPage fOverviewPage;
    private Saveable fSaveable;

    public static void open(IWorkbenchPage page, ComponentEditorInput input) {
        try {
            page.openEditor((IEditorInput)input, ID);
        }
        catch (PartInitException e) {
            StatusUtil.log(ComponentEditor.class, (Throwable)e);
        }
    }

    @Override
    protected void createWorkingCopy() {
        if (this.fWorkingCopy == null) {
            this.fWorkingCopy = new ComponentWorkingCopy(this.getEditorInput(), (IOperationRunner)this.getPartSiteJobRunner(), this.getSite().getShell());
            this.fWorkingCopy.addListener(this.getWorkingCopyChangeListener());
            if (this.fWorkingCopy.getComponentWrapper() != null) {
                this.registerComponentDeletedListener(this.fWorkingCopy.getComponentWrapper());
            }
        }
    }

    private void registerComponentDeletedListener(ComponentWrapper wrapper) {
        ITeamRepository repo = wrapper.getRepository();
        IComponent component = wrapper.getComponent();
        repo.itemManager().addItemChangeListener((IItem)component, this.getScmItemDeletedListener());
    }

    @Override
    public ScmItemWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ComponentWorkingCopy.class) {
            return this.fWorkingCopy;
        }
        return super.getAdapter(adapter);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        if (this.fHeader == null) {
            this.fHeader = new ComponentEditorHeader((IEditorPart)this, headerForm, this.fWorkingCopy);
            headerForm.addPart((IFormPart)this.fHeader);
        }
    }

    @Override
    public ScmItemEditorHeader getEditorHeader() {
        return this.fHeader;
    }

    protected void addPages() {
        try {
            this.fOverviewPage = new ComponentEditorOverviewPage((FormEditor)this, this.fWorkingCopy, (IOperationRunner)this.getPartSiteJobRunner());
            this.addPage((IFormPage)this.fOverviewPage);
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    @Override
    public String getHelpID() {
        return "com.ibm.team.filesystem.ide.ui.editor_component";
    }

    public void setFocus() {
        if (this.fOverviewPage != null) {
            this.fOverviewPage.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Override
    public void updateTitle() {
        String name = "";
        if (this.fWorkingCopy != null) {
            name = this.fWorkingCopy.getMode().isCreation() ? this.fWorkingCopy.getNewComponentName() : this.fWorkingCopy.getComponentName();
        }
        this.setPartName(name);
        ResourceManager resourceManager = this.getResourceManager();
        if (resourceManager != null) {
            this.setTitleImage(resourceManager.createImageWithDefault(ImagePool.COMPONENT));
        }
    }

    @Override
    public String getItemNotFoundExceptionMessage() {
        if (this.fWorkingCopy != null) {
            return NLS.bind((String)Messages.ComponentEditor_ComponentDeletedMsg, (Object)this.fWorkingCopy.getComponentName());
        }
        return null;
    }

    @Override
    public String getLicenseNotGrantedExceptionMessage() {
        if (this.fWorkingCopy != null) {
            return NLS.bind((String)Messages.ComponentEditor_LicenseNotGranted, (Object)this.fWorkingCopy.getComponentName());
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.fWorkingCopy != null) {
            ComponentWrapper wrapper = this.fWorkingCopy.getComponentWrapper();
            if (wrapper != null) {
                wrapper.getRepository().itemManager().removeItemChangeListener((IItem)wrapper.getComponent(), this.getScmItemDeletedListener());
            }
            this.fWorkingCopy.removeListener(this.getWorkingCopyChangeListener());
            this.fWorkingCopy.dispose();
            this.fWorkingCopy = null;
        }
        this.fSaveable = null;
        this.fOverviewPage = null;
        this.fHeader = null;
        super.dispose();
    }

    protected void setInput(IEditorInput input) {
        Assert.isLegal((boolean)(input instanceof ComponentEditorInput));
        super.setInput(input);
    }

    public Saveable[] getSaveables() {
        if (this.fSaveable == null) {
            if (this.fWorkingCopy == null) {
                return new Saveable[0];
            }
            this.fSaveable = new ComponentSaveable(this.fWorkingCopy);
        }
        return new Saveable[]{this.fSaveable};
    }

    private class ComponentSaveable
    extends Saveable {
        private final ComponentWorkingCopy fWorkingCopy;

        private ComponentSaveable(ComponentWorkingCopy workingCopy) {
            Assert.isNotNull((Object)((Object)workingCopy));
            this.fWorkingCopy = workingCopy;
        }

        public ComponentWorkingCopy getWorkingCopy() {
            return this.fWorkingCopy;
        }

        public String getName() {
            String name = null;
            ComponentWorkingCopy wc = this.getWorkingCopy();
            name = wc.getMode().isCreation() ? wc.getNewComponentName() : wc.getComponentName();
            if (name == null) {
                name = "";
            }
            return name;
        }

        public String getToolTipText() {
            String toolTip = null;
            ComponentWorkingCopy wc = this.getWorkingCopy();
            toolTip = wc.getMode().isCreation() ? wc.getNewComponentName() : wc.getToolTipText();
            if (toolTip == null) {
                toolTip = "";
            }
            return toolTip;
        }

        public ImageDescriptor getImageDescriptor() {
            return ImagePool.COMPONENT;
        }

        public boolean isDirty() {
            return this.getWorkingCopy().isDirty();
        }

        public void doSave(IProgressMonitor monitor) throws CoreException {
            throw new UnsupportedOperationException();
        }

        public IJobRunnable doSave(IProgressMonitor monitor, IShellProvider shellProvider) throws CoreException {
            ComponentEditor.this.commit(monitor);
            IStatus status = this.fWorkingCopy.validateForSave();
            if (!status.isOK()) {
                ComponentEditor.this.fHeader.setSaveError(NLS.bind((String)Messages.ComponentEditor_ErrorDuringSave, (Object)status.getMessage()));
                this.fWorkingCopy.setShowingSavePermissionError(false);
                monitor.setCanceled(true);
                return null;
            }
            ComponentEditor.this.fHeader.setSaveError(null);
            final Display display = shellProvider.getShell().getDisplay();
            final String componentName = this.fWorkingCopy.getComponentName();
            return new IJobRunnable(){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        if (Display.getCurrent() == null) {
                            ComponentSaveable.this.fWorkingCopy.save(monitor);
                        } else {
                            ComponentSaveable.this.fWorkingCopy.saveStarting();
                            WorkbenchUtil.runBackgroundSave((IProgressMonitor)monitor, (Operation)new Operation(){

                                public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                                    try {
                                        ComponentSaveable.this.fWorkingCopy.save(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                                    }
                                }
                            }, (String)NLS.bind((String)Messages.ComponentEditor_SavingComponentOpName, (Object)componentName));
                            ComponentSaveable.this.fWorkingCopy.saveDone();
                        }
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ComponentEditor.this.isDisposed()) {
                                    return;
                                }
                                ComponentSaveable.this.fWorkingCopy.saveSucceeded();
                                ComponentEditor.this.setInput(ComponentEditorInput.newForEdit(ComponentSaveable.this.fWorkingCopy.getComponentWrapper()));
                            }
                        });
                        if (ComponentSaveable.this.fWorkingCopy.getComponentWrapper() != null) {
                            ComponentEditor.this.registerComponentDeletedListener(ComponentSaveable.this.fWorkingCopy.getComponentWrapper());
                        }
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        final Throwable rootException = e.getStatus().getException();
                        if (rootException instanceof TeamOperationCanceledException) {
                            return Status.OK_STATUS;
                        }
                        if (rootException instanceof PermissionDeniedException) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ComponentEditor.this.isDisposed()) {
                                        ComponentEditor.this.fHeader.setSaveError(NLS.bind((String)Messages.ComponentEditor_ErrorDuringSave, (Object)rootException.getMessage()));
                                        ComponentSaveable.this.fWorkingCopy.setShowingSavePermissionError(true);
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                        if (rootException instanceof ItemNotFoundException) {
                            String message = NLS.bind((String)Messages.ComponentEditor_ComponentDeletedMsg, (Object)componentName);
                            return StatusUtil.newStatus((Object)this, (String)message, (Throwable)new CoreException(StatusUtil.newStatus((Object)this, (String)message, (Throwable)rootException)));
                        }
                        return e.getStatus();
                    }
                    catch (OperationCanceledException e) {
                        return Status.CANCEL_STATUS;
                    }
                }
            };
        }

        public void disableUI(IWorkbenchPart[] parts, boolean closing) {
            this.fWorkingCopy.saveStarting();
            super.disableUI(parts, closing);
        }

        public void enableUI(IWorkbenchPart[] parts) {
            this.fWorkingCopy.saveDone();
            super.enableUI(parts);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComponentSaveable)) {
                return false;
            }
            ComponentSaveable other = (ComponentSaveable)((Object)object);
            return this.getWorkingCopy() == other.getWorkingCopy();
        }

        public int hashCode() {
            return ((Object)((Object)this.getWorkingCopy())).hashCode();
        }
    }
}

