/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.baseline;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ui.operations.EditBaselineOperation;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalBaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.InaccessibleBaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.IBaselineHierarchyResult;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.QueryOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class BaselineEditorWorkingCopy
extends ScmItemWorkingCopy {
    private MODE fMode;
    private BaselineWrapper fOriginalBaselineWrapper;
    private BaselineWrapper fBaselineWrapper;
    private ITeamRepository fRepository;
    private String fOriginalBaselineName = "";
    private String fBaselineName;
    private String fOriginalTags = "";
    private String fTags;
    private String fOriginalDescription = "";
    private String fDescription = null;
    private Map<String, Object> originalCustomAttributes = new HashMap<String, Object>();
    private Map<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();
    private Set<String> customAttributesToRemove = new HashSet<String>();
    private ISharedItemChangeListener fSharedItemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            BaselineWrapper baselineWrapper = BaselineEditorWorkingCopy.this.getBaselineWrapper();
            if (baselineWrapper != null) {
                boolean synchronizeToRepository = false;
                for (Object event : events) {
                    if (!(event instanceof ISharedItemChangeEvent)) continue;
                    ISharedItemChangeEvent changeEvent = (ISharedItemChangeEvent)event;
                    if (!baselineWrapper.getBaseline().sameItemId((IItemHandle)changeEvent.getSharedItem())) continue;
                    synchronizeToRepository = true;
                    break;
                }
                if (synchronizeToRepository) {
                    BaselineEditorWorkingCopy.this.synchronizeToRepository();
                }
            }
        }
    };
    private IListener fComponentOwnerChangeListener = new IListener(){

        public void handleEvents(List events) {
            if (BaselineEditorWorkingCopy.this.getBaselineWrapper() == null) {
                return;
            }
            IComponent component = BaselineEditorWorkingCopy.this.getBaselineWrapper().getComponent();
            for (Object obj : events) {
                IComponentHandle componentChanged;
                PropertyChangeEvent event;
                if (!(obj instanceof PropertyChangeEvent) || !((event = (PropertyChangeEvent)obj).getObject() instanceof IComponentHandle) || !event.getProperty().equals("component_owner") || !(componentChanged = (IComponentHandle)event.getObject()).sameItemId((IItemHandle)component)) continue;
                BaselineEditorWorkingCopy.this.notifyListeners((Object)PROPERTY.COMPONENT_OWNER);
                break;
            }
        }
    };

    public BaselineEditorWorkingCopy(Object input, IOperationRunner runner, Shell shell) {
        super(Messages.BaselineWorkingCopy_BaselineWorkingCopyName, runner, shell);
        this.init(input);
    }

    private void init(Object editorInput) {
        if (editorInput instanceof BaselineEditorInput) {
            BaselineEditorInput input = (BaselineEditorInput)editorInput;
            this.setRepository(input.getRepository());
            if (input.isCreation()) {
                this.setMode(MODE.NEW_BASELINE);
                if (input.getBaselineWrapper() != null) {
                    this.setOriginalBaselineWrapper(input.getBaselineWrapper());
                }
                this.initForCreation();
            } else {
                this.setMode(MODE.EDIT_BASELINE);
                BaselineWrapper baseline = input.getBaselineWrapper();
                this.setBaselineWrapper(baseline);
                this.setOriginalBaselineName(baseline.getBaseline().getName());
                this.setOriginalTags(baseline.getTags());
                this.setOriginalDescription(baseline.getBaseline().getComment());
                this.initForEdit();
                this.setDirty(false);
            }
        } else {
            throw new IllegalArgumentException(Messages.BaselineWorkingCopy_WrongInput);
        }
        this.setValid(this.checkValid());
    }

    private void initForCreation() {
        if (this.getOriginalBaselineWrapper() != null) {
            this.initializeFromOriginal(this.getOriginalBaselineWrapper(), false);
            this.stateChanged();
        }
    }

    private void initializeFromOriginal(BaselineWrapper originalBaseline, boolean notifyStateChanged) {
    }

    private void initForEdit() {
        final BaselineWrapper baselineWrapper = this.getBaselineWrapper();
        if (baselineWrapper == null) {
            return;
        }
        ScmItemWorkingCopy.UIOperation<BaselineData> op = new ScmItemWorkingCopy.UIOperation<BaselineData>((ScmItemWorkingCopy)this){

            @Override
            protected BaselineData runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    BaselineData result = BaselineEditorWorkingCopy.this.loadFromRepository(baselineWrapper, true, monitor);
                    ITeamRepository repoToListenTo = baselineWrapper.getRepository();
                    repoToListenTo.itemManager().addItemChangeListener((IItem)baselineWrapper.getBaseline(), BaselineEditorWorkingCopy.this.fSharedItemChangeListener);
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)baselineWrapper.getRepository());
                    wm.addGenericListener((Object)"component_owner", BaselineEditorWorkingCopy.this.fComponentOwnerChangeListener);
                    return result;
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(BaselineData baselineData) {
                if (baselineData != null) {
                    BaselineEditorWorkingCopy.this.setOriginalBaselineName(baselineData.getName());
                    BaselineEditorWorkingCopy.this.setOriginalTags(baselineData.getTags());
                    BaselineEditorWorkingCopy.this.setOriginalDescription(baselineData.getDescription());
                    BaselineEditorWorkingCopy.this.setCustomAttributes(baselineData.getCustomAttributes());
                }
                BaselineEditorWorkingCopy.this.setDirty(false);
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.BaselineWorkingCopy_LoadingData, (Object)baselineWrapper.getBaseline().getName()));
    }

    private void synchronizeToRepository() {
        final BaselineWrapper baselineWrapper = this.getBaselineWrapper();
        if (baselineWrapper == null) {
            return;
        }
        ScmItemWorkingCopy.UIOperation<BaselineData> op = new ScmItemWorkingCopy.UIOperation<BaselineData>((ScmItemWorkingCopy)this){

            @Override
            protected BaselineData runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    return BaselineEditorWorkingCopy.this.loadFromRepository(baselineWrapper, false, monitor);
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(BaselineData baselineData) {
                if (baselineData != null) {
                    BaselineEditorWorkingCopy.this.setOriginalBaselineName(baselineData.getName());
                    BaselineEditorWorkingCopy.this.setOriginalTags(baselineData.getTags());
                    BaselineEditorWorkingCopy.this.setOriginalDescription(baselineData.getDescription());
                    BaselineEditorWorkingCopy.this.setCustomAttributes(baselineData.getCustomAttributes());
                }
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.BaselineWorkingCopy_UpdatingData, (Object)baselineWrapper.getBaseline().getName()));
    }

    private BaselineData loadFromRepository(BaselineWrapper baselineWrapper, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = baselineWrapper.getRepository();
        if (!repo.loggedIn()) {
            repo.login((IProgressMonitor)progress.newChild(10));
        }
        progress.setWorkRemaining(90);
        IBaseline baseline = baselineWrapper.getBaseline();
        String baselineName = baseline.getName();
        String baselineTags = baselineWrapper.getTags();
        String baselineDescription = baseline.getComment();
        if (refresh) {
            ArrayList<Object> toFetch = new ArrayList<Object>(2);
            toFetch.add(baseline);
            toFetch.add(baselineWrapper.getComponent());
            IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(toFetch, 1, (IProgressMonitor)progress.newChild(40));
            for (Object o : fetchResult.getRetrievedItems()) {
                if (!(o instanceof IBaseline)) continue;
                IBaseline fetchedBaseline = (IBaseline)o;
                baselineName = fetchedBaseline.getName();
                baselineTags = baselineWrapper.getTags();
                baselineDescription = fetchedBaseline.getComment();
                break;
            }
        }
        progress.setWorkRemaining(50);
        if (baselineWrapper.getHierarchyData() == null || refresh) {
            IBaselineConnection baselineConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(baselineWrapper.getBaseline(), (IProgressMonitor)progress.newChild(10));
            IBaselineHierarchyResult baselineHierarchy = baselineConnection.getBaselineHierarchy((IProgressMonitor)progress.newChild(10));
            IBaselineHierarchyNode baselineHierarchyNode = baselineHierarchy.getRoot();
            Collection baselineHandles = baselineHierarchy.getFlattenedElementsMap().values();
            Map<UUID, IBaseline> baselines = BaselineEditorWorkingCopy.fetchCompleteItems(repo, baselineHandles, 1, (IProgressMonitor)progress.newChild(15));
            ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(baselines.size());
            for (IBaseline b : baselines.values()) {
                componentHandles.add(b.getComponent());
            }
            Map<UUID, IComponent> components = BaselineEditorWorkingCopy.fetchCompleteItems(repo, componentHandles, 1, (IProgressMonitor)progress.newChild(15));
            BaselineWrapper updatedWrapper = (BaselineWrapper)BaselineEditorWorkingCopy.createHierarchy(repo, baselineHierarchyNode, baselines, components, null);
            this.setBaselineWrapper(updatedWrapper);
        }
        progress.done();
        return new BaselineData(baselineName, baselineTags, baselineDescription, baseline.getCustomAttributes());
    }

    private static <H extends IItemHandle, I extends H> Map<UUID, I> fetchCompleteItems(ITeamRepository repo, Collection items, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(new ArrayList(items), flags, monitor);
        return BaselineEditorWorkingCopy.getUuidToItemMap(fetchResult.getRetrievedItems());
    }

    private static <I extends IItemHandle> Map<UUID, I> getUuidToItemMap(Collection<I> items) {
        HashMap<UUID, IItemHandle> map = new HashMap<UUID, IItemHandle>(items.size());
        for (IItemHandle item : items) {
            map.put(item.getItemId(), item);
        }
        return map;
    }

    public static IHierarchicalBaselineWrapper createHierarchy(ITeamRepository repo, IBaselineHierarchyNode baselineHierarchyNode, Map<UUID, IBaseline> baselines, Map<UUID, IComponent> components, IHierarchicalBaselineWrapper parent) {
        IBaselineHandle baselineHandle = baselineHierarchyNode.getBaselineHandle();
        IBaseline baseline = baselines.get(baselineHandle.getItemId());
        IComponent component = components.get(baselineHierarchyNode.getComponentHandle().getItemId());
        IHierarchicalBaselineWrapper baselineWrapper = null;
        baselineWrapper = baseline == null || component == null ? new InaccessibleBaselineWrapper(repo, baselineHandle) : new BaselineWrapper(repo, baseline, component);
        baselineWrapper.createHierarchyData(baselineHierarchyNode, parent);
        ArrayList<IHierarchicalBaselineWrapper> children = new ArrayList<IHierarchicalBaselineWrapper>();
        for (IBaselineHierarchyNode childNode : baselineHierarchyNode.getChildren()) {
            IHierarchicalBaselineWrapper childWrapper = BaselineEditorWorkingCopy.createHierarchy(repo, childNode, baselines, components, baselineWrapper);
            children.add(childWrapper);
        }
        baselineWrapper.getHierarchyData().setChildren(children);
        return baselineWrapper;
    }

    public MODE getMode() {
        return this.fMode;
    }

    public boolean isInMode(MODE mode) {
        return this.fMode == mode;
    }

    private void setMode(MODE newMode) {
        this.fMode = newMode;
    }

    @Override
    public boolean isCreation() {
        return this.fMode.isCreation();
    }

    public String getToolTipText() {
        return this.fBaselineName != null ? this.fBaselineName : this.getOriginalBaselineName();
    }

    public ITeamRepository getRepository() {
        if (this.fRepository != null) {
            return this.fRepository;
        }
        if (this.fBaselineWrapper != null) {
            return this.fBaselineWrapper.getRepository();
        }
        return null;
    }

    public void setRepository(ITeamRepository newRepo) {
        if (this.fRepository != newRepo) {
            this.fRepository = newRepo;
            this.stateChanged();
        }
    }

    public String getOriginalBaselineName() {
        return this.fOriginalBaselineName;
    }

    private void setOriginalBaselineName(String name) {
        Assert.isNotNull((Object)name);
        if (!name.equals(this.fOriginalBaselineName)) {
            String currentName = this.getBaselineName();
            this.fOriginalBaselineName = name;
            if (!currentName.equals(this.getBaselineName())) {
                this.notifyListeners((Object)PROPERTY.BASELINE_NAME);
            }
        }
    }

    public String getBaselineName() {
        return this.fBaselineName != null ? this.fBaselineName : this.getOriginalBaselineName();
    }

    public void setBaselineName(String baselineName) {
        if (this.fOriginalBaselineName.equals(baselineName)) {
            baselineName = null;
        }
        if (baselineName == null ? this.fBaselineName != null : !baselineName.equals(this.fBaselineName)) {
            String oldBaselineName = this.getBaselineName();
            this.fBaselineName = baselineName;
            this.stateChanged();
            if (!oldBaselineName.equals(this.getBaselineName())) {
                this.notifyListeners((Object)PROPERTY.BASELINE_NAME);
            }
        }
    }

    public String getNewBaselineName() {
        return Messages.BaselineWorkingCopy_NewBaselineName;
    }

    public String getOriginalTags() {
        return this.fOriginalTags;
    }

    private void setOriginalTags(String text) {
        Assert.isNotNull((Object)text);
        if (!text.equals(this.fOriginalTags)) {
            String oldTags = this.getTags();
            this.fOriginalTags = text;
            if (!oldTags.equals(this.getTags())) {
                this.notifyListeners((Object)PROPERTY.BASELINE_TAGS);
            }
        }
    }

    public String getTags() {
        return this.fTags != null ? this.fTags : this.getOriginalTags();
    }

    public void setTags(String text) {
        if (this.fOriginalTags.equals(text)) {
            text = null;
        }
        if (text == null ? this.fTags != null : !text.equals(this.fTags)) {
            String oldtags = this.getTags();
            this.fTags = text;
            this.stateChanged();
            if (!oldtags.equals(this.getTags())) {
                this.notifyListeners((Object)PROPERTY.BASELINE_TAGS);
            }
        }
    }

    public String getOriginalDescription() {
        return this.fOriginalDescription;
    }

    private void setOriginalDescription(String text) {
        Assert.isNotNull((Object)text);
        if (!text.equals(this.fOriginalDescription)) {
            String oldDesc = this.getDescription();
            this.fOriginalDescription = text;
            if (!oldDesc.equals(this.getDescription())) {
                this.notifyListeners((Object)PROPERTY.BASELINE_DESCRIPTION);
            }
        }
    }

    public String getDescription() {
        return this.fDescription != null ? this.fDescription : this.getOriginalDescription();
    }

    public void setDescription(String text) {
        if (this.fOriginalDescription.equals(text)) {
            text = null;
        }
        if (text == null ? this.fDescription != null : !text.equals(this.fDescription)) {
            String oldDesc = this.getDescription();
            this.fDescription = text;
            this.stateChanged();
            if (!oldDesc.equals(this.getDescription())) {
                this.notifyListeners((Object)PROPERTY.BASELINE_DESCRIPTION);
            }
        }
    }

    public Collection<CustomAttributeEntry> getCustomAttributeSet() {
        return this.customAttributes.values();
    }

    protected void setCustomAttributes(Map<String, Object> attributes) {
        this.customAttributes.clear();
        this.originalCustomAttributes.clear();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            if (QueryOperations.TAGS_NAME.equals(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
            this.customAttributes.put(entry.getKey(), new CustomAttributeEntry(entry.getKey(), (String)entry.getValue()));
            this.originalCustomAttributes.put(entry.getKey(), entry.getValue());
        }
        this.notifyListeners((Object)PROPERTY.CUSTOM_ATTRIBUTES);
    }

    public void setCustomAttribute(String name, String newValue) {
        CustomAttributeEntry entry = this.customAttributes.get(name);
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (entry.getValue().equals(newValue)) {
            return;
        }
        if (QueryOperations.TAGS_NAME.equals(entry.getName())) {
            return;
        }
        this.customAttributes.put(entry.getName(), new CustomAttributeEntry(entry.getName(), newValue));
        this.stateChanged();
        this.notifyListeners((Object)PROPERTY.CUSTOM_ATTRIBUTES);
    }

    public void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        for (CustomAttributeEntry entryToRemove : toRemove) {
            if (this.customAttributes.remove(entryToRemove.getName()) == null) {
                throw new IllegalArgumentException();
            }
            this.customAttributesToRemove.add(entryToRemove.getName());
        }
        this.stateChanged();
        this.notifyListeners((Object)PROPERTY.CUSTOM_ATTRIBUTES);
    }

    public void addCustomAttribute(CustomAttributeEntry entry) {
        if (this.customAttributes.containsKey(entry.getName())) {
            throw new IllegalArgumentException();
        }
        if (QueryOperations.TAGS_NAME.equals(entry.getName())) {
            return;
        }
        this.customAttributes.put(entry.getName(), new CustomAttributeEntry(entry.getName(), entry.getValue()));
        this.customAttributesToRemove.remove(entry.getName());
        this.stateChanged();
        this.notifyListeners((Object)PROPERTY.CUSTOM_ATTRIBUTES);
    }

    public boolean isCustomAttributesChanged() {
        return !this.customAttributesToRemove.isEmpty() || !this.getCustomAttributesToAdd().isEmpty();
    }

    public Map<String, Object> getCustomAttributesToAdd() {
        Map<String, Object> original = this.getOriginalCustomAttributes();
        HashMap<String, Object> toAdd = new HashMap<String, Object>();
        for (Map.Entry<String, CustomAttributeEntry> entry : this.customAttributes.entrySet()) {
            String name = entry.getValue().getName();
            if (original.containsKey(name) && original.get(name).equals(entry.getValue().getValue())) continue;
            toAdd.put(name, entry.getValue().getValue());
        }
        return toAdd;
    }

    private Map<String, Object> getOriginalCustomAttributes() {
        return this.originalCustomAttributes;
    }

    public String[] getCustomAttributesToRemove() {
        return this.customAttributesToRemove.toArray(new String[this.customAttributesToRemove.size()]);
    }

    private BaselineWrapper getOriginalBaselineWrapper() {
        return this.fOriginalBaselineWrapper;
    }

    private void setOriginalBaselineWrapper(BaselineWrapper baselineWrapper) {
        this.fOriginalBaselineWrapper = baselineWrapper;
    }

    public BaselineWrapper getBaselineWrapper() {
        return this.fBaselineWrapper;
    }

    public void setBaselineWrapper(BaselineWrapper baselineWrapper) {
        boolean hierarchyChanges = baselineWrapper.getHierarchyData() != null && (this.fBaselineWrapper == null || this.fBaselineWrapper.getHierarchyData() == null);
        this.fBaselineWrapper = baselineWrapper;
        if (hierarchyChanges) {
            this.notifyListeners((Object)PROPERTY.BASELINE_HIERARCHY);
        }
    }

    private void stateChanged() {
        this.setDirty(true);
        this.setValid(this.checkValid());
    }

    private boolean checkValid() {
        return this.getBaselineWrapper() != null && this.getBaselineName() != null && this.getBaselineName().length() > 0;
    }

    @Override
    public IStatus validateForSave() {
        if (this.getBaselineName().equals("")) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.BaselineWorkingCopy_MissingName);
        }
        return Status.OK_STATUS;
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        StatusCollector problems = new StatusCollector();
        if (!this.isInMode(MODE.NEW_BASELINE)) {
            if (this.isInMode(MODE.EDIT_BASELINE)) {
                new EditBaselineOperation(this).run(monitor, (IStatusCollector)problems);
            } else {
                Assert.isTrue((boolean)false, (String)Messages.BaselineWorkingCopy_UnexpectedMode);
            }
        }
        if (!problems.getStatus().isOK()) {
            StatusUtil.log((IStatus)problems.getStatus());
        }
    }

    @Override
    protected void onSaved() {
        if (this.isInMode(MODE.NEW_BASELINE)) {
            this.setMode(MODE.EDIT_BASELINE);
        }
        this.setOriginalBaselineWrapper(null);
        this.setDirty(false);
    }

    @Override
    public void refresh() {
        if (this.isCreation()) {
            return;
        }
        this.reloadFromRepository();
        this.setDirty(false);
    }

    private void reloadFromRepository() {
        this.setBaselineName(null);
        this.setTags(null);
        this.setDescription(null);
        this.init(BaselineEditorInput.newForEdit(this.getBaselineWrapper()));
    }

    @Override
    public void dispose() {
        BaselineWrapper wrapper = this.getBaselineWrapper();
        if (wrapper != null) {
            IItemManager itemManager = wrapper.getRepository().itemManager();
            itemManager.removeItemChangeListener((IItem)wrapper.getBaseline(), this.fSharedItemChangeListener);
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
            wm.removeGenericListener((Object)"component_owner", this.fComponentOwnerChangeListener);
        }
        this.fSharedItemChangeListener = null;
        super.dispose();
    }

    private static class BaselineData {
        private String name;
        private String tags;
        private String description;
        private Map<String, Object> customAttributes;

        public BaselineData(String name, String tags, String description, Map<String, Object> customAttributes) {
            this.name = name;
            this.tags = tags;
            this.description = description;
            this.customAttributes = customAttributes;
        }

        public String getName() {
            return this.name;
        }

        public String getTags() {
            return this.tags;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, Object> getCustomAttributes() {
            return this.customAttributes;
        }
    }

    public static enum MODE {
        NEW_BASELINE(true),
        EDIT_BASELINE(false);

        private boolean isCreation;

        private MODE(boolean isCreation) {
            this.isCreation = isCreation;
        }

        public boolean isCreation() {
            return this.isCreation;
        }
    }

    public static enum PROPERTY {
        BASELINE_NAME,
        BASELINE_TAGS,
        BASELINE_DESCRIPTION,
        CUSTOM_ATTRIBUTES,
        BASELINE_HIERARCHY,
        COMPONENT_OWNER;

    }
}

