/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.baseline;

import com.ibm.team.filesystem.ide.ui.internal.editors.ComponentControl;
import com.ibm.team.filesystem.ide.ui.internal.editors.OwnerOrCreatorControl;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorPage;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineHierarchyTreeComparator;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineHierarchyTreeContentProvider;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselinePropertyTreeLabelProvider;
import com.ibm.team.filesystem.ide.ui.internal.util.DisplayHelper;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForBaselineEditor;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.scm.common.IBaseline;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class BaselineEditorOverviewPage
extends ScmItemEditorPage {
    public static final String PAGE_ID = "com.ibm.team.filesystem.ide.ui.BaselineEditor.BaselineOverviewPage";
    private boolean showUUIDs = Boolean.valueOf(System.getProperty("com.ibm.team.filesystem.ide.ui.BaselineEditor.showUUIDs", "false"));
    private BaselineEditorWorkingCopy fWorkingCopy;
    private ComponentControl fComponentControl;
    private Text fModifiedOnLabel;
    private OwnerOrCreatorControl fBaselineCreatorControl;
    private Text fTagsText;
    private Text fDescriptionText;
    private TextActionHandler fTextActionHandler;
    private CustomAttributeSectionForBaselineEditor fCustomAttributeSection;
    private TreeViewer fHierarchyTreeViewer;
    private IChangeListener fChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            BaselineEditorOverviewPage.this.updateEnablement();
            if (property == "busy") {
                if (!BaselineEditorOverviewPage.this.fWorkingCopy.isBusy()) {
                    BaselineEditorOverviewPage.this.updateModifiedWidgets();
                }
            } else if (property == BaselineEditorWorkingCopy.PROPERTY.BASELINE_TAGS) {
                BaselineEditorOverviewPage.this.updateTagWidgets();
            } else if (property == BaselineEditorWorkingCopy.PROPERTY.BASELINE_DESCRIPTION) {
                BaselineEditorOverviewPage.this.updateDescriptionWidgets();
            } else if (property == BaselineEditorWorkingCopy.PROPERTY.BASELINE_HIERARCHY) {
                BaselineEditorOverviewPage.this.updateBaselineHierarchyWidgets();
            } else if (property == BaselineEditorWorkingCopy.PROPERTY.COMPONENT_OWNER) {
                BaselineEditorOverviewPage.this.updateCustomAtributeSection(true);
            }
        }
    };

    public BaselineEditorOverviewPage(FormEditor editor, BaselineEditorWorkingCopy workingCopy, IOperationRunner runner) {
        super(editor, PAGE_ID, Messages.BaselineEditorOverviewPage_PageTitle, runner);
        this.fWorkingCopy = workingCopy;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(body);
        Section detailsSection = this.createDetailsSection(body);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)detailsSection);
        Control customAttributeSection = this.createCustomAttributeSection(body);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(customAttributeSection);
        Section hierarchySection = this.createBaselineHierarchySection(body);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)hierarchySection);
        this.fWorkingCopy.addListener(this.fChangeListener);
        this.updateEnablement();
    }

    private Section createDetailsSection(Composite parent) {
        FileSystemEditorToolkit toolkit = (FileSystemEditorToolkit)this.getManagedForm().getToolkit();
        int sectionStyle = 322;
        Section section = this.createSection(toolkit, parent, sectionStyle, Messages.BaselineEditorOverviewPage_DetailsSectionTitle);
        Composite detailsComposite = toolkit.createComposite((Composite)section);
        section.setClient((Control)detailsComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(LayoutConstants.getSpacing()).applyTo(detailsComposite);
        BaselineWrapper wrapper = this.fWorkingCopy.getBaselineWrapper();
        final ITeamRepository repo = wrapper.getRepository();
        final IBaseline baseline = wrapper.getBaseline();
        toolkit.createLabel(detailsComposite, Messages.BaselineEditorOverviewPage_BaselineIDLabel);
        Text baselineIDLabel = new Text(detailsComposite, 8);
        baselineIDLabel.setText(String.valueOf(baseline.getId()));
        GridDataFactory.defaultsFor((Control)baselineIDLabel).grab(true, false).span(2, 1).applyTo((Control)baselineIDLabel);
        if (this.showUUIDs) {
            toolkit.createLabel(detailsComposite, Messages.BaselineEditorOverviewPage_BaselineUUIDLabel);
            Text baselineUUIDLabel = new Text(detailsComposite, 8);
            baselineUUIDLabel.setText(baseline.getItemId().getUuidValue());
            GridDataFactory.defaultsFor((Control)baselineUUIDLabel).grab(true, false).span(2, 1).applyTo((Control)baselineUUIDLabel);
        }
        toolkit.createLabel(detailsComposite, Messages.BaselineEditorOverviewPage_ComponentLabel);
        this.fComponentControl = new ComponentControl(this.getSite(), toolkit, detailsComposite, "ComponentOfBaseline");
        this.fComponentControl.setComponent(wrapper.getComponent(), wrapper.getComponent() == null);
        GridDataFactory.defaultsFor((Control)this.fComponentControl).grab(true, false).span(2, 1).applyTo((Control)this.fComponentControl);
        if (this.showUUIDs) {
            toolkit.createLabel(detailsComposite, Messages.BaselineEditorOverviewPage_ComponentUUIDLabel);
            Text componentUUIDLabel = new Text(detailsComposite, 8);
            componentUUIDLabel.setText(wrapper.getComponent().getItemId().getUuidValue());
            GridDataFactory.defaultsFor((Control)componentUUIDLabel).grab(true, false).span(2, 1).applyTo((Control)componentUUIDLabel);
        }
        toolkit.createLabel(detailsComposite, Messages.BaselineEditorOverviewPage_CreatedByLabel);
        this.fBaselineCreatorControl = new OwnerOrCreatorControl(this.getSite(), toolkit, detailsComposite, "baselineCreator");
        GridDataFactory.defaultsFor((Control)this.fBaselineCreatorControl).grab(true, false).span(2, 1).applyTo((Control)this.fBaselineCreatorControl);
        this.getOperationRunner().enqueue(Messages.BaselineEditorOverviewPage_FetchingBaselineCreator, (Operation)new RepositoryOperation(repo){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                final IContributor[] creator = new IContributor[1];
                try {
                    creator[0] = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)baseline.getCreator(), 0, monitor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DisplayHelper.asyncExec((Control)BaselineEditorOverviewPage.this.fBaselineCreatorControl, new Runnable(){

                    @Override
                    public void run() {
                        BaselineEditorOverviewPage.this.fBaselineCreatorControl.setOwner((IItem)creator[0], creator[0] == null);
                    }
                });
            }
        });
        toolkit.createLabel(detailsComposite, Messages.BaselineEditorOverviewPage_CreatedOnLabel);
        Text createdOnLabel = new Text(detailsComposite, 8);
        createdOnLabel.setText(BaselineLabelProvider.getDate(baseline.getCreationDate()));
        GridDataFactory.defaultsFor((Control)createdOnLabel).grab(true, false).span(2, 1).applyTo((Control)createdOnLabel);
        toolkit.createLabel(detailsComposite, Messages.BaselineEditorOverviewPage_ModifiedOnLabel);
        this.fModifiedOnLabel = new Text(detailsComposite, 8);
        this.fModifiedOnLabel.setText(BaselineLabelProvider.getDate(baseline.modified()));
        GridDataFactory.defaultsFor((Control)this.fModifiedOnLabel).grab(true, false).span(2, 1).applyTo((Control)this.fModifiedOnLabel);
        Label tagsLabel = toolkit.createLabel(detailsComposite, Messages.BaselineEditorOverviewPage_TagsLabel);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)tagsLabel);
        this.fTagsText = toolkit.createText(detailsComposite, "", 2052);
        this.fTagsText.setTextLimit(32768);
        String currentTags = this.fWorkingCopy.getBaselineWrapper().getTags();
        this.fTagsText.setText(currentTags);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fTagsText);
        this.updateTagWidgets();
        this.fTagsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaselineEditorOverviewPage.this.fWorkingCopy.removeListener(BaselineEditorOverviewPage.this.fChangeListener);
                BaselineEditorOverviewPage.this.fWorkingCopy.setTags(BaselineEditorOverviewPage.this.fTagsText.getText());
                BaselineEditorOverviewPage.this.fWorkingCopy.addListener(BaselineEditorOverviewPage.this.fChangeListener);
            }
        });
        Label descriptionLabel = toolkit.createLabel(detailsComposite, "Description:");
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)descriptionLabel);
        this.fDescriptionText = toolkit.createText(detailsComposite, "", 2626);
        this.fDescriptionText.setTextLimit(32768);
        int h = this.calcTextHeight(this.fDescriptionText, 3);
        GridDataFactory.fillDefaults().grab(true, true).hint(1, h).span(2, 1).applyTo((Control)this.fDescriptionText);
        this.updateDescriptionWidgets();
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaselineEditorOverviewPage.this.fWorkingCopy.removeListener(BaselineEditorOverviewPage.this.fChangeListener);
                BaselineEditorOverviewPage.this.fWorkingCopy.setDescription(BaselineEditorOverviewPage.this.fDescriptionText.getText());
                BaselineEditorOverviewPage.this.fWorkingCopy.addListener(BaselineEditorOverviewPage.this.fChangeListener);
            }
        });
        return section;
    }

    public void addTextControls(TextActionHandler textActionHandler) {
        this.fTextActionHandler = textActionHandler;
        if (this.fTagsText != null) {
            textActionHandler.addText(this.fTagsText);
        }
        if (this.fDescriptionText != null) {
            textActionHandler.addText(this.fDescriptionText);
        }
    }

    private void updateModifiedWidgets() {
        if (this.fModifiedOnLabel == null || this.fModifiedOnLabel.isDisposed()) {
            return;
        }
        this.fModifiedOnLabel.setText(BaselineLabelProvider.getDate(this.fWorkingCopy.getBaselineWrapper().getBaseline().modified()));
    }

    private void updateTagWidgets() {
        if (this.fTagsText == null || this.fTagsText.isDisposed()) {
            return;
        }
        this.fTagsText.setText(this.fWorkingCopy.getTags());
    }

    private void updateDescriptionWidgets() {
        if (this.fDescriptionText == null || this.fDescriptionText.isDisposed()) {
            return;
        }
        this.fDescriptionText.setText(this.fWorkingCopy.getDescription());
    }

    private Control createCustomAttributeSection(Composite parent) {
        FileSystemEditorToolkit toolkit = (FileSystemEditorToolkit)this.getManagedForm().getToolkit();
        this.fCustomAttributeSection = new CustomAttributeSectionForBaselineEditor(this.getOperationRunner(), parent, toolkit, this.fWorkingCopy);
        this.updateCustomAtributeSection(false);
        return this.fCustomAttributeSection.getControl();
    }

    private void updateCustomAtributeSection(final boolean refresh) {
        if (this.fCustomAttributeSection != null) {
            this.getOperationRunner().enqueue(Messages.BaselineEditorOverviewPage_UpdateCustomAttributesSectionJobName, (Operation)new RepositoryOperation(this.fWorkingCopy.getRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    final boolean disableActions = BaselineEditorOverviewPage.this.fCustomAttributeSection.getAssociatedProjectArea(refresh, monitor) == null;
                    DisplayHelper.asyncExec(BaselineEditorOverviewPage.this.fCustomAttributeSection.getControl(), new Runnable(){

                        @Override
                        public void run() {
                            BaselineEditorOverviewPage.this.fCustomAttributeSection.setDisableAllWidgets(disableActions);
                            Label baselineCustomAttributeEnablementMessage = BaselineEditorOverviewPage.this.fCustomAttributeSection.getBaselineComponentOwnedByUserMessage();
                            if (baselineCustomAttributeEnablementMessage != null && !baselineCustomAttributeEnablementMessage.isDisposed()) {
                                baselineCustomAttributeEnablementMessage.setVisible(disableActions);
                                GridData gd = (GridData)baselineCustomAttributeEnablementMessage.getLayoutData();
                                if (gd.exclude == disableActions) {
                                    gd.exclude = !disableActions;
                                    BaselineEditorOverviewPage.this.getManagedForm().reflow(true);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    private Section createBaselineHierarchySection(Composite parent) {
        FileSystemEditorToolkit toolkit = (FileSystemEditorToolkit)this.getManagedForm().getToolkit();
        int sectionStyle = 322;
        Section section = this.createSection(toolkit, parent, sectionStyle, Messages.BaselineEditorOverviewPage_BaselineHierarchySection);
        Composite hierarchyComposite = toolkit.createComposite((Composite)section);
        section.setClient((Control)hierarchyComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(LayoutConstants.getSpacing()).applyTo(hierarchyComposite);
        toolkit.createLabel(hierarchyComposite, Messages.BaselineEditorOverviewPage_BaselineHierarchyLabel);
        this.fHierarchyTreeViewer = new TreeViewer(hierarchyComposite, 2818);
        this.fHierarchyTreeViewer.setContentProvider((IContentProvider)new BaselineHierarchyTreeContentProvider());
        Tree tree = this.fHierarchyTreeViewer.getTree();
        int numRowsToShow = 6;
        GC gc = new GC((Drawable)this.fHierarchyTreeViewer.getTree());
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int height = fm.getHeight() * 6 + 2;
        GridDataFactory.defaultsFor((Control)tree).hint(200, height).grab(true, true).span(1, 1).applyTo((Control)tree);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new BaselinePropertyTreeLabelProvider(), decorator);
        this.fHierarchyTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fHierarchyTreeViewer.setComparator((ViewerComparator)new BaselineHierarchyTreeComparator());
        this.updateBaselineHierarchyWidgets();
        return section;
    }

    private void updateBaselineHierarchyWidgets() {
        if (this.fHierarchyTreeViewer == null || this.fHierarchyTreeViewer.getTree().isDisposed()) {
            return;
        }
        BaselineWrapper wrapper = this.fWorkingCopy.getBaselineWrapper();
        this.fHierarchyTreeViewer.setInput((Object)wrapper.getHierarchyData());
        this.fHierarchyTreeViewer.refresh();
        this.fHierarchyTreeViewer.expandAll();
    }

    public void setFocus() {
        if (this.getLastActivePart() != null) {
            this.getLastActivePart().setFocus();
        } else {
            ScmItemEditorHeader formPart = ((BaselineEditor)this.getEditor()).getEditorHeader();
            formPart.setFocus();
        }
    }

    private void updateEnablement() {
        if (this.fTagsText == null || this.fTagsText.isDisposed()) {
            return;
        }
        boolean isBusy = this.fWorkingCopy.isBusy();
        if (this.fTagsText != null) {
            this.fTagsText.setEnabled(!isBusy);
        }
        if (this.fDescriptionText != null) {
            this.fDescriptionText.setEnabled(!isBusy);
        }
    }

    @Override
    public void dispose() {
        this.fWorkingCopy.removeListener(this.fChangeListener);
        this.fWorkingCopy = null;
        this.fChangeListener = null;
        this.fTextActionHandler.setDeleteAction(null);
        if (this.fCustomAttributeSection != null) {
            this.fCustomAttributeSection.dispose();
            this.fCustomAttributeSection = null;
        }
        this.initialize(null);
        super.dispose();
    }
}

