/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.baseline;

import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IBaseline;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class BaselineEditorInput
implements IEditorInput {
    private BaselineWrapper fBaseline;
    private boolean fIsCreation;

    public static BaselineEditorInput newForEdit(BaselineWrapper baseline) {
        return new BaselineEditorInput(false, baseline);
    }

    private BaselineEditorInput(boolean isCreation, BaselineWrapper baseline) {
        if (!isCreation) {
            Assert.isLegal((baseline != null ? 1 : 0) != 0);
            BaselineWrapper newWrapper = new BaselineWrapper(baseline.getRepository(), baseline.getBaseline(), baseline.getComponent());
            newWrapper.setAllowFolderActions(false);
            this.fBaseline = newWrapper;
        }
        this.fIsCreation = isCreation;
    }

    public ITeamRepository getRepository() {
        return this.fBaseline != null ? this.fBaseline.getRepository() : null;
    }

    public IBaseline getBaseline() {
        return this.fBaseline != null ? this.fBaseline.getBaseline() : null;
    }

    public BaselineWrapper getBaselineWrapper() {
        return this.fBaseline;
    }

    public boolean isCreation() {
        return this.fIsCreation;
    }

    public String getName() {
        if (this.fBaseline != null) {
            return this.fBaseline.getBaseline().getName();
        }
        return Messages.BaselineEditorInput_NewBaseline;
    }

    public String getToolTipText() {
        if (this.fBaseline != null) {
            return this.fBaseline.getBaseline().getName();
        }
        return Messages.BaselineEditorInput_NewBaseline;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImagePool.BASELINE;
    }

    public boolean exists() {
        return true;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.fBaseline != null) {
            result = 31 * result + this.fBaseline.getRepository().getRepositoryURI().hashCode();
            result = 31 * result + this.fBaseline.getComponent().getItemId().hashCode();
            result = 31 * result + this.fBaseline.getBaseline().getItemId().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaselineEditorInput other = (BaselineEditorInput)obj;
        if (this.fBaseline == null ? other.fBaseline != null : other.fBaseline == null) {
            return false;
        }
        if (this.fBaseline != null && other.fBaseline != null) {
            if (!this.fBaseline.getRepository().getRepositoryURI().equals(other.fBaseline.getRepository().getRepositoryURI())) {
                return false;
            }
            if (!this.fBaseline.getComponent().sameItemId((IItemHandle)other.fBaseline.getComponent())) {
                return false;
            }
            if (!this.fBaseline.getBaseline().sameItemId((IItemHandle)other.fBaseline.getBaseline())) {
                return false;
            }
        }
        return true;
    }
}

