/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors.baseline;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorOverviewPage;
import com.ibm.team.filesystem.ide.ui.internal.editors.baseline.BaselineEditorWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.WorkbenchUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.IBaseline;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.progress.IJobRunnable;

public class BaselineEditor
extends ScmItemEditor {
    public static final String ID = "com.ibm.team.filesystem.ide.ui.BaselineEditor";
    private BaselineEditorWorkingCopy fWorkingCopy;
    private BaselineEditorHeader fHeader;
    private BaselineEditorOverviewPage fOverviewPage;
    private Saveable fSaveable;

    public static void open(IWorkbenchPage page, BaselineEditorInput input) {
        try {
            page.openEditor((IEditorInput)input, ID);
        }
        catch (PartInitException e) {
            StatusUtil.log(BaselineEditor.class, (Throwable)e);
        }
    }

    @Override
    protected void createWorkingCopy() {
        if (this.fWorkingCopy == null) {
            this.fWorkingCopy = new BaselineEditorWorkingCopy(this.getEditorInput(), (IOperationRunner)this.getPartSiteJobRunner(), this.getSite().getShell());
            this.fWorkingCopy.addListener(this.getWorkingCopyChangeListener());
            if (this.fWorkingCopy.getBaselineWrapper() != null) {
                this.registerBaselineDeletedListener(this.fWorkingCopy.getBaselineWrapper());
            }
        }
    }

    private void registerBaselineDeletedListener(BaselineWrapper wrapper) {
        ITeamRepository repo = wrapper.getRepository();
        IBaseline baseline = wrapper.getBaseline();
        repo.itemManager().addItemChangeListener((IItem)baseline, this.getScmItemDeletedListener());
    }

    @Override
    public ScmItemWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == BaselineEditorWorkingCopy.class) {
            return this.fWorkingCopy;
        }
        return super.getAdapter(adapter);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        if (this.fHeader == null) {
            this.fHeader = new BaselineEditorHeader((IEditorPart)this, headerForm, this.fWorkingCopy);
            headerForm.addPart((IFormPart)this.fHeader);
        }
    }

    @Override
    public ScmItemEditorHeader getEditorHeader() {
        return this.fHeader;
    }

    protected void addPages() {
        try {
            this.fOverviewPage = new BaselineEditorOverviewPage((FormEditor)this, this.fWorkingCopy, (IOperationRunner)this.getPartSiteJobRunner());
            this.addPage((IFormPage)this.fOverviewPage);
            TextActionHandler textActionHandler = this.getTextActionHandler();
            if (textActionHandler != null) {
                this.fOverviewPage.addTextControls(textActionHandler);
            }
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    @Override
    public String getHelpID() {
        return "com.ibm.team.filesystem.ide.ui.editor_baseline";
    }

    public void setFocus() {
        if (this.fOverviewPage != null) {
            this.fOverviewPage.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Override
    public void updateTitle() {
        String name = "";
        if (this.fWorkingCopy != null) {
            name = this.fWorkingCopy.getMode().isCreation() ? this.fWorkingCopy.getNewBaselineName() : this.fWorkingCopy.getBaselineName();
        }
        this.setPartName(name);
        ResourceManager resourceManager = this.getResourceManager();
        if (resourceManager != null) {
            this.setTitleImage(resourceManager.createImageWithDefault(ImagePool.BASELINE));
        }
    }

    @Override
    public String getItemNotFoundExceptionMessage() {
        if (this.fWorkingCopy != null) {
            return NLS.bind((String)Messages.BaselineEditor_BaselineDeleted, (Object)this.fWorkingCopy.getBaselineName());
        }
        return null;
    }

    @Override
    public String getLicenseNotGrantedExceptionMessage() {
        if (this.fWorkingCopy != null) {
            return NLS.bind((String)Messages.BaselineEditor_MissingRequiredLicense, (Object)this.fWorkingCopy.getBaselineName());
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.fWorkingCopy != null) {
            BaselineWrapper wrapper = this.fWorkingCopy.getBaselineWrapper();
            if (wrapper != null) {
                wrapper.getRepository().itemManager().removeItemChangeListener((IItem)wrapper.getBaseline(), this.getScmItemDeletedListener());
            }
            this.fWorkingCopy.removeListener(this.getWorkingCopyChangeListener());
            this.fWorkingCopy.dispose();
            this.fWorkingCopy = null;
        }
        this.fSaveable = null;
        this.fOverviewPage = null;
        this.fHeader = null;
        super.dispose();
    }

    protected void setInput(IEditorInput input) {
        Assert.isLegal((boolean)(input instanceof BaselineEditorInput));
        super.setInput(input);
    }

    public Saveable[] getSaveables() {
        if (this.fSaveable == null) {
            if (this.fWorkingCopy == null) {
                return new Saveable[0];
            }
            this.fSaveable = new BaselineSaveable(this.fWorkingCopy);
        }
        return new Saveable[]{this.fSaveable};
    }

    private class BaselineSaveable
    extends Saveable {
        private final BaselineEditorWorkingCopy fWorkingCopy;

        private BaselineSaveable(BaselineEditorWorkingCopy workingCopy) {
            Assert.isNotNull((Object)((Object)workingCopy));
            this.fWorkingCopy = workingCopy;
        }

        public BaselineEditorWorkingCopy getWorkingCopy() {
            return this.fWorkingCopy;
        }

        public String getName() {
            String name = null;
            BaselineEditorWorkingCopy wc = this.getWorkingCopy();
            name = wc.getMode().isCreation() ? wc.getNewBaselineName() : wc.getBaselineName();
            if (name == null) {
                name = "";
            }
            return name;
        }

        public String getToolTipText() {
            String toolTip = null;
            BaselineEditorWorkingCopy wc = this.getWorkingCopy();
            toolTip = wc.getMode().isCreation() ? wc.getNewBaselineName() : wc.getToolTipText();
            if (toolTip == null) {
                toolTip = "";
            }
            return toolTip;
        }

        public ImageDescriptor getImageDescriptor() {
            return ImagePool.BASELINE;
        }

        public boolean isDirty() {
            return this.getWorkingCopy().isDirty();
        }

        public void doSave(IProgressMonitor monitor) throws CoreException {
            throw new UnsupportedOperationException();
        }

        public IJobRunnable doSave(IProgressMonitor monitor, IShellProvider shellProvider) throws CoreException {
            BaselineEditor.this.commit(monitor);
            IStatus status = this.fWorkingCopy.validateForSave();
            if (!status.isOK()) {
                BaselineEditor.this.fHeader.setSaveError(NLS.bind((String)Messages.BaselineEditor_ErrorDuringSave, (Object)status.getMessage()));
                this.fWorkingCopy.setShowingSavePermissionError(false);
                monitor.setCanceled(true);
                return null;
            }
            BaselineEditor.this.fHeader.setSaveError(null);
            final Display display = shellProvider.getShell().getDisplay();
            final String baselineName = this.fWorkingCopy.getBaselineName();
            return new IJobRunnable(){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        if (Display.getCurrent() == null) {
                            BaselineSaveable.this.fWorkingCopy.save(monitor);
                        } else {
                            BaselineSaveable.this.fWorkingCopy.saveStarting();
                            WorkbenchUtil.runBackgroundSave((IProgressMonitor)monitor, (Operation)new Operation(){

                                public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                                    try {
                                        BaselineSaveable.this.fWorkingCopy.save(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                                    }
                                }
                            }, (String)NLS.bind((String)Messages.BaselineEditor_SaveBaseline, (Object)baselineName));
                            BaselineSaveable.this.fWorkingCopy.saveDone();
                        }
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (BaselineEditor.this.isDisposed()) {
                                    return;
                                }
                                BaselineSaveable.this.fWorkingCopy.saveSucceeded();
                                BaselineEditor.this.setInput(BaselineEditorInput.newForEdit(BaselineSaveable.this.fWorkingCopy.getBaselineWrapper()));
                            }
                        });
                        if (BaselineSaveable.this.fWorkingCopy.getBaselineWrapper() != null) {
                            BaselineEditor.this.registerBaselineDeletedListener(BaselineSaveable.this.fWorkingCopy.getBaselineWrapper());
                        }
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        final Throwable rootException = e.getStatus().getException();
                        if (rootException instanceof TeamOperationCanceledException) {
                            return Status.OK_STATUS;
                        }
                        if (rootException instanceof PermissionDeniedException) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!BaselineEditor.this.isDisposed()) {
                                        BaselineEditor.this.fHeader.setSaveError(NLS.bind((String)Messages.BaselineEditor_SaveBaseline, (Object)rootException.getMessage()));
                                        BaselineSaveable.this.fWorkingCopy.setShowingSavePermissionError(true);
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                        if (rootException instanceof ItemNotFoundException) {
                            String message = NLS.bind((String)Messages.BaselineEditor_BaselineDeleted, (Object)baselineName);
                            return StatusUtil.newStatus((Object)this, (String)message, (Throwable)new CoreException(StatusUtil.newStatus((Object)this, (String)message, (Throwable)rootException)));
                        }
                        return e.getStatus();
                    }
                    catch (OperationCanceledException e) {
                        return Status.CANCEL_STATUS;
                    }
                }
            };
        }

        public void disableUI(IWorkbenchPart[] parts, boolean closing) {
            this.fWorkingCopy.saveStarting();
            super.disableUI(parts, closing);
        }

        public void enableUI(IWorkbenchPart[] parts) {
            this.fWorkingCopy.saveDone();
            super.enableUI(parts);
        }

        public boolean equals(Object object) {
            if (!(object instanceof BaselineSaveable)) {
                return false;
            }
            BaselineSaveable other = (BaselineSaveable)((Object)object);
            return this.getWorkingCopy() == other.getWorkingCopy();
        }

        public int hashCode() {
            return ((Object)((Object)this.getWorkingCopy())).hashCode();
        }
    }
}

