/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.parts.AbstractSimpleWorkingCopy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;

public abstract class ScmItemWorkingCopy
extends AbstractSimpleWorkingCopy {
    public static final String PROPERTY_BUSY = "busy";
    private Shell fShell;
    private IOperationRunner fRunner;
    private boolean fShowingSavePermissionError = false;
    private boolean fIsBusy;
    private int fBusyCounter = 0;
    private IItemContainerHandle parentFolder;
    private boolean addToRootFolder = false;
    private IAuditable folderOwner;

    public ScmItemWorkingCopy(String name, IOperationRunner runner, Shell shell) {
        super(name);
        this.setOperationRunner(runner);
        this.fShell = shell;
    }

    public IItemContainerHandle getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(IItemContainerHandle parent) {
        this.parentFolder = parent;
    }

    public boolean shouldAddToRootFolder() {
        return this.addToRootFolder;
    }

    public void setShouldAddToRootFolder(boolean shouldAddToRootFolder) {
        this.addToRootFolder = shouldAddToRootFolder;
    }

    public IAuditable getFolderOwner() {
        return this.folderOwner;
    }

    public void setFolderOwner(IAuditable folderOwner) {
        this.folderOwner = folderOwner;
    }

    public abstract void refresh();

    public abstract boolean isCreation();

    public abstract IStatus validateForSave();

    public Shell getShell() {
        return this.fShell;
    }

    public void saveStarting() {
        this.setBusy(true);
    }

    public void saveDone() {
        this.setBusy(false);
    }

    public void saveSucceeded() {
        this.onSaved();
    }

    protected void onSaved() {
    }

    public boolean isBusy() {
        return this.fIsBusy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBusy(boolean busy) {
        boolean toNotify = false;
        String string = PROPERTY_BUSY;
        synchronized (PROPERTY_BUSY) {
            if (busy) {
                this.incrementBusyCounter();
            } else {
                this.decrementBusyCounter();
            }
            if (this.getBusyCounter() > 0) {
                if (!this.fIsBusy) {
                    toNotify = true;
                    this.fIsBusy = true;
                }
            } else if (this.fIsBusy) {
                toNotify = true;
                this.fIsBusy = false;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (toNotify) {
                this.notifyListeners(PROPERTY_BUSY);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBusyCounter() {
        String string = PROPERTY_BUSY;
        synchronized (PROPERTY_BUSY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fBusyCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementBusyCounter() {
        String string = PROPERTY_BUSY;
        synchronized (PROPERTY_BUSY) {
            ++this.fBusyCounter;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementBusyCounter() {
        String string = PROPERTY_BUSY;
        synchronized (PROPERTY_BUSY) {
            --this.fBusyCounter;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized IOperationRunner getOperationRunner() {
        return this.fRunner;
    }

    private synchronized void setOperationRunner(IOperationRunner runner) {
        this.fRunner = runner;
    }

    public boolean isShowingSavePermissionError() {
        return this.fShowingSavePermissionError;
    }

    public void setShowingSavePermissionError(boolean showingSavePermissionError) {
        this.fShowingSavePermissionError = showingSavePermissionError;
    }

    public void dispose() {
        this.setOperationRunner(null);
        super.dispose();
    }

    public abstract class UIOperation<T>
    implements Operation {
        public final void enqueue(IOperationRunner runner, String operationName) {
            if (runner != null) {
                ScmItemWorkingCopy.this.setBusy(true);
                runner.enqueue(operationName, (Operation)this);
            }
        }

        public final void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
            try {
                final T result = this.runInBackground(monitor, problems);
                ScmItemWorkingCopy.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UIOperation.this.updateUI(result);
                        }
                        finally {
                            ScmItemWorkingCopy.this.setBusy(false);
                        }
                    }
                });
            }
            catch (OperationFailedException e) {
                ScmItemWorkingCopy.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScmItemWorkingCopy.this.setBusy(false);
                    }
                });
                throw e;
            }
        }

        protected abstract T runInBackground(IProgressMonitor var1, IStatusCollector var2) throws OperationFailedException;

        protected abstract void updateUI(T var1);
    }
}

