/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.common.IChangeListener;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ScmItemNamePart
extends AbstractFormPart {
    private ScmItemWorkingCopy fWorkingCopy;
    private IChangeListener fWorkingCopyChangeListener;
    private FormToolkit fToolkit;
    private IManagedForm fHeader;
    private Composite fNameBar;
    private Text fNameText;

    public ScmItemNamePart(IManagedForm header, ScmItemWorkingCopy workingCopy) {
        this.fHeader = header;
        this.fWorkingCopy = workingCopy;
        this.fToolkit = header.getToolkit();
    }

    public void createNamePart() {
        Form form = this.fHeader.getForm().getForm();
        this.fNameBar = this.fToolkit.createComposite(form.getHead());
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(1, 1, 0, 4).spacing(LayoutConstants.getSpacing()).applyTo(this.fNameBar);
        this.fNameBar.setBackground(null);
        this.fToolkit.paintBordersFor(this.fNameBar);
        form.setHeadClient((Control)this.fNameBar);
        Label label = this.fToolkit.createLabel(this.fNameBar, Messages.ScmItemNamePart_NameLabel);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        label.setBackground(null);
        this.fNameText = this.fToolkit.createText(this.fNameBar, "");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(1, -1).applyTo((Control)this.fNameText);
        this.fWorkingCopyChangeListener = this.getWorkingCopyChangeListener();
        if (this.fWorkingCopyChangeListener != null) {
            this.fWorkingCopy.addListener(this.fWorkingCopyChangeListener);
        }
        this.onBusyStateChanged(this.fWorkingCopy.isBusy());
        this.onItemNameChanged(this.getCurrentName());
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScmItemNamePart.this.fWorkingCopy.removeListener(ScmItemNamePart.this.fWorkingCopyChangeListener);
                ScmItemNamePart.this.setName(ScmItemNamePart.this.fNameText.getText());
                ScmItemNamePart.this.fWorkingCopy.addListener(ScmItemNamePart.this.fWorkingCopyChangeListener);
            }
        });
        this.fNameText.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                String trimmedName;
                String originalName = ScmItemNamePart.this.fNameText.getText();
                if (!originalName.equals(trimmedName = originalName.trim().replaceAll("\\s+", " "))) {
                    ScmItemNamePart.this.fNameText.setText(trimmedName);
                }
            }
        });
    }

    public abstract String getCurrentName();

    public abstract void setName(String var1);

    public abstract IChangeListener getWorkingCopyChangeListener();

    protected void onBusyStateChanged(boolean busy) {
        if (!this.fNameText.isDisposed()) {
            this.fNameText.setEnabled(!busy);
            if (!busy) {
                this.setFocus();
            }
        }
    }

    protected void onItemNameChanged(String name) {
        if (!this.fNameText.isDisposed()) {
            this.fNameText.setText(name);
        }
    }

    public void setFocus() {
        this.fNameText.setFocus();
    }

    public void dispose() {
        if (this.fWorkingCopy != null && this.fWorkingCopyChangeListener != null) {
            this.fWorkingCopy.removeListener(this.fWorkingCopyChangeListener);
        }
        this.fWorkingCopy = null;
    }

    public void addTextControls(TextActionHandler textActionHandler) {
        textActionHandler.addText(this.fNameText);
    }
}

