/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemNamePart;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ui.actions.TanActions;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.rcp.common.IChangeListener;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ScmItemEditorHeader
extends AbstractFormPart {
    private IEditorPart fEditor;
    private IManagedForm fHeader;
    private ScmItemWorkingCopy fWorkingCopy;
    private ScmItemNamePart fNamePart;
    private LocalResourceManager fLocalResourceManager;
    private IChangeListener fBusyListener;
    private IChangeListener fDirtyListener;
    private Button fSaveButton;
    private Action fRefreshAction;
    private boolean fIsMenuCreated = false;
    private boolean fShowTanRegisteredOpenContextMenuAction = false;
    private boolean fShowTanRegisteredDeleteContextMenuAction = true;
    private boolean fIsDragSupportAdded = false;

    public ScmItemEditorHeader(IEditorPart editor, IManagedForm header, ScmItemWorkingCopy workingCopy, ScmItemNamePart namePart) {
        this.fEditor = editor;
        this.fHeader = header;
        this.fWorkingCopy = workingCopy;
        this.fNamePart = namePart;
        this.fLocalResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)header.getForm().getForm().getHead());
    }

    public void createEditorHeader() {
        FormToolkit toolkit = this.fHeader.getToolkit();
        toolkit.decorateFormHeading(this.fHeader.getForm().getForm());
        this.fBusyListener = this.getBusyListener();
        if (this.fBusyListener != null) {
            this.fWorkingCopy.addListener(this.fBusyListener);
        }
        this.updateTitle();
        ScmItemNamePart namePart = this.getNamePart();
        if (namePart != null) {
            this.fHeader.addPart((IFormPart)this.getNamePart());
        }
        this.createToolbar();
        this.addDragSupportIfNeeded();
        this.createMenuIfNeeded();
        this.onBusyStateChanged();
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    public IManagedForm getHeader() {
        return this.fHeader;
    }

    public ScmItemWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public ScmItemNamePart getNamePart() {
        return this.fNamePart;
    }

    public abstract String getTitleText();

    public abstract ImageDescriptor getTitleImageDescriptor();

    protected void updateTitle() {
        ImageDescriptor image;
        String title = this.getTitleText();
        if (title != null) {
            this.fHeader.getForm().setText(title);
        }
        if ((image = this.getTitleImageDescriptor()) != null) {
            this.fHeader.getForm().setImage(JazzResources.getImageWithDefault((ResourceManager)this.fLocalResourceManager, (ImageDescriptor)image));
        }
    }

    public abstract boolean isMenuNeeded();

    public boolean isMenuCreated() {
        return this.fIsMenuCreated;
    }

    private void createMenuIfNeeded() {
        if (this.isMenuNeeded()) {
            this.createContextMenu(this.fHeader.getForm().getForm());
            this.fHeader.getForm().reflow(true);
            this.fIsMenuCreated = true;
        }
    }

    public boolean isShowTanRegisteredOpenContextMenuAction() {
        return this.fShowTanRegisteredOpenContextMenuAction;
    }

    public void setShowTanRegisteredOpenContextMenuAction(boolean show) {
        this.fShowTanRegisteredOpenContextMenuAction = show;
    }

    public boolean isShowTanRegisteredDeleteContextMenuAction() {
        return this.fShowTanRegisteredDeleteContextMenuAction;
    }

    public void setShowTanRegisteredDeleteContextMenuAction(boolean show) {
        this.fShowTanRegisteredDeleteContextMenuAction = show;
    }

    public abstract ISelectionProvider getMenuSelectionProvider();

    private void createContextMenu(Form form) {
        ISelectionProvider selectionProvider;
        final IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
                ISelectionProvider selectionProvider = ScmItemEditorHeader.this.getMenuSelectionProvider();
                if (selectionProvider != null) {
                    ArrayList<String> actions = new ArrayList<String>();
                    if (ScmItemEditorHeader.this.isShowTanRegisteredOpenContextMenuAction()) {
                        actions.add("jazz.open");
                    }
                    if (ScmItemEditorHeader.this.isShowTanRegisteredDeleteContextMenuAction()) {
                        actions.add(IMenuOperationTarget.DELETE);
                    }
                    if (actions.size() > 0) {
                        TanActions.addTanActions(null, menuMgr, (IWorkbenchSite)ScmItemEditorHeader.this.fEditor.getSite(), selectionProvider, actions.toArray(new String[actions.size()]));
                    }
                }
            }
        });
        if (menuMgr instanceof MenuManager && (selectionProvider = this.getMenuSelectionProvider()) != null) {
            this.fEditor.getSite().registerContextMenu(this.fEditor.getSite().getId(), (MenuManager)menuMgr, selectionProvider);
        }
    }

    public abstract boolean isDragSupportNeeded();

    private void addDragSupportIfNeeded() {
        if (this.isDragSupportNeeded()) {
            this.addDragSupport();
            this.fIsDragSupportAdded = true;
        }
    }

    public boolean isDragSupportAdded() {
        return this.fIsDragSupportAdded;
    }

    public abstract Object getDragObject();

    private void addDragSupport() {
        DragSourceAdapter dragSourcelistener = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                Object element = ScmItemEditorHeader.this.getDragObject();
                if (element == null) {
                    event.doit = false;
                } else {
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection(element));
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        };
        this.fHeader.getForm().getForm().addTitleDragSupport(21, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)dragSourcelistener);
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.fHeader.getForm().getToolBarManager();
        this.fRefreshAction = new Action(Messages.ScmEditorHeader_RefreshActionText, 1){

            public void runWithEvent(Event event) {
                if (ScmItemEditorHeader.this.fWorkingCopy.isDirty()) {
                    String title = Messages.ScmEditorHeader_DiscardTitle;
                    String message = Messages.ScmEditorHeader_DiscardMsg;
                    if (!DialogUtil.openConfirm(ScmItemEditorHeader.this.fEditor.getSite().getShell(), title, message, 4, false)) {
                        return;
                    }
                }
                ScmItemEditorHeader.this.fWorkingCopy.refresh();
            }
        };
        this.fRefreshAction.setImageDescriptor(ImagePool.REFRESH_ICON);
        this.fRefreshAction.setToolTipText(Messages.ScmEditorHeader_RefreshToolTip);
        toolbarManager.add((IAction)this.fRefreshAction);
        this.fEditor.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshAction);
        ControlContribution saveAction = new ControlContribution("save"){

            protected Control createControl(Composite parent) {
                ScmItemEditorHeader.this.fSaveButton = ScmItemEditorHeader.this.fHeader.getToolkit().createButton(parent, Messages.ScmEditorHeader_SaveButtonText, 8);
                ScmItemEditorHeader.this.fSaveButton.setBackground(null);
                ScmItemEditorHeader.this.fSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ScmItemEditorHeader.this.fEditor.getSite().getPage().saveEditor(ScmItemEditorHeader.this.fEditor, false);
                    }
                });
                ScmItemEditorHeader.this.fSaveButton.setEnabled(ScmItemEditorHeader.this.fWorkingCopy.isDirty());
                return ScmItemEditorHeader.this.fSaveButton;
            }
        };
        toolbarManager.add((IContributionItem)saveAction);
        this.fDirtyListener = this.getDirtyListener();
        if (this.fDirtyListener != null) {
            this.fWorkingCopy.addListener(this.fDirtyListener);
        }
        this.addButtons(toolbarManager);
        toolbarManager.update(false);
    }

    public IChangeListener getBusyListener() {
        return new IChangeListener(){

            public void changed(Object source, Object property) {
                if (property == "busy") {
                    ScmItemEditorHeader.this.onBusyStateChanged();
                }
            }
        };
    }

    public abstract IChangeListener getDirtyListener();

    public void addButtons(IToolBarManager toolbarManager) {
    }

    public void updateEnablement() {
        boolean dirty = this.fWorkingCopy.isDirty();
        boolean busy = this.fWorkingCopy.isBusy();
        this.fSaveButton.setEnabled(dirty && !busy);
        this.fRefreshAction.setEnabled(!this.fWorkingCopy.isCreation() && !busy);
    }

    public void onDirtyStateChanged() {
        if (!this.fHeader.getForm().isDisposed()) {
            this.updateEnablement();
        }
    }

    public void onBusyStateChanged() {
        if (!this.fHeader.getForm().isDisposed()) {
            boolean busy = this.fWorkingCopy.isBusy();
            this.fHeader.getForm().setBusy(busy);
            if (!busy) {
                this.addDragSupportIfNeeded();
                this.createMenuIfNeeded();
            }
            this.updateEnablement();
        }
    }

    public void setSaveError(String messageText) {
        if (messageText == null) {
            this.fHeader.getMessageManager().removeMessage((Object)ERROR_CLASS.SAVE);
        } else {
            this.fHeader.getMessageManager().addMessage((Object)ERROR_CLASS.SAVE, messageText, null, 3);
        }
    }

    public void dispose() {
        if (this.fBusyListener != null) {
            this.fWorkingCopy.removeListener(this.fBusyListener);
        }
        if (this.fDirtyListener != null) {
            this.fWorkingCopy.removeListener(this.fDirtyListener);
        }
    }

    public void setFocus() {
        ScmItemNamePart namePart = this.getNamePart();
        if (namePart != null) {
            namePart.setFocus();
        }
    }

    public void addTextControls(TextActionHandler textActionHandler) {
        this.fNamePart.addTextControls(textActionHandler);
    }

    protected void removeUnwantedMenus(IMenuManager manager, String[] idsToRemove) {
        String[] stringArray = idsToRemove;
        int n = idsToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            String actionId = stringArray[n2];
            manager.remove(actionId);
            ++n2;
        }
        stringArray = manager.getItems();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            if (o instanceof IMenuManager) {
                IMenuManager childMenu = (IMenuManager)o;
                String[] stringArray2 = idsToRemove;
                int n3 = idsToRemove.length;
                int n4 = 0;
                while (n4 < n3) {
                    String actionId = stringArray2[n4];
                    childMenu.remove(actionId);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static enum ERROR_CLASS {
        SAVE;

    }
}

