/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.ui.editor.TeamFormEditor;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ScmItemEditor
extends TeamFormEditor
implements ISaveablesSource {
    private TextActionHandler fTextActionHandler;
    private ResourceManager fResourceManager;
    private PartSiteJobRunner fPartSiteJobRunner;
    private IChangeListener fWorkingCopyChangeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == ScmItemWorkingCopy.PROP_DIRTY) {
                ScmItemEditor.this.firePropertyChange(257);
            }
            ScmItemEditor.this.removeSaveErrorIfValid();
            ScmItemEditor.this.updateTitle();
        }
    };
    private ISharedItemChangeListener fScmItemDeletedListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (Object changeEvent : events) {
                ISharedItemChangeEvent event;
                if (!(changeEvent instanceof ISharedItemChangeEvent) || (event = (ISharedItemChangeEvent)changeEvent).getAfterState() != null || ScmItemEditor.this.getSite().getWorkbenchWindow().getActivePage() == null) continue;
                ScmItemEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScmItemEditor.this.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)ScmItemEditor.this, false);
                    }
                });
            }
        }
    };

    protected abstract void createWorkingCopy();

    public abstract ScmItemWorkingCopy getWorkingCopy();

    public abstract ScmItemEditorHeader getEditorHeader();

    public abstract String getHelpID();

    public abstract void updateTitle();

    public abstract String getItemNotFoundExceptionMessage();

    public abstract String getLicenseNotGrantedExceptionMessage();

    protected Composite createPageContainer(final Composite parent) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        final Display display = parent.getDisplay();
        this.fPartSiteJobRunner = new PartSiteJobRunner(this.getSite(), false){

            protected boolean reportProblem(final String opName, Operation op, final IStatus reason) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!parent.isDisposed()) {
                            String message;
                            IStatus adjustedReason = reason;
                            if (reason.getException() instanceof ItemNotFoundException && (message = ScmItemEditor.this.getItemNotFoundExceptionMessage()) != null) {
                                adjustedReason = StatusUtil.newStatus((Object)this, (String)message, (Throwable)new CoreException(StatusUtil.newStatus((Object)this, (String)message, (Throwable)reason.getException())));
                            }
                            if (reason.getException() instanceof LicenseNotGrantedException && (message = ScmItemEditor.this.getLicenseNotGrantedExceptionMessage()) != null) {
                                adjustedReason = StatusUtil.newStatus((Object)this, (String)message, (Throwable)new CoreException(StatusUtil.newStatus((Object)this, (String)message, (Throwable)reason.getException())));
                            }
                            ErrorDialog.openError((Shell)ScmItemEditor.this.getSite().getShell(), (String)NLS.bind((String)Messages.ScmItemEditor_ErrorDuringMessage, (Object)opName), null, (IStatus)adjustedReason);
                        }
                    }
                });
                return false;
            }
        };
        this.createWorkingCopy();
        this.updateTitle();
        String helpID = this.getHelpID();
        if (helpID != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, helpID);
        }
        return super.createPageContainer(parent);
    }

    protected FormToolkit createToolkit(Display display) {
        return new FileSystemEditorToolkit(UiPlugin.getDefault().getSharedFormColors(display));
    }

    protected void createPages() {
        if (this.getContainer() instanceof CTabFolder) {
            CTabFolder tabFolder = (CTabFolder)this.getContainer();
            tabFolder.setTabHeight(0);
        }
        super.createPages();
        this.fTextActionHandler = new TextActionHandler(this.getEditorSite().getActionBars());
        this.getEditorHeader().addTextControls(this.fTextActionHandler);
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.getWorkingCopy() != null && this.getWorkingCopy().isDirty() || super.isDirty();
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public void dispose() {
        this.fTextActionHandler = null;
        this.fResourceManager = null;
        this.fPartSiteJobRunner.dispose();
        this.fPartSiteJobRunner = null;
        this.fWorkingCopyChangeListener = null;
        this.fScmItemDeletedListener = null;
    }

    protected boolean isDisposed() {
        return this.getWorkingCopy() == null;
    }

    protected TextActionHandler getTextActionHandler() {
        return this.fTextActionHandler;
    }

    protected ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    protected PartSiteJobRunner getPartSiteJobRunner() {
        return this.fPartSiteJobRunner;
    }

    protected IChangeListener getWorkingCopyChangeListener() {
        return this.fWorkingCopyChangeListener;
    }

    protected ISharedItemChangeListener getScmItemDeletedListener() {
        return this.fScmItemDeletedListener;
    }

    protected void commit(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    private void removeSaveErrorIfValid() {
        IStatus status;
        ScmItemWorkingCopy workingCopy = this.getWorkingCopy();
        ScmItemEditorHeader header = this.getEditorHeader();
        if (workingCopy != null && header != null && !workingCopy.isShowingSavePermissionError() && (status = workingCopy.validateForSave()) != null && status.isOK()) {
            header.setSaveError(null);
        }
    }
}

