/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors;

import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class OwnerOrCreatorControl
extends Composite {
    private Label missingLabel;
    private StandardControlLabelProvider labelProvider;

    public OwnerOrCreatorControl(IWorkbenchPartSite site, FileSystemEditorToolkit toolkit, Composite parent, String id) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.missingLabel = new Label((Composite)this, 0);
        this.missingLabel.setText(Messages.TeamPlaceOverviewPage_ownerNone);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.missingLabel);
        this.labelProvider = toolkit.createDecoratedImageHyperlink(this, site, String.valueOf(site.getId()) + "." + id);
        GridDataFactory.fillDefaults().minSize(100, 0).align(4, 0x1000000).grab(true, true).applyTo(this.labelProvider.getControl());
    }

    public void setOwner(IItem item, boolean isInaccessible) {
        this.labelProvider.setTextAware(item != null);
        this.labelProvider.setElement((Object)item);
        Control labelControl = this.labelProvider.getControl();
        if (labelControl instanceof ImageHyperlink) {
            final String ownerText = ((ImageHyperlink)labelControl).getText();
            this.labelProvider.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = NLS.bind((String)Messages.TeamPlaceOverviewPage_creatorAccessibleLabel, (Object)ownerText);
                }
            });
        }
        if (item == null) {
            if (isInaccessible) {
                this.missingLabel.setText(Messages.TeamPlaceOverviewPage_ownerInaccessible);
            } else {
                this.missingLabel.setText(Messages.TeamPlaceOverviewPage_ownerNone);
            }
        } else if (item instanceof ITeamArea) {
            this.labelProvider.setTextAware(false);
        } else if (item instanceof IWorkspace) {
            this.labelProvider.setElement((Object)AbstractPlaceWrapper.newWrapper((IWorkspace)item));
        }
        boolean hasOwner = item != null;
        Label c1 = this.missingLabel;
        Control c2 = this.labelProvider.getControl();
        c1.setVisible(!hasOwner);
        c2.setVisible(hasOwner);
        ((GridData)c1.getLayoutData()).exclude = hasOwner;
        ((GridData)c2.getLayoutData()).exclude = !hasOwner;
        this.layout();
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.labelProvider.getControl().getEnabled()) {
            this.labelProvider.getControl().setEnabled(enabled);
        }
    }
}

