/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editors;

import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.scm.common.IComponent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ComponentControl
extends Composite {
    private Label unknownLabel;
    private StandardControlLabelProvider labelProvider;

    public ComponentControl(IWorkbenchPartSite site, FileSystemEditorToolkit toolkit, Composite parent, String id) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.unknownLabel = new Label((Composite)this, 0);
        this.unknownLabel.setText(Messages.ComponentControl_UnknownLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.unknownLabel);
        this.labelProvider = toolkit.createDecoratedImageHyperlink(this, site, String.valueOf(site.getId()) + "." + id);
        GridDataFactory.fillDefaults().minSize(100, 0).align(4, 0x1000000).grab(true, true).applyTo(this.labelProvider.getControl());
    }

    public void setComponent(IComponent component, boolean isInaccessible) {
        this.labelProvider.setTextAware(component != null);
        this.labelProvider.setElement((Object)component);
        Control labelControl = this.labelProvider.getControl();
        if (labelControl instanceof ImageHyperlink) {
            final String componentText = ((ImageHyperlink)labelControl).getText();
            this.labelProvider.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = NLS.bind((String)Messages.ComponentControl_ComponentLabel, (Object)componentText);
                }
            });
        }
        if (component == null) {
            if (isInaccessible) {
                this.unknownLabel.setText(Messages.ComponentControl_InaccessibleLabel);
            } else {
                this.unknownLabel.setText(Messages.ComponentControl_UnknownLabel);
            }
        }
        boolean hasComponent = component != null;
        Label c1 = this.unknownLabel;
        Control c2 = this.labelProvider.getControl();
        c1.setVisible(!hasComponent);
        c2.setVisible(hasComponent);
        ((GridData)c1.getLayoutData()).exclude = hasComponent;
        ((GridData)c2.getLayoutData()).exclude = !hasComponent;
        this.layout();
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.labelProvider.getControl().getEnabled()) {
            this.labelProvider.getControl().setEnabled(enabled);
        }
    }
}

