/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editorfactory;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.ui.editor.EditorTuple;
import com.ibm.team.filesystem.ui.editor.ISandboxEditorInputSource;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class SandboxEditorInputFactory {
    private static final Object lock = new Object();
    private static SandboxEditorInputFactory instance;
    private HashMap<String, ISandboxEditorInputSource> factories = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SandboxEditorInputFactory getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new SandboxEditorInputFactory();
                IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.ide.ui", "sandboxEditorInputSource");
                SandboxEditorInputFactory.instance.factories = new HashMap(configs.length);
                IConfigurationElement[] iConfigurationElementArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    try {
                        ISandboxEditorInputSource editor = (ISandboxEditorInputSource)element.createExecutableExtension("factory");
                        String storageId = element.getAttribute("storageId");
                        SandboxEditorInputFactory.instance.factories.put(storageId, editor);
                    }
                    catch (CoreException ex) {
                        StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)ex);
                    }
                    ++n2;
                }
            }
        }
        return instance;
    }

    public EditorTuple createEditorInput(Shell shell, IWorkbenchPage page, IShareable shareable) {
        String storageId = this.findStorageIdFor(shareable);
        ISandboxEditorInputSource factory = this.factories.get(storageId);
        if (factory == null) {
            throw new RuntimeException("unknown storageId: " + storageId);
        }
        return factory.createEditorInput(shell, page, shareable);
    }

    private String findStorageIdFor(IShareable shareable) {
        return shareable.getFullPath().getStorageId();
    }
}

