/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.editorfactory;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.ui.editor.EditorTuple;
import com.ibm.team.filesystem.ui.editor.ISandboxEditorInputSource;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class ResourceSandboxEditorInputSource
implements ISandboxEditorInputSource {
    @Override
    public EditorTuple createEditorInput(Shell shell, IWorkbenchPage page, IShareable shareable) {
        try {
            if (!shareable.exists((IProgressMonitor)TempHelper.MONITOR)) {
                MessageDialog.openWarning((Shell)shell, (String)Messages.ResourceSandboxFileFactory_0, (String)Messages.ResourceSandboxFileFactory_1);
                return null;
            }
        }
        catch (FileSystemException e) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.ResourceSandboxFileFactory_2, (String)e.getMessage());
        }
        Object adapter = shareable.getAdapter(IResource.class);
        EditorTuple tuple = null;
        if (adapter instanceof IResource) {
            IResource resource = (IResource)adapter;
            if (!resource.exists()) {
                ResourceSandboxEditorInputSource.resourceDoesNotExistWarning(shell, resource);
                return null;
            }
            if (!(resource instanceof IFile)) {
                ResourceSandboxEditorInputSource.promptWithFolderMessage(shell);
                return null;
            }
            IFile file = (IFile)resource;
            try {
                tuple = new EditorTuple((IEditorInput)new FileEditorInput(file), IDE.getEditorDescriptor((IFile)file).getId());
            }
            catch (PartInitException e) {
                tuple = null;
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e);
                MessageDialog.openWarning((Shell)shell, (String)Messages.ResourceSandboxEditorInputSource_COULD_NOT_OPEN_EDITOR_TITLE, (String)NLS.bind((String)Messages.ResourceSandboxEditorInputSource_COULD_NOT_OPEN_EDITOR_DIALOG_TEXT, (Object)shareable.getFullPath().getName()));
            }
        } else {
            URI uri = URIUtil.toURI((IPath)((IPath)shareable.getFullPath().getAdapter(IPath.class)));
            try {
                IFileStore store = EFS.getStore((URI)uri);
                tuple = new EditorTuple((IEditorInput)new FileStoreEditorInput(store), IDE.getEditorDescriptor((String)shareable.getLocalPath().getName()).getId());
            }
            catch (PartInitException e) {
                tuple = null;
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e);
                MessageDialog.openWarning((Shell)shell, (String)Messages.ResourceSandboxEditorInputSource_COULD_NOT_OPEN_EDITOR_TITLE, (String)NLS.bind((String)Messages.ResourceSandboxEditorInputSource_COULD_NOT_OPEN_EDITOR_DIALOG_TEXT, (Object)shareable.getFullPath().getName()));
                return null;
            }
            catch (CoreException e) {
                tuple = null;
                StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e);
                MessageDialog.openWarning((Shell)shell, (String)Messages.ResourceSandboxEditorInputSource_COULD_NOT_OPEN_EDITOR_TITLE, (String)NLS.bind((String)Messages.ResourceSandboxEditorInputSource_COULD_NOT_OPEN_EDITOR_DIALOG_TEXT, (Object)shareable.getFullPath().getName()));
                return null;
            }
        }
        return tuple;
    }

    protected static String findEditorId(IShareable shareable) {
        String editorId = null;
        try {
            IEditorDescriptor desc = IDE.getEditorDescriptor((String)shareable.getLocalPath().getName());
            if (desc != null) {
                editorId = desc.getId();
            }
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e);
        }
        if (editorId == null) {
            editorId = "org.eclipse.ui.DefaultTextEditor";
        }
        return editorId;
    }

    private static void promptWithFolderMessage(Shell shell) {
        MessageDialog.openWarning((Shell)shell, (String)Messages.ResourceSandboxFileFactory_3, (String)Messages.ResourceSandboxFileFactory_4);
    }

    private static void resourceDoesNotExistWarning(Shell shell, IResource resource) {
        MessageDialog.openWarning((Shell)shell, (String)Messages.ResourceSandboxFileFactory_5, (String)NLS.bind((String)Messages.ResourceSandboxFileFactory_6, (Object)resource.getLocation().toOSString()));
    }
}

