/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs.lock;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockEntryDetail;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockEntryToLockEntryDetailQuery;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteriaPart;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.UnionSet;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LockPreventsDeliverDialog
extends DetailsDialog {
    private Map<IStreamLockReport, IWorkspaceConnection> input;
    private String detailsTitleMsg;

    public LockPreventsDeliverDialog(Shell parentShell, String dialogTitle, String message, String detailsTitleMsg, int style, Map<IStreamLockReport, IWorkspaceConnection> input, DetailsDialog.ButtonBar buttonBar) {
        super(parentShell, dialogTitle, message, style, buttonBar);
        this.setDefaultButtonId(1);
        this.setHelpAvailable(false);
        this.input = input;
        this.detailsTitleMsg = detailsTitleMsg;
    }

    @Override
    protected Composite createDropDownDialogArea(Composite parent) {
        LockEntryToLockOwner set;
        Composite composite = new Composite(parent, 0);
        Label label = new Label(composite, 0);
        label.setText(this.detailsTitleMsg);
        List<LockEntry> locks = LockPreventsDeliverDialog.createEntries(this.input);
        JobRunner operationRunner = new JobRunner(true);
        Map<ITeamRepository, List<LockEntry>> lockEntriesBatchedByRepo = LockEntry.getLockEntriesBatchedByRepo(locks);
        if (lockEntriesBatchedByRepo.size() == 1) {
            set = new LockEntryToLockOwner(lockEntriesBatchedByRepo.keySet().iterator().next(), (IOperationRunner)operationRunner, locks);
        } else {
            UnionSet unionSet = new UnionSet();
            for (Map.Entry<ITeamRepository, List<LockEntry>> entry : lockEntriesBatchedByRepo.entrySet()) {
                new LockEntryToLockOwner(entry.getKey(), (IOperationRunner)operationRunner, (Collection<LockEntry>)entry.getValue());
            }
            set = unionSet;
        }
        SimpleTreeViewer viewer = new SimpleTreeViewer(composite, (ITreeProvider)new LockTreeProvider((IOperationRunner)operationRunner, (ISetWithListeners)set), 2816);
        MixedTypeLabelProvider labelProvider = new MixedTypeLabelProvider();
        labelProvider.put(LockOwner.class, (IViewerLabelProvider)new ConvertingLabelProvider(LabelProviders.create((ISetWithListeners)set), (IDynamicFunction)new IDynamicFunction<LockOwner, ContributorWrapper>(){

            public void addListener(IChangeListener l) {
            }

            public ContributorWrapper computeResult(LockOwner input) {
                return input.getContributor();
            }

            public ISetWithListeners<ContributorWrapper> getRange() {
                return null;
            }

            public void removeListener(IChangeListener l) {
            }

            public Collection<LockOwner> getKeysFor(ContributorWrapper value) {
                return null;
            }
        }));
        labelProvider.put(LockEntryDetail.class, (IViewerLabelProvider)new LockEntryLabelProvider());
        viewer.setLabelProvider((IViewerLabelProvider)labelProvider);
        viewer.setSorter(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof LockOwner) {
                    LockOwner owner1 = (LockOwner)o1;
                    if (o2 instanceof LockOwner) {
                        LockOwner owner2 = (LockOwner)o2;
                        String name1 = owner1.getContributor().getContributor().getName();
                        String name2 = owner2.getContributor().getContributor().getName();
                        return name1.compareTo(name2);
                    }
                } else if (o1 instanceof LockEntryDetail) {
                    LockEntryDetail l1 = (LockEntryDetail)o1;
                    if (o2 instanceof LockEntryDetail) {
                        String componentName2;
                        String streamName2;
                        LockEntryDetail l2 = (LockEntryDetail)o2;
                        String streamName1 = l1.getWorkspaceComponent().getWorkspace().getName();
                        int compare = streamName1.compareTo(streamName2 = l2.getWorkspaceComponent().getWorkspace().getName());
                        if (compare != 0) {
                            return compare;
                        }
                        String componentName1 = l1.getWorkspaceComponent().getComponent().getName();
                        compare = componentName1.compareTo(componentName2 = l2.getWorkspaceComponent().getComponent().getName());
                        if (compare != 0) {
                            return compare;
                        }
                        String fileName1 = l1.getFileSystemItem().getFQName();
                        String fileName2 = l2.getFileSystemItem().getFQName();
                        return fileName1.compareTo(fileName2);
                    }
                }
                return 0;
            }
        });
        viewer.setInput(locks);
        viewer.expandAll();
        LockPreventsDeliverDialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        return composite;
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.team.filesystem.ide.ui.dialog_lockpreventsdelivery";
    }

    private static List<LockEntry> createEntries(Map<IStreamLockReport, IWorkspaceConnection> locks) {
        ArrayList<LockEntry> lockEntries = new ArrayList<LockEntry>();
        for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
            IStreamLockReport report = entry.getKey();
            IWorkspaceConnection workspaceConnecion = entry.getValue();
            ITeamRepository repository = workspaceConnecion.teamRepository();
            ArrayList<IWorkspaceHandle> workspaceHandles = new ArrayList<IWorkspaceHandle>();
            ArrayList<SiloedItemId<IVersionable>> versionableHandles = new ArrayList<SiloedItemId<IVersionable>>();
            workspaceHandles.add(report.getStream());
            for (IComponentLockReport componentLockReport : report.getComponentLocks()) {
                IComponentHandle componentHandle = componentLockReport.getComponent();
                for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                    versionableHandles.add((SiloedItemId<IVersionable>)SiloedItemId.create((IVersionableHandle)versionableLock.getVersionable(), (IComponentHandle)componentHandle));
                }
            }
            LockSearchCriteria lockSearchCriteria = new LockSearchCriteria(repository, workspaceHandles, null, null, versionableHandles, LockSearchCriteriaPart.getLockSearchMaxResults());
            List<LockEntry> entries = LockEntry.createEntries(Realm.getDefault(), lockSearchCriteria, repository, report);
            lockEntries.addAll(entries);
        }
        return lockEntries;
    }

    private static class LockEntryLabelProvider
    extends BaseLabelProvider {
        private LockEntryLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            LockEntryDetail entry = (LockEntryDetail)element;
            AbstractFileSystemItemWrapper fileItemWrapper = entry.getFileSystemItem();
            if (fileItemWrapper instanceof FileItemWrapper) {
                FileItemWrapper wrapper = (FileItemWrapper)fileItemWrapper;
                label.setImage(this.getImage(UiPlugin.getFileSystemImageDescriptor(wrapper.getName())));
            } else if (fileItemWrapper instanceof FolderItemWrapper) {
                label.setImage(this.getImage(UiPlugin.getFileSystemImageDescriptor(null)));
            }
            label.setText(NLS.bind((String)Messages.LockPreventsDeliverDialog_2, (Object[])new String[]{fileItemWrapper.getName(), entry.getWorkspaceComponent().getWorkspace().getName(), entry.getWorkspaceComponent().getComponent().getName()}));
        }
    }

    private static class LockEntryToLockOwner
    extends RepositoryQuery<LockOwner> {
        private Collection<LockEntry> lockEntries;

        public LockEntryToLockOwner(ITeamRepository repository, IOperationRunner runner, Collection<LockEntry> lockEntries) {
            super(repository, runner);
            this.lockEntries = lockEntries;
        }

        protected void attachListeners() {
        }

        protected void detachListeners() {
        }

        protected List<LockOwner> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
            HashMap<UUID, ItemLocator> locators = new HashMap<UUID, ItemLocator>();
            for (LockEntry entry : this.lockEntries) {
                IContributorHandle iContributorHandle = entry.getContributor();
                UUID uuid = iContributorHandle.getItemId();
                locators.put(uuid, new ItemLocator(entry.getRepository(), (IAuditableHandle)iContributorHandle));
            }
            Map fetched = ItemFetcher.fetchCurrents(locators.values(), (boolean)false, (IProgressMonitor)monitor);
            HashMap<UUID, IContributor> contributors = new HashMap<UUID, IContributor>();
            for (Map.Entry entry : fetched.entrySet()) {
                IContributor contributor = (IContributor)entry.getValue();
                if (contributor == null) {
                    StatusUtil.log((IStatus)FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.LockPreventsDeliverDialog_1, (Object)((ItemLocator)entry.getKey()).getItemId())));
                    continue;
                }
                contributors.put(contributor.getItemId(), contributor);
            }
            HashMap<UUID, LockOwner> hashMap = new HashMap<UUID, LockOwner>();
            for (LockEntry entry : this.lockEntries) {
                IContributorHandle contributorHandle = entry.getContributor();
                UUID uuid = contributorHandle.getItemId();
                LockOwner owner = (LockOwner)hashMap.get(uuid);
                if (owner == null) {
                    IContributor contributor = (IContributor)contributors.get(uuid);
                    owner = new LockOwner(new ContributorWrapper(contributor));
                    hashMap.put(uuid, owner);
                }
                owner.getLocks().add(entry);
            }
            return new ArrayList<LockOwner>(hashMap.values());
        }

        public String getName() {
            return Messages.LockPreventsDeliverDialog_0;
        }
    }

    private static class LockOwner {
        private ContributorWrapper contributorWrapper;
        private List<LockEntry> locks;

        public LockOwner(ContributorWrapper contributorWrapper) {
            this.contributorWrapper = contributorWrapper;
            this.locks = new ArrayList<LockEntry>();
        }

        public ContributorWrapper getContributor() {
            return this.contributorWrapper;
        }

        public List<LockEntry> getLocks() {
            return this.locks;
        }
    }

    private static class LockTreeProvider
    implements ITreeProvider {
        private IOperationRunner operationRunner;
        private ISetWithListeners owners;

        public LockTreeProvider(IOperationRunner operationRunner, ISetWithListeners owners) {
            this.operationRunner = operationRunner;
            this.owners = owners;
        }

        public ISetWithListeners getChildren(Object element) {
            if (element instanceof List) {
                return this.owners;
            }
            if (element instanceof LockOwner) {
                LockOwner lockOwner = (LockOwner)element;
                return new LockEntryToLockEntryDetailQuery(lockOwner.getContributor().getRepository(), this.operationRunner, lockOwner.getLocks());
            }
            return null;
        }
    }
}

