/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs.lock;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ScmTreeDialogPart;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.ScmTreeDialogViewer;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockDialogInput;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockDialogResult;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public class LockDialogPart
extends ScmTreeDialogPart {
    private StreamsList streamsList;

    public LockDialogPart(Composite parent, LockDialogInput input) {
        super(parent, input);
    }

    @Override
    protected StreamsList createDialogViewer(Composite composite, Object dlgInput) {
        LockDialogInput input = (LockDialogInput)dlgInput;
        this.streamsList = new StreamsList(composite, input);
        return this.streamsList;
    }

    @Override
    public LockDialogResult getResult() {
        List<String> resultPatterns = null;
        LockDialogResult.LockAction resultAction = LockDialogResult.LockAction.LOCK_NOW;
        LockDialogResult result = new LockDialogResult(resultAction, this.streamsList.getResult(), resultPatterns);
        return result;
    }

    private static class Collaboration {
        private final IWorkspaceConnection connection;
        private final boolean isCurrentIncoming;
        private final boolean isCurrentOutgoing;
        private final boolean isDefaultIncoming;
        private final boolean isDefaultOutgoing;

        public Collaboration(IWorkspaceConnection connection, boolean isCurrentIncoming, boolean isCurrentOutgoing, boolean isDefaultIncoming, boolean isDefaultOutgoing) {
            this.connection = connection;
            this.isCurrentIncoming = isCurrentIncoming;
            this.isCurrentOutgoing = isCurrentOutgoing;
            this.isDefaultIncoming = isDefaultIncoming;
            this.isDefaultOutgoing = isDefaultOutgoing;
        }

        public IWorkspaceConnection getWorkspaceConnection() {
            return this.connection;
        }

        public boolean isCurrentIncoming() {
            return this.isCurrentIncoming;
        }

        public boolean isCurrentOutgoing() {
            return this.isCurrentOutgoing;
        }

        public boolean isDefaultIncoming() {
            return this.isDefaultIncoming;
        }

        public boolean isDefaultOutgoing() {
            return this.isDefaultOutgoing;
        }

        public String toString() {
            return this.connection.getName();
        }
    }

    private static class CollaborationLabelProvider
    extends BaseLabelProvider {
        private CollaborationLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof Collaboration) {
                Collaboration entry = (Collaboration)element;
                String text = entry.getWorkspaceConnection().getName();
                if (entry.isDefaultIncoming() && entry.isDefaultOutgoing()) {
                    text = NLS.bind((String)Messages.TeamPlaceOverviewPage_defaultFlow, (Object)text);
                } else {
                    if (entry.isDefaultIncoming()) {
                        text = NLS.bind((String)Messages.TeamPlaceOverviewPage_defaultIncomingFlow, (Object)text);
                    }
                    if (entry.isDefaultOutgoing()) {
                        text = NLS.bind((String)Messages.TeamPlaceOverviewPage_defaultOutgoingFlow, (Object)text);
                    }
                }
                if (entry.isCurrentIncoming() && entry.isCurrentOutgoing()) {
                    text = NLS.bind((String)Messages.TeamPlaceOverviewPage_currentFlow, (Object)text);
                } else {
                    if (entry.isCurrentIncoming()) {
                        text = NLS.bind((String)Messages.TeamPlaceOverviewPage_currentIncomingFlow, (Object)text);
                    }
                    if (entry.isCurrentOutgoing()) {
                        text = NLS.bind((String)Messages.TeamPlaceOverviewPage_currentOutgoingFlow, (Object)text);
                    }
                }
                text = String.valueOf(text) + " [" + RepositoryUtils.getLabel(entry.getWorkspaceConnection().teamRepository()) + "]";
                label.setText(text);
                ImageDescriptor imageDesc = entry.getWorkspaceConnection().isStream() ? ImagePool.STREAM : ImagePool.WORKSPACE;
                label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.getResources(), (ImageDescriptor)imageDesc));
            }
        }
    }

    private static class CollaborationQuery
    extends RepositoryQuery<Collaboration> {
        private AbstractPlaceWrapper abstractPlaceWrapper;
        private IWorkspaceConnection workspaceConnection;

        public CollaborationQuery(IOperationRunner runner, IWorkspaceConnection workspaceConnection) {
            super(workspaceConnection.teamRepository(), runner);
            this.workspaceConnection = workspaceConnection;
        }

        public CollaborationQuery(IOperationRunner runner, AbstractPlaceWrapper abstractPlaceWrapper) {
            super(abstractPlaceWrapper.getRepository(), runner);
            this.abstractPlaceWrapper = abstractPlaceWrapper;
        }

        protected void attachListeners() {
        }

        protected void detachListeners() {
        }

        protected List<Collaboration> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkspaceConnection[] allCollaborationConnections;
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            if (this.workspaceConnection == null) {
                this.workspaceConnection = this.abstractPlaceWrapper.getWorkspaceConnection((IProgressMonitor)sub.newChild(1));
            }
            if ((allCollaborationConnections = FlowTableUtil.getAllAccessibleCollaborations((IWorkspaceConnection)this.workspaceConnection, (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)monitor)).length == 0) {
                return Collections.emptyList();
            }
            ConnectionDescriptor currentIncomingCollaboration = FlowTableUtil.getCurrentIncomingCollaborationDescriptor((IWorkspaceConnection)this.workspaceConnection);
            ConnectionDescriptor currentOutgoingCollaboration = FlowTableUtil.getCurrentOutgoingCollaborationDescriptor((IWorkspaceConnection)this.workspaceConnection);
            ConnectionDescriptor defaultIncomingCollaboration = FlowTableUtil.getDefaultIncomingCollaborationDescriptor((IWorkspaceConnection)this.workspaceConnection);
            ConnectionDescriptor defaultOutgoingCollaboration = FlowTableUtil.getDefaultOutgoingCollaborationDescriptor((IWorkspaceConnection)this.workspaceConnection);
            ArrayList<Collaboration> nodes = new ArrayList<Collaboration>(allCollaborationConnections.length);
            int i = 0;
            while (i < allCollaborationConnections.length) {
                IWorkspaceConnection connection = allCollaborationConnections[i];
                if (connection != null && connection.isStream()) {
                    IWorkspace workspaceHandle = connection.getResolvedWorkspace();
                    nodes.add(new Collaboration(connection, workspaceHandle.sameItemId((IItemHandle)(currentIncomingCollaboration == null ? null : currentIncomingCollaboration.connectionHandle)), workspaceHandle.sameItemId((IItemHandle)(currentOutgoingCollaboration == null ? null : currentOutgoingCollaboration.connectionHandle)), workspaceHandle.sameItemId((IItemHandle)(defaultIncomingCollaboration == null ? null : defaultIncomingCollaboration.connectionHandle)), workspaceHandle.sameItemId((IItemHandle)(defaultOutgoingCollaboration == null ? null : defaultOutgoingCollaboration.connectionHandle))));
                }
                ++i;
            }
            return nodes;
        }

        public String getName() {
            return Messages.LockDialogPart_2;
        }
    }

    private static class CollaborationTreeProvider
    extends AbstractRepositoryTreeProvider {
        private final IOperationRunner runner;
        private final ISetWithListeners root;

        public CollaborationTreeProvider(IOperationRunner runner, ISetWithListeners root) {
            this.runner = runner;
            this.root = root;
        }

        public ISetWithListeners getChildren(Object element) {
            if (element == this.root) {
                return this.root;
            }
            if (element instanceof Collaboration) {
                Collaboration flowTarget = (Collaboration)element;
                return new CollaborationQuery(this.runner, flowTarget.getWorkspaceConnection());
            }
            return null;
        }
    }

    private static class StreamsList
    extends ScmTreeDialogViewer {
        final Set<UUID> initialUUIDs = new HashSet<UUID>();
        CollaborationComparator sorter = null;
        Button remove;

        @Override
        protected String getLabelText() {
            return Messages.LockDialogPart_20;
        }

        @Override
        protected void getInitialTreeRoots(Object dlgInput) {
            LockDialogInput input = (LockDialogInput)dlgInput;
            for (IWorkspaceConnection o : input.getInitialShown()) {
                IWorkspaceConnection workspaceConnection = o;
                if (workspaceConnection == null || !workspaceConnection.isStream()) continue;
                Collaboration c = new Collaboration(workspaceConnection, false, false, false, false);
                this.rootSet.add((Object)c);
            }
        }

        @Override
        protected String getStatusMessage(Object dlgInput) {
            LockDialogInput input = (LockDialogInput)dlgInput;
            return input.isLock() ? Messages.LockDialogPart_0 : Messages.LockDialogPart_REQUIRE_UNLOCK;
        }

        @Override
        protected SimpleTreeViewer createTreeViewer(JobRunner runner) {
            this.treeViewer = new SimpleTreeViewer(this.composite, (ITreeProvider)new CollaborationTreeProvider((IOperationRunner)runner, (ISetWithListeners)this.rootSet), 2850);
            this.treeViewer.setLabelProvider((IViewerLabelProvider)new CollaborationLabelProvider());
            this.treeViewer.setSorter(this.getSorter());
            this.treeViewer.setInput((Object)this.rootSet);
            return this.treeViewer;
        }

        @Override
        protected boolean isCreateSideButtons() {
            return true;
        }

        @Override
        protected void createSideButtons(Composite parent, JobRunner runner, Object input) {
            this.createAddButton(parent, runner, input);
            this.createRemoveButton(parent);
            this.createSelectAllButton(parent);
            this.createDeselectAllButton(parent);
        }

        private void addSelectionListenerToAddButton(final Button add, Object dlgInput, final JobRunner runner) {
            if (add == null) {
                return;
            }
            final LockDialogInput input = (LockDialogInput)dlgInput;
            add.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    final AbstractPlaceWrapper stream = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(add.getShell(), input.getRepository(), null, null, WORKSPACES_OR_STREAMS.STREAMS, false, null, null, false);
                    if (stream != null) {
                        runner.enqueue(Messages.LockDialogPart_2, (Operation)new RepositoryOperation(){

                            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                                final Collaboration c = new Collaboration(stream.getWorkspaceConnection(monitor), false, false, false, false);
                                rootSet.getRealm().exec(new Runnable(){

                                    @Override
                                    public void run() {
                                        initialUUIDs.add(c.getWorkspaceConnection().getResolvedWorkspace().getItemId());
                                        rootSet.add((Object)c);
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }

        protected void createAddButton(Composite parent, JobRunner runner, Object input) {
            Button add = new Button(parent, 8);
            add.setText(Messages.LockDialogPart_18);
            this.addSelectionListenerToAddButton(add, input, runner);
        }

        protected void createRemoveButton(Composite parent) {
            this.remove = new Button(parent, 8);
            this.remove.setText(Messages.LockDialogPart_19);
            this.remove.setEnabled(false);
            this.remove.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    for (Object o : treeViewer.getSelection().toList()) {
                        if (!(o instanceof Collaboration)) continue;
                        Collaboration collaboration = (Collaboration)o;
                        rootSet.remove((Object)collaboration);
                    }
                }
            });
        }

        protected void createSelectAllButton(Composite parent) {
            Button selectAll = new Button(parent, 8);
            selectAll.setText(Messages.LockDialogPart_11);
            selectAll.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (treeViewer.getTree().getItems().length > 0) {
                        TreeItem[] treeItemArray = treeViewer.getTree().getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem t = treeItemArray[n2];
                            t.setChecked(true);
                            ++n2;
                        }
                        ArrayList toggle = new ArrayList();
                        for (Object o : treeViewer.getKnownElements()) {
                            toggle.add(o);
                        }
                        checked.addAll(toggle);
                    }
                }
            });
        }

        protected void createDeselectAllButton(Composite parent) {
            Button deselectAll = new Button(parent, 8);
            deselectAll.setText(Messages.LockDialogPart_12);
            deselectAll.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    TreeItem[] treeItemArray = treeViewer.getTree().getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem t = treeItemArray[n2];
                        t.setChecked(false);
                        ++n2;
                    }
                    checked.clear();
                }
            });
        }

        @Override
        protected Comparator getSorter() {
            if (this.sorter == null) {
                this.sorter = new CollaborationComparator();
            }
            return this.sorter;
        }

        public StreamsList(Composite parent, LockDialogInput input) {
            super(parent, input);
            this.treeViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (remove != null) {
                        remove.setEnabled(this.setRemoveEnabled());
                    }
                }
            });
            for (IWorkspaceHandle workspaceHandle : input.getInitialSelection()) {
                this.initialUUIDs.add(workspaceHandle.getItemId());
            }
            IFilter initialSelection = new IFilter(){

                public boolean select(Object toTest) {
                    Collaboration collaboration;
                    UUID itemId;
                    if (toTest instanceof Collaboration && initialUUIDs.contains(itemId = (collaboration = (Collaboration)toTest).getWorkspaceConnection().getResolvedWorkspace().getItemId())) {
                        initialUUIDs.remove(itemId);
                        return true;
                    }
                    return false;
                }
            };
            this.addCheckedListener(initialSelection, this.getSorter());
        }

        @Override
        public Composite getControl() {
            return this.composite;
        }

        public List<AbstractPlaceWrapper> getResult() {
            ArrayList<AbstractPlaceWrapper> result = new ArrayList<AbstractPlaceWrapper>(this.checked.size());
            for (Object o : this.checked) {
                if (!(o instanceof Collaboration)) continue;
                Collaboration selected = (Collaboration)o;
                AbstractPlaceWrapper wrapper = AbstractPlaceWrapper.newWrapper(selected.getWorkspaceConnection().getResolvedWorkspace());
                result.add(wrapper);
            }
            return result;
        }

        @Override
        public IObservableValue getValidationStatus() {
            return this.validationStatus;
        }

        protected boolean setRemoveEnabled() {
            boolean enabled = false;
            for (Object o : this.treeViewer.getSelection().toList()) {
                Collaboration collaboration;
                if (!(o instanceof Collaboration) || !this.rootSet.contains((Object)(collaboration = (Collaboration)o))) continue;
                enabled = true;
                break;
            }
            return enabled;
        }

        private static class CollaborationComparator
        implements Comparator {
            private CollaborationComparator() {
            }

            public int compare(Object o1, Object o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 instanceof Collaboration) {
                    Collaboration c1 = (Collaboration)o1;
                    if (o2 instanceof Collaboration) {
                        IWorkspace workspace2;
                        Collaboration c2 = (Collaboration)o2;
                        IWorkspace workspace1 = c1.getWorkspaceConnection().getResolvedWorkspace();
                        if (workspace1.sameItemId((IItemHandle)(workspace2 = c2.getWorkspaceConnection().getResolvedWorkspace()))) {
                            return 0;
                        }
                        return workspace1.getName().compareTo(workspace2.getName());
                    }
                }
                return 1;
            }
        }
    }
}

