/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs.gap;

import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.RemotePathResolver;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomSimpleTreeViewer;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesTreeProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotPair;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewComparator;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.StructuralChangesViewLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesChangeSetNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesPlaceholderNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class GapFillingDialog
extends TrayDialog {
    private UIContext uicontext;
    private IWorkspaceConnection workspaceConnection;
    private Map<UUID, IChangeSetHandle> changeSetsWithGapMap;
    private List<IChangeSetHandle> gapFillingChangeSets;
    private SnapshotSyncReport gapFillingChangeSetsSyncReport;
    private boolean handlingSuspended;
    private IOperationRunner operationRunner;
    private Button showChangeExplorerButton;

    public GapFillingDialog(UIContext uicontext, IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetsWithGap, Map<IComponentHandle, List<IChangeSetHandle>> gapFillingChangeSets, boolean handlingSuspended, IOperationRunner operationRunner) {
        super(uicontext.getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.workspaceConnection = workspaceConnection;
        this.changeSetsWithGapMap = new HashMap<UUID, IChangeSetHandle>(changeSetsWithGap.size());
        for (IChangeSetHandle iChangeSetHandle : changeSetsWithGap) {
            this.changeSetsWithGapMap.put(iChangeSetHandle.getItemId(), iChangeSetHandle);
        }
        this.gapFillingChangeSets = new ArrayList<IChangeSetHandle>();
        for (List list : gapFillingChangeSets.values()) {
            this.gapFillingChangeSets.addAll(list);
        }
        SnapshotSyncReportFragment snapshotSyncReportFragment = SnapshotSyncReportFragment.emptyReport();
        SnapshotSyncReportFragment gapFillingChangeSetsReportFragment = SnapshotSyncReportFragment.createFromChangeSets(gapFillingChangeSets);
        this.gapFillingChangeSetsSyncReport = new SnapshotSyncReport(gapFillingChangeSetsReportFragment, snapshotSyncReportFragment);
        this.uicontext = uicontext;
        this.handlingSuspended = handlingSuspended;
        this.operationRunner = operationRunner;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.WarnUpdateCurrentPortDilemmaHandler_FILL_THE_GAP_DIALOG_TITLE);
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, helpContextId);
        }
    }

    protected String getHelpContextId() {
        return "com.ibm.team.filesystem.ide.ui.dialog_fillgap";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.defaultsFor((Control)composite).grab(true, true).applyTo((Control)composite);
        int numGapFillingChangeSets = this.gapFillingChangeSets.size() - this.changeSetsWithGapMap.size();
        Label label = new Label(composite, 64);
        String labelText = this.changeSetsWithGapMap.size() == 1 ? (this.handlingSuspended ? Messages.GapFillingDialog_RESUME_SINGULAR : Messages.GapFillingDialog_ACCEPT_SINGULAR) : (this.handlingSuspended ? Messages.GapFillingDialog_RESUME_PLURAL : Messages.GapFillingDialog_ACCEPT_PLURAL);
        label.setText(labelText);
        final Composite stackComposite = new Composite(composite, 0);
        GridDataFactory.defaultsFor((Control)stackComposite).grab(true, true).applyTo((Control)stackComposite);
        final StackLayout stackLayout = new StackLayout();
        stackComposite.setLayout((Layout)stackLayout);
        ExpandableComposite twistie = new ExpandableComposite(stackComposite, 42);
        String twistieText = Messages.GapFillingDialog_SHOW_MISSING_SINGULAR;
        if (numGapFillingChangeSets > 1) {
            twistieText = NLS.bind((String)Messages.GapFillingDialog_SHOW_MISSING_PLURAL, (Object)numGapFillingChangeSets, (Object[])new Object[0]);
        }
        twistie.setText(twistieText);
        stackLayout.topControl = twistie;
        twistie.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                Composite treeComposite = GapFillingDialog.this.createTreeComposite(stackComposite);
                stackLayout.topControl = treeComposite;
                int treeItemHeight = 0;
                int otherControlsHeight = 0;
                Control[] controlArray = treeComposite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    if (control instanceof Tree) {
                        Tree tree = (Tree)control;
                        treeItemHeight = tree.getItemHeight();
                    } else {
                        Point size = control.computeSize(stackComposite.getSize().x, -1);
                        otherControlsHeight += size.y;
                    }
                    ++n2;
                }
                int numTreeItems = GapFillingDialog.this.gapFillingChangeSetsSyncReport.getAffectedComponents().size() + GapFillingDialog.this.gapFillingChangeSets.size();
                numTreeItems = Math.min(numTreeItems, 10) + 2;
                int totalTreeItemsHeights = treeItemHeight * numTreeItems;
                Point treeSize = stackComposite.getSize();
                Point shellSize = GapFillingDialog.this.getShell().getSize();
                int heightToAdd = totalTreeItemsHeights + otherControlsHeight;
                heightToAdd = heightToAdd < treeSize.y ? 0 : (heightToAdd -= treeSize.y);
                GapFillingDialog.this.getShell().setSize(shellSize.x, shellSize.y + heightToAdd);
                stackComposite.layout();
            }
        });
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout(composite);
        GapFillingDialog.applyDialogFont((Control)composite);
        return parent;
    }

    private Composite createTreeComposite(Composite composite) {
        ITeamRepository repository = this.workspaceConnection.teamRepository();
        RemotePathResolver pathResolver = new RemotePathResolver((IConnection)this.workspaceConnection);
        WorkspaceId workspaceId = WorkspaceId.create((ITeamRepository)repository, (IWorkspaceHandle)this.workspaceConnection.getResolvedWorkspace());
        SnapshotId emptyId = SnapshotId.createEmptyId((ITeamRepository)repository);
        SnapshotPair workspacePair = new SnapshotPair((SnapshotId)workspaceId, emptyId);
        Composite treeComposite = new Composite(composite, 0);
        Label twistieOpen = new Label(treeComposite, 64);
        twistieOpen.setText(Messages.GapFillingDialog_ALL_CHANGE_SETS);
        GridDataFactory.defaultsFor((Control)twistieOpen).grab(true, false).applyTo((Control)twistieOpen);
        int style = 2816;
        SnapshotSyncReport input = this.gapFillingChangeSetsSyncReport;
        Tree tree = this.createTree(treeComposite, style, repository, pathResolver, workspacePair, input, this.operationRunner);
        GridDataFactory.defaultsFor((Control)tree).grab(true, true).applyTo((Control)tree);
        this.showChangeExplorerButton = new Button(treeComposite, 32);
        this.showChangeExplorerButton.setText(Messages.GapFillingDialog_SHOW_CHANGE_EXPLORER);
        GridLayoutFactory.fillDefaults().generateLayout(treeComposite);
        treeComposite.setVisible(false);
        return treeComposite;
    }

    private Tree createTree(Composite composite, int style, ITeamRepository repository, RemotePathResolver pathResolver, SnapshotPair workspacePair, SnapshotSyncReport input, IOperationRunner operationRunner) {
        Tree tree = new Tree(composite, style);
        CustomTreeViewer customTreeViewer = new CustomTreeViewer(tree);
        ChangesTreeProvider provider = new ChangesTreeProvider(repository, FlowType.Incoming, workspacePair, (IPathResolver)pathResolver, false, operationRunner);
        CustomSimpleTreeViewer customsimpleTreeViewer = new CustomSimpleTreeViewer(customTreeViewer, provider);
        customsimpleTreeViewer.setInput(input);
        StructuralChangesViewLabelProvider labelProvider = new StructuralChangesViewLabelProvider(customsimpleTreeViewer.getKnownElements(), operationRunner, true){

            @Override
            protected void updateLabelChangeSetNode(ViewerLabel label, StructuralChangesChangeSetNode changeSetNode) {
                super.updateLabelChangeSetNode(label, changeSetNode);
                String text = label.getText();
                ChangeSetWrapper changeSetWrapper = changeSetNode.getWrapper();
                if (!GapFillingDialog.this.changeSetsWithGapMap.containsKey(changeSetWrapper.getChangeSet().getItemId())) {
                    text = CustomTreeViewer.removeMarkup(text);
                    text = CustomTreeViewer.markupBold(NLS.bind((String)Messages.GapFillingDialog_ASTERIX_BOLD, (Object)text, (Object[])new Object[0]), this.customMarkup);
                }
                label.setText(text);
            }
        };
        labelProvider.setPathResolver((IPathResolver)pathResolver);
        customTreeViewer.init(new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)new LocalSynchronizeDecorator(true)));
        customsimpleTreeViewer.setSorter((Comparator)StructuralChangesViewComparator.getComparator());
        customsimpleTreeViewer.expandMatching(new IFilter(){

            public boolean select(Object toTest) {
                return toTest instanceof StructuralChangesComponentNode || toTest instanceof StructuralChangesPlaceholderNode;
            }
        });
        return tree;
    }

    protected IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode(String.valueOf(StatusUtil.getPlugin((Object)((Object)this))) + '/' + ((Object)((Object)this)).getClass().getName());
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.GapFillingDialog_ACCEPT_ALL_CHANGE_SETS, false);
        this.createButton(parent, 2, Messages.GapFillingDialog_BEGIN_MERGE, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 2: {
                this.yesPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void cancelPressed() {
        boolean cancelOpensChangeExplorer;
        if (this.showChangeExplorerButton != null && (cancelOpensChangeExplorer = this.showChangeExplorerButton.getSelection())) {
            this.showInChangeExplorer();
        }
        super.cancelPressed();
    }

    private void yesPressed() {
        this.setReturnCode(2);
        this.close();
    }

    private void showInChangeExplorer() {
        WorkspaceId snapshot = WorkspaceId.create((ITeamRepository)this.workspaceConnection.teamRepository(), (IWorkspaceHandle)this.workspaceConnection.getResolvedWorkspace());
        ChangesViewConverter.openChangeExplorer(this.uicontext.getPage(), new ChangeSetInput((SnapshotId)snapshot, this.gapFillingChangeSets));
    }
}

