/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTreeViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ScmTreeDialogViewer {
    protected Composite composite;
    protected WritableValue validationStatus;
    protected SimpleTreeViewer treeViewer;
    protected WritableSetWithListeners checked;
    protected WritableSetWithListeners rootSet;
    protected Object inputData;

    protected abstract Comparator getSorter();

    protected abstract String getStatusMessage(Object var1);

    protected abstract SimpleTreeViewer createTreeViewer(JobRunner var1);

    protected abstract void getInitialTreeRoots(Object var1);

    protected abstract IObservableValue getValidationStatus();

    protected void createSideButtons(Composite parent, JobRunner runner, Object input) {
    }

    protected boolean isCreateSideButtons() {
        return false;
    }

    protected abstract String getLabelText();

    protected void createDialogSpecificControls(Composite composite, JobRunner runner) {
    }

    protected void setControlState() {
    }

    public abstract Composite getControl();

    public ScmTreeDialogViewer(Composite parent, final Object input) {
        this.inputData = input;
        this.checked = new WritableSetWithListeners();
        this.validationStatus = new WritableValue();
        this.validationStatus.setValue((Object)Status.OK_STATUS);
        this.composite = new Composite(parent, 0);
        if (this.isCreateSideButtons()) {
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.composite);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(this.composite);
        }
        GridDataFactory.fillDefaults().applyTo((Control)this.composite);
        JobRunner runner = new JobRunner(true);
        this.rootSet = new WritableSetWithListeners();
        this.getInitialTreeRoots(this.inputData);
        this.createDialogSpecificControls(this.composite, runner);
        Label label = new Label(this.composite, 0);
        label.setText(this.getLabelText());
        if (this.isCreateSideButtons()) {
            GridDataFactory.defaultsFor((Control)label).span(2, 1).applyTo((Control)label);
        } else {
            GridDataFactory.defaultsFor((Control)label).applyTo((Control)label);
        }
        this.treeViewer = this.createTreeViewer(runner);
        Tree tree = this.treeViewer.getTree();
        if (this.isCreateSideButtons()) {
            Composite buttonsComposite = new Composite(this.composite, 0);
            this.createSideButtons(buttonsComposite, runner, input);
            GridLayoutFactory.fillDefaults().generateLayout(buttonsComposite);
            GridDataFactory.defaultsFor((Control)buttonsComposite).applyTo((Control)buttonsComposite);
        }
        this.setControlState();
        Dialog.applyDialogFont((Control)this.composite);
        GridDataFactory.defaultsFor((Control)tree).grab(true, true).applyTo((Control)tree);
        this.checked.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                String statusMessage = ScmTreeDialogViewer.this.getStatusMessage(input);
                ScmTreeDialogViewer.this.validationStatus.setValue((Object)(ScmTreeDialogViewer.this.checked.isEmpty() ? StatusUtil.newStatus((Object)this, (String)statusMessage) : Status.OK_STATUS));
            }
        });
        this.treeViewer.setSorter(this.getSorter());
        this.treeViewer.setInput((Object)this.rootSet);
    }

    protected void addCheckedListener(final IFilter initialSelection, final Comparator<Object> comparator) {
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TreeItem item = (TreeItem)e.item;
                    if (item.getChecked()) {
                        ArrayList toggle = new ArrayList();
                        for (Object o : ScmTreeDialogViewer.this.treeViewer.getKnownElements()) {
                            if (comparator.compare(o, item.getData()) != 0) continue;
                            toggle.add(o);
                        }
                        ScmTreeDialogViewer.this.checked.addAll(toggle);
                    } else {
                        ArrayList toggle = new ArrayList();
                        for (Object o : ScmTreeDialogViewer.this.treeViewer.getKnownElements()) {
                            if (comparator.compare(o, item.getData()) != 0) continue;
                            toggle.add(o);
                        }
                        ScmTreeDialogViewer.this.checked.removeAll(toggle);
                    }
                }
            }
        });
        this.treeViewer.getKnownElements().addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                if (ScmTreeDialogViewer.this.treeViewer.getTree().isDisposed()) {
                    return;
                }
                HashSet set = new HashSet();
                for (Object o : event.diff.getAdditions()) {
                    if (!initialSelection.select(o) && !ScmTreeDialogViewer.this.contains((Set)ScmTreeDialogViewer.this.checked, o, comparator)) continue;
                    set.add(o);
                }
                ScmTreeDialogViewer.this.checked.addAll(set);
                set.clear();
                for (Object o : event.diff.getRemovals()) {
                    if (!ScmTreeDialogViewer.this.contains((Set)ScmTreeDialogViewer.this.checked, o, comparator)) continue;
                    set.add(o);
                }
                ScmTreeDialogViewer.this.checked.removeAll(set);
            }
        });
        this.checked.addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                HashMap<TreeItem, Object> map = new HashMap<TreeItem, Object>();
                HashSet set = new HashSet();
                set.addAll(event.diff.getAdditions());
                set.addAll(event.diff.getRemovals());
                ScmTreeDialogViewer.this.getTreeItems(ScmTreeDialogViewer.this.treeViewer.getTree().getItems(), set, map, comparator);
                for (Map.Entry entry : map.entrySet()) {
                    if (ScmTreeDialogViewer.this.contains(event.diff.getAdditions(), entry.getValue(), comparator)) {
                        ((TreeItem)entry.getKey()).setChecked(true);
                    }
                    if (!ScmTreeDialogViewer.this.contains(event.diff.getRemovals(), entry.getValue(), comparator)) continue;
                    ((TreeItem)entry.getKey()).setChecked(false);
                }
            }
        });
    }

    public boolean contains(Set set, Object o, Comparator<Object> comparator) {
        for (Object inSet : set) {
            if (comparator.compare(inSet, o) != 0) continue;
            return true;
        }
        return false;
    }

    public void getTreeItems(TreeItem[] items, Set keys, Map<TreeItem, Object> map, Comparator<Object> comparator) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (this.contains(keys, data, comparator)) {
                map.put(item, data);
            }
            this.getTreeItems(item.getItems(), keys, map, comparator);
            ++n2;
        }
    }
}

