/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs;

import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ui.views.TeamViewSorter;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.SnapshotEditPart;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class NewSnapshotDialog
extends DetailsDialog
implements IStatusCollector {
    private final ITeamRepository repo;
    private SnapshotEditPart snapshotPart;
    private Button forceBaselineCreationButton;
    private Label errorMessageLabel;
    private String errorMessage = "";
    private IWorkspace workspace;
    private int baselineSetFlags = 1;
    private List<WorkspaceComponentWrapper> components = null;
    private List<IComponent> uncheckedComponents = new ArrayList<IComponent>();

    public NewSnapshotDialog(Shell parentShell, String title, ITeamRepository repo, IWorkspace workspace) {
        super(parentShell, title, DetailsDialog.ButtonBar.OkCancelDetails);
        this.repo = repo;
        this.workspace = workspace;
    }

    @Override
    protected Composite createDialogArea(Composite top) {
        Composite parent = new Composite(top, 0);
        this.snapshotPart = new SnapshotEditPart(this, new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                NewSnapshotDialog.this.buttonPressed(0);
            }
        });
        this.snapshotPart.createContents(parent);
        this.forceBaselineCreationButton = new Button(parent, 32);
        this.forceBaselineCreationButton.setText(Messages.NewSnapshotDialog_ForceBaselineCreation);
        this.forceBaselineCreationButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewSnapshotDialog newSnapshotDialog = NewSnapshotDialog.this;
                newSnapshotDialog.baselineSetFlags = newSnapshotDialog.baselineSetFlags ^ 2;
            }
        });
        if (!this.workspace.isStream()) {
            this.createNoteComposite(JFaceResources.getDialogFont(), parent, Messages.NewSnapshotDialog_NOTE_TITLE, Messages.NewSnapshotDialog_WARNING_MESSAGE);
        }
        this.errorMessageLabel = new Label(parent, 0);
        this.errorMessageLabel.setLayoutData((Object)new GridData(768));
        this.errorMessageLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.errorMessageLabel.setText(this.errorMessage);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        return parent;
    }

    public void create() {
        super.create();
        this.snapshotPart.setDefaultButton(this.getButton(0));
    }

    @Override
    protected void enableButtons() {
        super.enableButtons();
        this.setOkEnabled(false);
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.team.filesystem.ide.ui.dialog_newsnapshot";
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        Composite messageComposite = new Composite(composite, 0);
        messageComposite.setFont(font);
        final Label noteLabel = new Label(messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    noteLabel.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(fontListener);
        noteLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)messageComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(messageComposite);
        return messageComposite;
    }

    @Override
    protected Composite createDropDownDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        Label l = new Label(container, 0);
        l.setText(Messages.NewSnapshotDialog_1);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)l);
        final CheckboxTableViewer componentsViewer = new CheckboxTableViewer(new Table(container, 2850));
        componentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        componentsViewer.setLabelProvider((IBaseLabelProvider)LabelProviders.create((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        componentsViewer.setSorter((ViewerSorter)new TeamViewSorter());
        componentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewSnapshotDialog.this.uncheckedComponents.clear();
                if (NewSnapshotDialog.this.components != null) {
                    for (WorkspaceComponentWrapper wrapper : NewSnapshotDialog.this.components) {
                        IComponent component = wrapper.getComponent();
                        if (componentsViewer.getChecked((Object)wrapper) || NewSnapshotDialog.this.uncheckedComponents.contains(component)) continue;
                        NewSnapshotDialog.this.uncheckedComponents.add(component);
                    }
                }
                NewSnapshotDialog.this.updateEnablements();
            }
        });
        Job j = new Job(Messages.NewSnapshotDialog_2){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)NewSnapshotDialog.this.repo).getWorkspaceConnection((IWorkspaceHandle)NewSnapshotDialog.this.workspace, monitor);
                    NewSnapshotDialog.this.components = WorkspaceUtil.getComponentWrappers(connection, monitor);
                    if (componentsViewer != null && !componentsViewer.getControl().isDisposed()) {
                        componentsViewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                componentsViewer.setInput((Object)NewSnapshotDialog.this.components);
                                componentsViewer.setAllChecked(true);
                            }
                        });
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
        componentsViewer.setAllChecked(true);
        Composite buttonsComposite = new Composite(container, 0);
        Button selectAllButton = new Button(buttonsComposite, 8);
        selectAllButton.setText(Messages.NewSnapshotDialog_3);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                componentsViewer.setAllChecked(true);
                NewSnapshotDialog.this.uncheckedComponents.clear();
                NewSnapshotDialog.this.updateEnablements();
            }
        });
        Button deselectAllButton = new Button(buttonsComposite, 8);
        deselectAllButton.setText(Messages.NewSnapshotDialog_4);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                componentsViewer.setAllChecked(false);
                for (WorkspaceComponentWrapper wrapper : NewSnapshotDialog.this.components) {
                    IComponent component = wrapper.getComponent();
                    if (NewSnapshotDialog.this.uncheckedComponents.contains(component)) continue;
                    NewSnapshotDialog.this.uncheckedComponents.add(component);
                }
                NewSnapshotDialog.this.updateEnablements();
            }
        });
        NewSnapshotDialog.applyDialogFont((Control)container);
        GridLayoutFactory.fillDefaults().generateLayout(buttonsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(container);
        return container;
    }

    protected void updateEnablements() {
        boolean allValid = true;
        if (this.uncheckedComponents != null && this.components != null && this.uncheckedComponents.size() == this.components.size()) {
            allValid = false;
            this.setErrorMessage(Messages.NewSnapshotDialog_5);
        }
        if (allValid && this.snapshotPart != null && !this.snapshotPart.isValid()) {
            this.snapshotPart.updateEnablements();
            allValid = false;
        }
        this.setOkEnabled(allValid);
        if (allValid) {
            this.setErrorMessage(null);
        }
    }

    protected final void setErrorMessage(String error) {
        String string = this.errorMessage = error == null ? "" : error;
        if (this.errorMessageLabel != null) {
            this.errorMessageLabel.setText(this.errorMessage);
            this.errorMessageLabel.update();
        }
    }

    public String getName() {
        return this.snapshotPart.getName();
    }

    public String getComment() {
        return this.snapshotPart.getComment();
    }

    public int getBaselineSetFlags() {
        return this.baselineSetFlags;
    }

    public List<IComponent> getExcludedComponents() {
        if (this.uncheckedComponents == null) {
            return Collections.emptyList();
        }
        return this.uncheckedComponents;
    }

    @Override
    protected String getDetailsButtonLabelHide() {
        return Messages.NewSnapshotDialog_7;
    }

    @Override
    protected String getDetailsButtonLabelShow() {
        return Messages.NewSnapshotDialog_8;
    }

    public void reportProblem(IStatus toReport) {
        if (toReport.isOK()) {
            this.setOkEnabled(true);
            this.setErrorMessage(null);
            this.updateEnablements();
        } else {
            this.setOkEnabled(false);
            this.setErrorMessage(toReport.getMessage());
        }
    }

    public void setProblemSummary(String title, String message) {
    }

    public void reportException(Throwable exception) {
    }

    protected final void setOkEnabled(boolean complete) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(complete);
        }
    }
}

