/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.BaselineEditPart;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.filesystem.ui.queries.ComponentScopedBaselinesQuery;
import com.ibm.team.filesystem.ui.views.TeamViewSorter;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.query.PagedTable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class NewBaselineDialog
extends DetailsDialog {
    private final IComponent component;
    private final IWorkspaceConnection connection;
    private PagedTable<BaselineWrapper> pagedTable;
    private BaselineEditPart baselinePart;

    public NewBaselineDialog(Shell parentShell, String title, IComponent component, IWorkspaceConnection connection) {
        super(parentShell, title, component == null || connection == null ? DetailsDialog.ButtonBar.OkCancel : DetailsDialog.ButtonBar.OkCancelDetails);
        this.component = component;
        this.connection = connection;
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        this.baselinePart = new BaselineEditPart(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                NewBaselineDialog.this.buttonPressed(0);
            }
        });
        Control baselinePartControl = this.baselinePart.createContents(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(baselinePartControl);
        return (Composite)baselinePartControl;
    }

    @Override
    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.baselinePart.setFocus();
        final Button okButton = this.getButton(0);
        if (okButton != null) {
            this.baselinePart.addNameModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (okButton.isDisposed()) {
                        return;
                    }
                    String name = NewBaselineDialog.this.getName();
                    okButton.setEnabled(name != null && !name.trim().isEmpty());
                }
            });
            String name = this.getName();
            okButton.setEnabled(name != null && !name.trim().isEmpty());
        }
        return content;
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.team.filesystem.ide.ui.dialog_newbaseline";
    }

    @Override
    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label label = new Label(composite, 0);
        label.setText(Messages.NewBaselineDialog_1);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.pagedTable = new PagedTable(composite, WidgetFactoryContext.forDialogBox(), 68352, null, null);
        SimpleTableViewer viewer = this.pagedTable.getViewer();
        viewer.getTable().setHeaderVisible(false);
        new LabelColumn(viewer, Messages.NewBaselineDialog_2, -1);
        viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement != null) {
                    BaselineWrapper bw = (BaselineWrapper)firstElement;
                    NewBaselineDialog.this.baselinePart.setNameText(bw.getName());
                }
            }
        });
        viewer.setSorter(TeamViewSorter.getBaselineComparator());
        ComponentScopedBaselinesQuery scopedBaselines = new ComponentScopedBaselinesQuery((ItemLocator<IComponent>)new ItemLocator(this.connection.teamRepository(), (IAuditableHandle)this.component), Collections.singleton(ItemId.forItem((IItem)this.connection.getResolvedWorkspace())), (IOperationRunner)new JobRunner(false));
        this.pagedTable.setInput((ISetWithListeners)scopedBaselines);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.pagedTable.getControl());
        NewBaselineDialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        return composite;
    }

    public String getName() {
        return this.baselinePart.getName();
    }

    public String getComment() {
        return this.baselinePart.getComment();
    }
}

