/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs;

import com.ibm.team.filesystem.ide.ui.internal.dialogs.DetailsDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialog
extends DetailsDialog {
    private Clipboard clipboard;
    private IStatus input;
    private static final String NESTING_INDENT = "  ";
    private StatusTreeContentLabelProvider contentProvider;
    private StatusLabelProvider labelProvider;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator") == null ? "\n" : System.getProperty("line.separator");

    public ErrorDialog(Shell parentShell, String dialogTitle, String message, int imageKey, IStatus status, DetailsDialog.ButtonBar buttonBar) {
        super(parentShell, dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle, buttonBar);
        this.input = status;
        String statusMessage = status.getMessage();
        if (message == null) {
            message = statusMessage;
        }
        if (statusMessage != null && !statusMessage.equals(message)) {
            message = JFaceResources.format((String)"Reason", (Object[])new Object[]{message, status.getMessage()});
        }
        this.initializeMessage(message, imageKey);
        this.setHelpAvailable(false);
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        super.createDialogArea(composite);
        this.createSupportArea(composite);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        return composite;
    }

    private void createSupportArea(Composite parent) {
        ErrorSupportProvider provider = Policy.getErrorSupportProvider();
        if (provider == null) {
            return;
        }
        Composite supportArea = new Composite(parent, 0);
        provider.createSupportArea(supportArea, this.input);
        GridData supportData = new GridData(4, 4, true, true);
        supportData.verticalSpan = 4;
        supportArea.setLayoutData((Object)supportData);
        if (supportArea.getLayout() == null) {
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            supportArea.setLayout((Layout)layout);
        }
    }

    @Override
    protected Composite createDropDownDialogArea(Composite parent) {
        if (this.input == null) {
            return null;
        }
        Composite composite = new Composite(parent, 0);
        Label label = new Label(composite, 0);
        label.setText(Messages.ErrorDialog_Errors);
        TreeViewer viewer = new TreeViewer(composite);
        this.labelProvider = new StatusLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.contentProvider = new StatusTreeContentLabelProvider(this.input);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setInput((Object)this.contentProvider);
        Menu copyMenu = new Menu((Control)viewer.getTree());
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorDialog.this.copyToClipboard();
            }
        });
        copyItem.setText(JFaceResources.getString((String)"copy"));
        viewer.getTree().setMenu(copyMenu);
        ErrorDialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        return composite;
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        StringBuffer statusBuffer = new StringBuffer();
        this.populateCopyBuffer(this.input, statusBuffer, 0);
        this.clipboard = new Clipboard(this.getShell().getDisplay());
        this.clipboard.setContents(new Object[]{statusBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void populateCopyBuffer(Object o, StringBuffer buffer, int nesting) {
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING_INDENT);
            ++i;
        }
        buffer.append(this.labelProvider.getColumnText(o, 0));
        buffer.append(LINE_SEPARATOR);
        Object[] objectArray = this.contentProvider.getChildren(o);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.populateCopyBuffer(child, buffer, nesting + 1);
            ++n2;
        }
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    private final class StatusLabelProvider
    implements IViewerLabelProvider,
    ITableLabelProvider {
        private StatusLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IStatus) {
                String throwableMessage;
                IStatus status = (IStatus)element;
                Throwable t = status.getException();
                String message = status.getMessage();
                if (t != null && message.contains(throwableMessage = t.getLocalizedMessage())) {
                    return throwableMessage;
                }
                return message;
            }
            if (element instanceof Throwable) {
                Throwable t = (Throwable)element;
                return t.getLocalizedMessage();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            String text = this.getColumnText(element, 0);
            if (text != null) {
                label.setText(text);
            }
        }
    }

    private static class StatusTreeContentLabelProvider
    implements ITreeContentProvider {
        private IStatus input;

        public StatusTreeContentLabelProvider(IStatus input) {
            this.input = input;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == this) {
                return new Object[]{this.input};
            }
            if (parentElement instanceof IStatus) {
                CoreException ce;
                Object[] cChildren;
                Object[] sChildren;
                IStatus status = (IStatus)parentElement;
                Throwable t = status.getException();
                Object[] children = sChildren = status.getChildren();
                if (t instanceof CoreException && (cChildren = this.getChildren((Object)(ce = (CoreException)t))).length > 0) {
                    if (children.length == 0) {
                        children = cChildren;
                    } else {
                        Object[] newChildren = new Object[children.length + cChildren.length];
                        System.arraycopy(children, 0, newChildren, 0, children.length);
                        System.arraycopy(children, children.length, cChildren, 0, cChildren.length);
                        children = newChildren;
                    }
                }
                return children;
            }
            if (parentElement instanceof CoreException) {
                CoreException ce = (CoreException)((Object)parentElement);
                IStatus eStatus = ce.getStatus();
                if (!(this.input.equals(eStatus) || eStatus == null || ((Object)((Object)ce)).equals(eStatus.getException()) || eStatus.getChildren().length == 0 && ce.getLocalizedMessage().contains(eStatus.getMessage()))) {
                    return new Object[]{eStatus};
                }
                return new Object[0];
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

