/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.internal.databinding.ValidatorStatus;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.osgi.service.prefs.Preferences;

public class EncodingPart {
    private final String ENCODING_PREFERENCE_KEY = "com.ibm.team.filesystem.ide.ui.internal.dialogs.EncodingPart.DefaultEncoding";
    private EncodingPartInput fInput;
    private Combo fEncodingCombo;
    private IObservableValue fTextObservable;
    private ValidatorStatus fValidatorObservable;
    private CombinedStatus fValidationStatus;
    private EncodingResult fEncodingResult;

    public EncodingPart(EncodingPartInput input) {
        this.fInput = input;
    }

    public IObservableValue getValidationStatus() {
        return this.fValidationStatus;
    }

    public Combo getEncodingCombo() {
        return this.fEncodingCombo;
    }

    public void addModifyListener(ModifyListener listener) {
        this.fEncodingCombo.addModifyListener(listener);
    }

    public EncodingResult getResult() {
        return this.fEncodingResult;
    }

    public void create(Composite composite, WidgetFactoryContext context) {
        this.fValidationStatus = new CombinedStatus();
        Group group = this.createEncodingGroup(composite, context.getToolkit(), 2);
        Dialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(LayoutConstants.getMargins()).generateLayout((Composite)group);
    }

    private Group createEncodingGroup(Composite parent, WidgetToolkit toolkit, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        Group top = new Group(parent, 0);
        top.setText(this.fInput.getEncodingTitle());
        Group topControl = top;
        GridData data = new GridData(768);
        topControl.setLayoutData((Object)data);
        topControl.setLayout((Layout)layout);
        toolkit.createLabel((Composite)top, this.fInput.getEncodingLabel());
        this.fEncodingCombo = new Combo((Composite)top, 12);
        this.populateEncodingsCombo();
        ISWTObservableValue unprocessedText = WidgetProperties.text().observe((Widget)this.fEncodingCombo);
        this.fTextObservable = new ComputedValue((IObservableValue)unprocessedText){
            private final /* synthetic */ IObservableValue val$unprocessedText;
            {
                this.val$unprocessedText = iObservableValue;
            }

            protected Object calculate() {
                return TextProcessor.deprocess((String)((String)this.val$unprocessedText.getValue()));
            }
        };
        this.fValidatorObservable = new ValidatorStatus(this.fTextObservable, new IValidator(){

            public IStatus validate(Object value) {
                String text = (String)value;
                try {
                    if (Charset.isSupported(text)) {
                        return Status.OK_STATUS;
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    // empty catch block
                }
                return StatusUtil.newStatus((Object)this, (int)4, (String)IDEWorkbenchMessages.WorkbenchPreference_unsupportedEncoding);
            }
        });
        this.fEncodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EncodingPart.this.fEncodingCombo != null && !EncodingPart.this.fEncodingCombo.isDisposed()) {
                    String encoding = EncodingPart.this.fEncodingCombo.getText();
                    EncodingPart.this.fEncodingResult = new EncodingResult(encoding);
                    Preferences prefs = EncodingPart.this.fInput.getPreferences();
                    if (prefs != null) {
                        prefs.put("com.ibm.team.filesystem.ide.ui.internal.dialogs.EncodingPart.DefaultEncoding", encoding);
                    }
                    EncodingPart.this.fValidationStatus.addStatus((IObservableValue)EncodingPart.this.fValidatorObservable);
                }
            }
        });
        topControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EncodingPart.this.onDispose();
            }
        });
        data = new GridData();
        this.fEncodingCombo.setLayoutData((Object)data);
        return top;
    }

    private void populateEncodingsCombo() {
        String defaultEncoding = "UTF-8";
        int defaultEncodingIndex = -1;
        Preferences prefs = this.fInput.getPreferences();
        if (prefs != null) {
            defaultEncoding = prefs.get("com.ibm.team.filesystem.ide.ui.internal.dialogs.EncodingPart.DefaultEncoding", defaultEncoding);
        }
        List encodings = IDEEncoding.getIDEEncodings();
        String[] encodingStrings = new String[encodings.size()];
        int i = 0;
        while (i < encodings.size()) {
            Object o = encodings.get(i);
            if (o instanceof String) {
                String encoding = (String)o;
                if (encoding.equals(defaultEncoding)) {
                    defaultEncodingIndex = i;
                }
                encodingStrings[i] = encoding;
            }
            ++i;
        }
        this.fEncodingCombo.setItems(encodingStrings);
        if (defaultEncodingIndex != -1) {
            this.fEncodingCombo.select(defaultEncodingIndex);
        } else {
            this.fEncodingCombo.setText(defaultEncoding);
        }
        String encoding = this.fEncodingCombo.getText();
        this.fEncodingResult = new EncodingResult(encoding);
        prefs.put("com.ibm.team.filesystem.ide.ui.internal.dialogs.EncodingPart.DefaultEncoding", encoding);
    }

    private void onDispose() {
        this.fValidatorObservable.dispose();
        this.fTextObservable.dispose();
    }

    public static class EncodingPartInput {
        private String fEncodingTitle;
        private String fEncodingLabel;
        private Preferences fPreferences;

        public EncodingPartInput(String encodingTitle, String encodingLabel, Preferences preferences) {
            this.fEncodingTitle = encodingTitle;
            this.fEncodingLabel = encodingLabel;
            this.fPreferences = preferences;
        }

        public String getEncodingTitle() {
            return this.fEncodingTitle;
        }

        public String getEncodingLabel() {
            return this.fEncodingLabel;
        }

        public Preferences getPreferences() {
            return this.fPreferences;
        }
    }

    public static class EncodingResult {
        private String fEncoding;

        public EncodingResult(String encoding) {
            this.fEncoding = encoding;
        }

        public String getEncoding() {
            return this.fEncoding;
        }
    }
}

