/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs;

import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DetailsDialog
extends TrayDialog {
    private String title;
    private Composite detailsComposite;
    private String message = null;
    private int imageKey = 0;
    private LinkedHashMap<Integer, String> buttons;
    private int defaultButtonId = 0;
    private String toggleMessage;
    private Button toggleButton;
    private boolean toggleState;
    private IPreferenceStore prefStore;
    private String prefKey;

    protected DetailsDialog(Shell parentShell, String dialogTitle, ButtonBar buttonBar) {
        super(parentShell);
        this.title = dialogTitle;
        this.initializeStyle();
        this.initializeButtons(buttonBar);
    }

    private void initializeButtons(ButtonBar buttonBar) {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        switch (buttonBar) {
            default: {
                map.put(0, IDialogConstants.OK_LABEL);
                break;
            }
            case OkCancel: {
                map.put(0, IDialogConstants.OK_LABEL);
                map.put(1, IDialogConstants.CANCEL_LABEL);
                break;
            }
            case OkDetails: {
                map.put(0, IDialogConstants.OK_LABEL);
                map.put(13, this.getDetailsButtonLabelShow());
                break;
            }
            case OkCancelDetails: {
                map.put(0, IDialogConstants.OK_LABEL);
                map.put(1, IDialogConstants.CANCEL_LABEL);
                map.put(13, this.getDetailsButtonLabelShow());
                break;
            }
            case YesNoDetails: {
                map.put(2, IDialogConstants.YES_LABEL);
                map.put(3, IDialogConstants.NO_LABEL);
                map.put(13, this.getDetailsButtonLabelShow());
            }
        }
        this.initializeButtons(map);
    }

    public DetailsDialog(Shell parent, String dialogTitle, String message, int imageKey, ButtonBar buttonBar) {
        this(parent, dialogTitle, buttonBar);
        this.initializeMessage(message, imageKey);
        this.setHelpAvailable(false);
    }

    public static DetailsDialog newInformationWithToggle(Shell parent, String title, String message, IPreferenceStore prefStore, String prefKey) {
        DetailsDialog dialog = new DetailsDialog(parent, title, message, 2, ButtonBar.Ok);
        dialog.initializeToggleButtonDontShowMeThisAgain(prefStore, prefKey);
        return dialog;
    }

    protected void initializeStyle() {
        this.setShellStyle(67696);
    }

    public void initializeButtons(LinkedHashMap<Integer, String> buttons) {
        this.buttons = buttons;
    }

    public void initializeMessage(String message, int imageKey) {
        this.message = message;
        this.imageKey = imageKey;
    }

    public void initializeToggleButton(String message, boolean toggleState, IPreferenceStore prefStore, String prefKey) {
        this.toggleMessage = message;
        this.toggleState = toggleState;
        this.prefStore = prefStore;
        this.prefKey = prefKey;
    }

    public void initializeToggleButtonRememberMyDecision(IPreferenceStore prefStore, String prefKey) {
        this.initializeToggleButton(Messages.DetailsDialog_RememberMyDecision, false, prefStore, prefKey);
    }

    public void initializeToggleButtonDontShowMeThisAgain(IPreferenceStore prefStore, String prefKey) {
        this.initializeToggleButton(Messages.DetailsDialog_DontShowMeThisAgain, false, prefStore, prefKey);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            this.setReturnCode(id);
            if (id == 0) {
                this.okPressed();
            } else if (id == 1) {
                this.cancelPressed();
            }
            this.close();
        }
    }

    protected void cancelPressed() {
    }

    protected void okPressed() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, helpContextId);
        }
    }

    protected Control createButtonBar(Composite parent) {
        if (this.toggleMessage != null) {
            this.toggleButton = new Button(parent, 32);
            this.toggleButton.setText(this.toggleMessage);
            this.toggleButton.setSelection(this.toggleState);
            this.toggleButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DetailsDialog.this.toggleState = DetailsDialog.this.toggleButton.getSelection();
                }
            });
            DetailsDialog.applyDialogFont((Control)this.toggleButton);
            GridDataFactory.defaultsFor((Control)this.toggleButton).indent(this.convertHorizontalDLUsToPixels(7), 0).applyTo((Control)this.toggleButton);
        }
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, -LayoutConstants.getSpacing().x, 0, 0).applyTo(composite);
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        Composite buttonSection = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonSection);
        this.createButtonsForButtonBar(buttonSection);
        GridDataFactory.defaultsFor((Control)buttonSection).grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)buttonSection);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        for (Map.Entry<Integer, String> entry : this.buttons.entrySet()) {
            Integer buttonId = entry.getKey();
            String label = entry.getValue();
            boolean setDefault = this.getDefaultButtonId() == buttonId.intValue();
            this.createButton(parent, buttonId, label, setDefault);
        }
        this.enableButtons();
        final Button defaultButton = this.getButton(this.getDefaultButtonId());
        defaultButton.setFocus();
        FocusListener resetFocus = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DetailsDialog.this.getShell().removeFocusListener((FocusListener)this);
                defaultButton.setFocus();
            }
        };
        this.getShell().addFocusListener(resetFocus);
    }

    protected void enableButtons() {
        for (Integer i : this.buttons.keySet()) {
            Button button = this.getButton(i);
            button.setEnabled(true);
        }
    }

    protected String getDetailsButtonLabelShow() {
        return IDialogConstants.SHOW_DETAILS_LABEL;
    }

    protected String getDetailsButtonLabelHide() {
        return IDialogConstants.HIDE_DETAILS_LABEL;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        GridDataFactory.defaultsFor((Control)this.dialogArea).align(4, 4).grab(true, this.isMainGrabVertical()).applyTo(this.dialogArea);
        this.buttonBar = this.createButtonBar(composite);
        GridDataFactory.defaultsFor((Control)this.buttonBar).align(4, 0x1000008).grab(true, false).applyTo(this.buttonBar);
        DetailsDialog.applyDialogFont((Control)composite);
        GridDataFactory.defaultsFor((Control)composite).grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo(composite);
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, helpContextId);
        }
        return composite;
    }

    protected Image getImage() {
        if (this.getImageKey() > 0) {
            return this.getShell().getDisplay().getSystemImage(this.getImageKey());
        }
        return null;
    }

    protected int getImageKey() {
        return this.imageKey;
    }

    protected String getHelpContextId() {
        return null;
    }

    protected boolean isMainGrabVertical() {
        return true;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int numColumns = 0;
        Image image = this.getImage();
        if (image != null) {
            ++numColumns;
            Label imageLabel = new Label(composite, 0);
            image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(image);
            GridDataFactory.defaultsFor((Control)imageLabel).align(0x1000000, 1).applyTo((Control)imageLabel);
        }
        if (this.message != null) {
            ++numColumns;
            this.createWrappingLabel(composite, this.message);
        }
        Point spacing = LayoutConstants.getSpacing();
        GridLayoutFactory.fillDefaults().numColumns(numColumns).spacing(spacing.x * 2, spacing.y).generateLayout(composite);
        return composite;
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        return null;
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        Button detailsButton = this.getButton(13);
        if (this.isDetailsVisible()) {
            this.detailsComposite.dispose();
            this.detailsComposite = null;
            detailsButton.setText(this.getDetailsButtonLabelShow());
        } else {
            this.detailsComposite = this.createDropDownDialogArea((Composite)this.getContents());
            GridDataFactory.defaultsFor((Control)this.detailsComposite).align(4, 0x1000008).grab(true, false).applyTo((Control)this.detailsComposite);
            detailsButton.setText(this.getDetailsButtonLabelHide());
        }
        DetailsDialog.applyDialogFont((Control)this.getContents());
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected Label createWrappingLabel(Composite parent, String text) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        return label;
    }

    protected boolean isDetailsVisible() {
        return this.detailsComposite != null;
    }

    public int getDefaultButtonId() {
        return this.defaultButtonId;
    }

    public void setDefaultButtonId(int defaultButtonId) {
        this.defaultButtonId = defaultButtonId;
    }

    public boolean getToggleState() {
        return this.toggleState;
    }

    public int getLastButtonIdPreference() {
        if (this.prefStore != null && this.prefKey != null) {
            return this.prefStore.getInt(this.prefKey);
        }
        return -1;
    }

    public void savePreferenceIfToggled() {
        if (this.getToggleState() && this.prefStore != null && this.prefKey != null) {
            this.prefStore.setValue(this.prefKey, this.getReturnCode());
        }
    }

    public int openOrGetPreference(Display display) {
        int id = this.getLastButtonIdPreference();
        if (id != -1) {
            return id;
        }
        id = this.open(display);
        this.savePreferenceIfToggled();
        return id;
    }

    public int open(Display display) {
        if (Display.getCurrent() != display) {
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            final int[] code = new int[1];
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    code[0] = DetailsDialog.this.open();
                }
            });
            return code[0];
        }
        return this.open();
    }

    public void openAsync(Display display) {
        SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                DetailsDialog.this.open();
            }
        });
    }

    public static enum ButtonBar {
        Ok,
        OkCancel,
        OkDetails,
        OkCancelDetails,
        YesNoDetails;

    }
}

