/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.dialogs;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.BrowsableFilenameField;
import com.ibm.team.repository.rcp.ui.internal.databinding.CombinedStatus;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.Preferences;

public class ClipboardOrFilePart {
    private static final String RADIO_SELECTION = "radioSelection";
    public static final int CLIPBOARD_SELECTION = 0;
    public static final int FILE_SELECTION = 1;
    private CombinedStatus validationStatus;
    private ClipboardOrFilePartInput input;
    private int intRadioSelection;
    private WritableValue radioSelection;
    private String filename;
    private BrowsableFilenameField filenameField;

    public ClipboardOrFilePart(ClipboardOrFilePartInput input) {
        this.input = input;
    }

    public BrowsableFilenameField getBrowseableFilenameField() {
        return this.filenameField;
    }

    public IObservableValue getRadioSelection() {
        return this.radioSelection;
    }

    public void create(Composite composite, WidgetFactoryContext context) {
        Group group = new Group(composite, 0);
        final Button clipboardButton = new Button((Composite)group, 16);
        clipboardButton.setData((Object)0);
        Composite spacer = new Composite((Composite)group, 0);
        final Button fileButton = new Button((Composite)group, 16);
        fileButton.setData((Object)1);
        Preferences filenameNode = this.input.getPreferences().node("filename");
        BrowsableFilenameField.Type type = this.input.isSave() ? BrowsableFilenameField.Type.Save : BrowsableFilenameField.Type.Open;
        int flags = type == BrowsableFilenameField.Type.Save ? 448 : 64;
        this.filenameField = new BrowsableFilenameField((Composite)group, this.input.getBrowseString(), context, filenameNode, type, flags);
        this.radioSelection = new WritableValue(Realm.getDefault());
        this.validationStatus = new CombinedStatus();
        RadioSelectionListener selectionListener = new RadioSelectionListener(this.radioSelection);
        clipboardButton.addSelectionListener((SelectionListener)selectionListener);
        fileButton.addSelectionListener((SelectionListener)selectionListener);
        this.radioSelection.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ClipboardOrFilePart.this.intRadioSelection = (Integer)ClipboardOrFilePart.this.radioSelection.getValue();
                if (ClipboardOrFilePart.this.intRadioSelection == 0) {
                    clipboardButton.setSelection(true);
                    ClipboardOrFilePart.this.validationStatus.removeStatus(ClipboardOrFilePart.this.filenameField.getValidationStatus());
                    ClipboardOrFilePart.this.filenameField.setEnabled(false);
                } else {
                    fileButton.setSelection(true);
                    ClipboardOrFilePart.this.validationStatus.addStatus(ClipboardOrFilePart.this.filenameField.getValidationStatus());
                    ClipboardOrFilePart.this.filenameField.setEnabled(true);
                }
            }
        });
        this.filenameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClipboardOrFilePart.this.filename = ClipboardOrFilePart.this.filenameField.getText();
                if (ClipboardOrFilePart.this.filenameField.getText().length() > 0 && ClipboardOrFilePart.this.radioSelection.getValue() == fileButton) {
                    ClipboardOrFilePart.this.radioSelection.setValue((Object)1);
                }
            }
        });
        this.filenameField.setFilterExtensions(this.input.getFilterExtensions());
        this.filenameField.setFilterNames(this.input.getFilterNames());
        this.filename = this.filenameField.getText();
        group.setText(this.input.getTitle());
        clipboardButton.setText(Messages.ClipboardOrFilePart_CLIPBOARD);
        fileButton.setText(this.input.getFileString());
        int selection = this.input.getPreferences().getInt(RADIO_SELECTION, 0);
        if (selection == 1 && this.filenameField.getText().length() > 0) {
            this.radioSelection.setValue((Object)1);
        } else {
            this.radioSelection.setValue((Object)0);
        }
        GridDataFactory.defaultsFor((Control)clipboardButton).span(2, 1).applyTo((Control)spacer);
        Dialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(LayoutConstants.getMargins()).generateLayout((Composite)group);
    }

    public void savePreferences() {
        this.filenameField.addToHistory();
        this.input.getPreferences().putInt(RADIO_SELECTION, this.intRadioSelection);
    }

    public IObservableValue getValidationStatus() {
        return this.validationStatus;
    }

    public ClipboardOrFileResult getResult() {
        return new ClipboardOrFileResult(this.intRadioSelection == 0, this.filename);
    }

    public static class ClipboardOrFilePartInput {
        private String title;
        private Preferences preferences;
        private boolean save;
        private String[] filterExtensions;
        private String[] filterNames;
        private String fileString;
        private String browseString;

        public ClipboardOrFilePartInput(String title, String fileString, String browseString, Preferences preferences, boolean save, String[] filterExtensions, String[] filterNames) {
            if (title == null) {
                title = save ? Messages.ClipboardOrFilePart_SAVE_LOCATION : Messages.ClipboardOrFilePart_OPEN_LOCATION;
            }
            this.title = title;
            this.fileString = fileString;
            this.browseString = browseString;
            this.preferences = preferences;
            this.save = save;
            this.filterExtensions = filterExtensions;
            this.filterNames = filterNames;
        }

        public String getTitle() {
            return this.title;
        }

        public Preferences getPreferences() {
            return this.preferences;
        }

        public boolean isSave() {
            return this.save;
        }

        public String[] getFilterExtensions() {
            return this.filterExtensions;
        }

        public String[] getFilterNames() {
            return this.filterNames;
        }

        public String getFileString() {
            return this.fileString;
        }

        public String getBrowseString() {
            return this.browseString;
        }
    }

    public static class ClipboardOrFileResult {
        private boolean clipboard;
        private String filename;

        public ClipboardOrFileResult(boolean clipboard, String filename) {
            this.clipboard = clipboard;
            this.filename = filename;
        }

        public boolean isClipboard() {
            return this.clipboard;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean confirmOverwrite(Shell shell) {
            File file;
            if (!this.isClipboard() && (file = new File(this.getFilename())).exists()) {
                return MessageDialog.openConfirm((Shell)shell, (String)Messages.ClipboardOrFilePart_CONFIRM_OVERWRITE_TITLE, (String)NLS.bind((String)Messages.ClipboardOrFilePart_CONFIRM_OVERWRITE_MESSAGE, (Object)this.getFilename()));
            }
            return true;
        }

        public IStatus write(ByteArrayOutputStream out, final Display display) {
            if (out.size() == 0) {
                return FileSystemStatusUtil.getStatusFor((int)2, (String)Messages.ClipboardOrFilePart_NO_CONTENT_TO_WRITE);
            }
            if (this.isClipboard()) {
                final String string = out.toString();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Clipboard c = new Clipboard(display);
                        c.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                        c.dispose();
                    }
                });
            } else {
                FileOutputStream fileOutput = null;
                try {
                    try {
                        fileOutput = new FileOutputStream(this.getFilename());
                        out.writeTo(fileOutput);
                    }
                    catch (IOException e) {
                        IStatus iStatus = FileSystemStatusUtil.getStatusFor((Throwable)e);
                        if (fileOutput != null) {
                            try {
                                fileOutput.close();
                            }
                            catch (IOException e2) {
                                return FileSystemStatusUtil.getStatusFor((Throwable)e2);
                            }
                        }
                        return iStatus;
                    }
                }
                finally {
                    if (fileOutput != null) {
                        try {
                            fileOutput.close();
                        }
                        catch (IOException e) {
                            return FileSystemStatusUtil.getStatusFor((Throwable)e);
                        }
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static class RadioSelectionListener
    implements SelectionListener {
        private WritableValue radioSelection;

        public RadioSelectionListener(WritableValue radioSelection) {
            this.radioSelection = radioSelection;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object data = e.widget.getData();
            if (data != null && data instanceof Integer) {
                this.radioSelection.setValue(data);
            }
            e.doit = false;
        }
    }
}

