/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.core.internal.patches.Hunk;
import com.ibm.team.filesystem.rcp.ui.internal.compare.AbstractCompareEditorInput;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.actions.HunkTypedElement;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PatchCompareEditorInput
extends AbstractCompareEditorInput {
    private IShareable shareable;
    private Hunk hunk;

    public PatchCompareEditorInput(CompareConfiguration configuration, IShareable shareable, Hunk hunk) {
        super(configuration, false);
        this.shareable = shareable;
        this.hunk = hunk;
    }

    public String getTitle() {
        if (this.shareable != null) {
            return this.shareable.getLocalPath().getName();
        }
        return super.getTitle();
    }

    protected AbstractCompareEditorInput.TypedElementAndData computeLeft(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        ITypedElement element = this.createLeftElement(this.shareable, monitor);
        String label = element.getName();
        return new AbstractCompareEditorInput.TypedElementAndData(element, label, this.shareable);
    }

    protected AbstractCompareEditorInput.TypedElementAndData computeAncestor(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        ILocation filePath = this.shareable.getFullPath();
        HunkTypedElement element = new HunkTypedElement(filePath, this.hunk, false);
        return new AbstractCompareEditorInput.TypedElementAndData((ITypedElement)element, filePath.getName(), null);
    }

    protected AbstractCompareEditorInput.TypedElementAndData computeRight(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        ILocation filePath = this.shareable.getFullPath();
        HunkTypedElement element = new HunkTypedElement(filePath, this.hunk, true);
        String label = Messages.OpenHunkAction_1;
        return new AbstractCompareEditorInput.TypedElementAndData((ITypedElement)element, label, null);
    }

    protected ComparePropertiesState createFilePropertyState(AbstractCompareEditorInput.TypedElementAndData left, AbstractCompareEditorInput.TypedElementAndData right, AbstractCompareEditorInput.TypedElementAndData ancestor, IProgressMonitor monitor) throws FileSystemException {
        return ComparePropertiesState.getEmptyComparison();
    }
}

