/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.calm.client;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.ConnectProjectAreasAction;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProjectAreaPicker {
    private static ConnectedProjectAreaRegistry fgRegistry = ConnectedProjectAreaRegistry.getDefault();
    public static Comparator<IProjectAreaHandle> fgProjectAreaComparator = new Comparator<IProjectAreaHandle>(){

        @Override
        public int compare(IProjectAreaHandle o1, IProjectAreaHandle o2) {
            String name1 = fgRegistry.getProjectAreaName(o1);
            if (name1 == null) {
                return 1;
            }
            String name2 = fgRegistry.getProjectAreaName(o2);
            if (name2 == null) {
                return -1;
            }
            int res = name1.compareTo(name2);
            if (res == 0) {
                String repoName1 = ((ITeamRepository)o1.getOrigin()).getName();
                if (repoName1 == null) {
                    return 1;
                }
                String repoName2 = ((ITeamRepository)o2.getOrigin()).getName();
                if (repoName2 == null) {
                    return -1;
                }
                res = repoName1.compareTo(repoName2);
            }
            return res;
        }
    };

    public static IProjectAreaHandle showDialog(Shell shell, boolean showLoggedOut) {
        return ProjectAreaPicker.showDialog(shell, showLoggedOut, true);
    }

    public static IProjectAreaHandle showDialog(Shell shell, boolean showLoggedOut, boolean confirmConnectionDialog) {
        List<IProjectAreaHandle> projectAreas = ProjectAreaPicker.getAllConnectedProjectAreas(showLoggedOut);
        if (projectAreas.isEmpty()) {
            new ConnectProjectAreasAction().run();
            projectAreas = ProjectAreaPicker.getAllConnectedProjectAreas(true);
            if (projectAreas.isEmpty()) {
                return null;
            }
        }
        return ProjectAreaPicker.showDialog(shell, projectAreas);
    }

    public static IProjectAreaHandle showDialog(Shell shell, List<IProjectAreaHandle> projectAreas) {
        Collections.sort(projectAreas, fgProjectAreaComparator);
        if (projectAreas.isEmpty()) {
            return null;
        }
        if (projectAreas.size() == 1) {
            return projectAreas.get(0);
        }
        ProjectAreaLabelProvider labelProvider = new ProjectAreaLabelProvider(projectAreas);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setElements(projectAreas.toArray());
        dialog.open();
        IProjectAreaHandle result = (IProjectAreaHandle)dialog.getFirstResult();
        labelProvider.dispose();
        return result;
    }

    public static String getUnambiguousProjectName(List<IProjectAreaHandle> areas, IProjectAreaHandle projectArea) {
        if (projectArea == null) {
            return "";
        }
        ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
        String repositoryName = repository.getName();
        String result = null;
        String projectAreaName = fgRegistry.getProjectAreaName(projectArea);
        if (projectAreaName == null) {
            if (projectArea instanceof IProjectArea && ((IProjectArea)projectArea).isPropertySet("name")) {
                projectAreaName = ((IProjectArea)projectArea).getName();
            }
            if (projectAreaName == null) {
                return "";
            }
        }
        for (IProjectAreaHandle pro : areas) {
            String proName = fgRegistry.getProjectAreaName(pro);
            if (proName == null || pro.sameItemId((IItemHandle)projectArea) || !proName.equalsIgnoreCase(projectAreaName)) continue;
            if (repositoryName == null || repositoryName.equals("")) {
                result = repository.getRepositoryURI();
                break;
            }
            String repName = ((ITeamRepository)pro.getOrigin()).getName();
            if (repName != null && repName.equalsIgnoreCase(repositoryName)) {
                result = repository.getRepositoryURI();
                break;
            }
            result = repositoryName;
        }
        if (result == null) {
            return projectAreaName;
        }
        return NLS.bind((String)Messages.ProjectAreaPicker_PROJECT_AREA_AND_REPOSITORY, (Object)projectAreaName, (Object[])new Object[]{result});
    }

    public static List<IProjectAreaHandle> getAllConnectedProjectAreas(boolean includeLoggedOut) {
        ArrayList<IProjectAreaHandle> areas = new ArrayList<IProjectAreaHandle>();
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            if (includeLoggedOut || teamRepository.loggedIn()) {
                areas.addAll(fgRegistry.getConnectedProjectAreas(teamRepository));
            }
            ++n2;
        }
        return areas;
    }

    public static class ProjectAreaLabelProvider
    extends TypeLabelProvider {
        private List<IProjectAreaHandle> fProjectAreas;
        private final StandardLabelProvider fLabelProvider;

        public ProjectAreaLabelProvider(List<IProjectAreaHandle> projectAreas) {
            this.fProjectAreas = projectAreas;
            this.fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        }

        public void setProjectAreas(List<IProjectAreaHandle> projectAreas) {
            this.fProjectAreas = projectAreas;
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IProjectAreaHandle) {
                IProjectAreaHandle projectArea = (IProjectAreaHandle)element;
                label.setText(ProjectAreaPicker.getUnambiguousProjectName(this.fProjectAreas, projectArea));
                label.setImage(this.fLabelProvider.getImage(element));
            }
        }

        public void dispose() {
            this.fLabelProvider.dispose();
            super.dispose();
        }
    }
}

