/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.team;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.team.LockContributorPlaceAction;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.UnlockConfirmationHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import org.eclipse.core.runtime.IProgressMonitor;

public class UnlockContributorPlaceAction
extends LockContributorPlaceAction {
    @Override
    protected void promptAndPerform(AbstractLockOperation operation, IWorkspaceConnection workspace, IWorkspaceConnection stream, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (stream != null) {
            String dialogTitle = Messages.UnlockContributorPlaceAction_lock_stream_title;
            String dialogMessage = NLS.bind((String)Messages.UnlockContributorPlaceAction_lock_stream_message, (Object)stream.getName(), (Object[])new Object[0]);
            boolean performOperation = DialogUtil.openConfirm(this.getContext().getShell(), dialogTitle, dialogMessage, true);
            if (performOperation) {
                operation.run(monitor);
            }
        } else {
            String dialogTitle = Messages.UnlockContributorPlaceAction_no_flow_target_title;
            String dialogMessage = NLS.bind((String)Messages.UnlockContributorPlaceAction_no_flow_target_message, (Object)workspace.getName(), (Object[])new Object[0]);
            DialogUtil.openError(this.getContext().getShell(), dialogTitle, dialogMessage);
        }
    }

    @Override
    protected String getOperationName() {
        return Messages.UnlockContributorPlaceAction_operation_name;
    }

    @Override
    protected AbstractLockOperation getOperation() {
        return (AbstractLockOperation)IOperationFactory.instance.getUnlockOperation((LockDilemmaHandler)new UnlockConfirmationHandler());
    }

    @Override
    protected AbstractLockOperation addStream(AbstractLockOperation operation, IWorkspaceConnection connection) {
        ((UnlockOperation)operation).unlock(connection);
        return operation;
    }
}

