/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.team;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.IUnlockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.AbstractSearchAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.SearchForLocksAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.team.LockAction;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.UnlockConfirmationHandler;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockEntry;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchView;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class UnlockAction
extends LockAction {
    @Override
    protected String getOperationName() {
        return Messages.LockUnlockAction_0;
    }

    public static void enqueueUnlockOperation(IOperationRunner runner, Map<ITeamRepository, List<LockEntry>> repoBatch, UIContext context) {
        UnlockAction.enqueueUnlockOperation(runner, null, repoBatch, context);
    }

    public static void enqueueUnlockOperation(IOperationRunner runner, final IWorkspaceConnection sourceConnection, final Map<ITeamRepository, List<LockEntry>> repoBatch, final UIContext context) {
        runner.enqueue(Messages.LockUnlockAction_0, (Operation)new RepositoryOperation(repoBatch.keySet()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LockUnlockAction_0, (int)100);
                IUnlockOperation unlockOperation = IOperationFactory.instance.getUnlockOperation((LockDilemmaHandler)new UnlockConfirmationHandler());
                SubMonitor sub2 = sub.newChild(10).setWorkRemaining(repoBatch.size());
                LockSearchCriteria criteria = null;
                for (Map.Entry mapEntry : repoBatch.entrySet()) {
                    List lockEntries = (List)mapEntry.getValue();
                    SubMonitor sub3 = sub2.newChild(1).setWorkRemaining(lockEntries.size());
                    for (LockEntry lockEntry : lockEntries) {
                        unlockOperation.unlock(sourceConnection, lockEntry.getWorkspaceConnection((IProgressMonitor)sub3.newChild(1)), lockEntry.getComponent(), lockEntry.getVersionable(), lockEntry.getContributor());
                        if (criteria != null) continue;
                        criteria = lockEntry.getLockSearchCriteria();
                    }
                }
                unlockOperation.run((IProgressMonitor)sub.newChild(90));
                if (context != null && criteria != null) {
                    AbstractSearchAction.openSearch(context, SearchForLocksAction.ARGS.searchViewImage, criteria, LockSearchView.class);
                }
            }
        });
    }

    @Override
    public LockAction.LockOperationVisitor newLockOperationVisitor(IWorkspaceConnection sourceConnection, List<IWorkspaceConnection> connections) {
        return new UnlockOperationVisitor(sourceConnection, connections, this.getOperationRunner());
    }

    public static class UnlockOperationVisitor
    extends LockAction.LockOperationVisitor {
        private IOperationRunner runner;

        public UnlockOperationVisitor(IWorkspaceConnection sourceConnection, List<IWorkspaceConnection> connections, IOperationRunner runner) {
            super(sourceConnection, connections);
            this.runner = runner;
        }

        @Override
        public IStatus visitAndRun(Object[] selection, UIContext context, IProgressMonitor monitor) throws FileSystemException {
            ArrayList<LockEntry> locks = new ArrayList<LockEntry>();
            final Realm[] realm = new Realm[1];
            context.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    realm[0] = Realm.getDefault();
                }
            });
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selection.length);
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                IShareable shareable;
                Object o = objectArray[n2];
                if (o != null && Adapters.hasAdapter((Object)o, IShareable.class) && (shareable = (IShareable)Adapters.getAdapter((Object)o, IShareable.class)) != null) {
                    SubMonitor iterMon = progress.newChild(1).setWorkRemaining(this.getWorkspaceConnections().size() + 1);
                    IShare share = shareable.getShare((IProgressMonitor)iterMon.newChild(1));
                    for (IWorkspaceConnection connection : this.getWorkspaceConnections()) {
                        ITeamRepository repo = connection.teamRepository();
                        if (!connection.isStream()) continue;
                        LockEntry lockEntry = new LockEntry(realm[0], null, repo, (IWorkspaceHandle)connection.getResolvedWorkspace(), share.getSharingDescriptor().getComponent(), shareable.getVersionable((IProgressMonitor)iterMon.newChild(1)), null);
                        locks.add(lockEntry);
                    }
                }
                ++n2;
            }
            Map<ITeamRepository, List<LockEntry>> repoBatch = LockEntry.getLockEntriesBatchedByRepo(locks);
            UnlockAction.enqueueUnlockOperation(this.runner, this.getSourceWorkspaceConnection(), repoBatch, null);
            return Status.OK_STATUS;
        }
    }
}

