/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.team;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.team.WorkspaceComponentAction;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LockConfirmationHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LockTeamPlaceComponentAction
extends WorkspaceComponentAction {
    protected List<TeamPlaceComponentWrapper> teamPlaceComponentWrappers = new ArrayList<TeamPlaceComponentWrapper>();
    protected IWorkspaceConnection stream = null;
    protected boolean atLeastOneLocked = false;

    public void selectionChanged(IAction action, ISelection selection) {
        this.clearState();
        super.selectionChanged(action, selection);
        for (Object object : this.getStructuredSelection().toList()) {
            if (!(object instanceof TeamPlaceComponentWrapper)) continue;
            TeamPlaceComponentWrapper wrapper = (TeamPlaceComponentWrapper)object;
            if (this.stream == null || this.stream.equals((Object)wrapper.getWorkspaceConnection())) {
                this.stream = wrapper.getWorkspaceConnection();
                this.teamPlaceComponentWrappers.add(wrapper);
                if (!wrapper.isLocked()) continue;
                this.atLeastOneLocked = true;
                continue;
            }
            this.clearState();
            break;
        }
        action.setEnabled(this.isEnabled());
    }

    private void clearState() {
        this.stream = null;
        this.teamPlaceComponentWrappers.clear();
        this.atLeastOneLocked = false;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(this.stream.teamRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                AbstractLockOperation operation = LockTeamPlaceComponentAction.this.getOperation();
                for (TeamPlaceComponentWrapper wrapper : LockTeamPlaceComponentAction.this.teamPlaceComponentWrappers) {
                    LockTeamPlaceComponentAction.this.addComponent(operation, LockTeamPlaceComponentAction.this.stream, wrapper.getComponentHandle());
                }
                operation.run(monitor);
            }
        });
    }

    protected String getOperationName() {
        return Messages.LockTeamPlaceComponentAction_operation_name;
    }

    protected AbstractLockOperation getOperation() {
        return (AbstractLockOperation)IOperationFactory.instance.getLockOperation((LockDilemmaHandler)new LockConfirmationHandler());
    }

    @Override
    protected AbstractLockOperation basicAddComponent(AbstractLockOperation operation, IWorkspaceConnection connection, IComponentHandle component) {
        ((LockOperation)operation).lock(connection, component);
        return operation;
    }

    protected boolean isEnabled() {
        return !this.teamPlaceComponentWrappers.isEmpty();
    }
}

