/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.team;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LockConfirmationHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LockTeamPlaceAction
extends AbstractActionDelegate {
    protected List<TeamPlaceWrapper> teamPlaceWrappers = new ArrayList<TeamPlaceWrapper>();
    protected ITeamRepository repository = null;
    protected boolean atLeastOneLocked = false;

    public void selectionChanged(IAction action, ISelection selection) {
        this.clearState();
        super.selectionChanged(action, selection);
        for (Object object : this.getStructuredSelection().toList()) {
            if (!(object instanceof TeamPlaceWrapper)) continue;
            TeamPlaceWrapper wrapper = (TeamPlaceWrapper)((Object)object);
            if (this.repository == null || this.repository.equals(wrapper.getRepository())) {
                this.repository = wrapper.getRepository();
                wrapper.getContextName();
                this.teamPlaceWrappers.add(wrapper);
                if (!wrapper.isLocked()) continue;
                this.atLeastOneLocked = true;
                continue;
            }
            this.clearState();
            break;
        }
        action.setEnabled(this.isEnabled());
    }

    private void clearState() {
        this.repository = null;
        this.teamPlaceWrappers.clear();
        this.atLeastOneLocked = false;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(this.repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                AbstractLockOperation operation = LockTeamPlaceAction.this.getOperation();
                SubMonitor loopProgress = progress.newChild(5).setWorkRemaining(LockTeamPlaceAction.this.teamPlaceWrappers.size());
                for (TeamPlaceWrapper wrapper : LockTeamPlaceAction.this.teamPlaceWrappers) {
                    try {
                        IWorkspaceConnection connection = wrapper.getWorkspaceConnection((IProgressMonitor)loopProgress.newChild(1));
                        LockTeamPlaceAction.this.addConnection(operation, connection);
                    }
                    catch (TeamRepositoryException e) {
                        problems.reportException((Throwable)e);
                    }
                }
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                operation.run((IProgressMonitor)progress.newChild(95));
            }
        });
    }

    protected String getOperationName() {
        return Messages.LockTeamPlaceAction_operation_name;
    }

    protected AbstractLockOperation getOperation() {
        return (AbstractLockOperation)IOperationFactory.instance.getLockOperation((LockDilemmaHandler)new LockConfirmationHandler());
    }

    protected AbstractLockOperation addConnection(AbstractLockOperation operation, IWorkspaceConnection connection) {
        ((LockOperation)operation).lock(connection);
        return operation;
    }

    protected boolean isEnabled() {
        return !this.teamPlaceWrappers.isEmpty();
    }
}

