/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.team;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.team.WorkspaceComponentAction;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LockConfirmationHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LockContributorPlaceComponentAction
extends WorkspaceComponentAction {
    protected List<ContributorPlaceComponentWrapper> contributorPlaceComponentwrappers = new ArrayList<ContributorPlaceComponentWrapper>();
    protected IWorkspaceConnection workspaceConnection = null;

    public void selectionChanged(IAction action, ISelection selection) {
        this.clearState();
        super.selectionChanged(action, selection);
        for (Object object : this.getStructuredSelection().toList()) {
            if (!(object instanceof ContributorPlaceComponentWrapper)) continue;
            ContributorPlaceComponentWrapper wrapper = (ContributorPlaceComponentWrapper)object;
            if (this.workspaceConnection == null || this.workspaceConnection.equals((Object)wrapper.getWorkspaceConnection())) {
                this.workspaceConnection = wrapper.getWorkspaceConnection();
                this.contributorPlaceComponentwrappers.add(wrapper);
                continue;
            }
            this.clearState();
            break;
        }
        action.setEnabled(this.isEnabled());
    }

    private void clearState() {
        this.workspaceConnection = null;
        this.contributorPlaceComponentwrappers.clear();
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(this.workspaceConnection.teamRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IWorkspaceConnection flowTarget = null;
                AbstractLockOperation operation = LockContributorPlaceComponentAction.this.getOperation();
                IFlowEntry flowEntry = LockContributorPlaceComponentAction.this.workspaceConnection.getFlowTable().getCurrentDeliverFlow();
                if (flowEntry != null && flowEntry.getFlowNode() instanceof IWorkspaceHandle) {
                    IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)LockContributorPlaceComponentAction.this.workspaceConnection.teamRepository());
                    flowTarget = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)flowEntry.getFlowNode(), (IProgressMonitor)progress.newChild(5));
                    if (!flowTarget.isStream()) {
                        String dialogTitle = operation instanceof LockOperation ? Messages.LockContributoPlaceComponentAction_no_flow_target_title : Messages.UnlockContributoPlaceComponentAction_no_flow_target_title;
                        String dialogMessage = NLS.bind((String)(operation instanceof LockOperation ? Messages.LockContributorPlaceAction_flow_target_not_stream : Messages.UnlockContributorPlaceAction_flow_target_not_stream), (Object)flowTarget.getName(), (Object[])new Object[0]);
                        DialogUtil.openError(LockContributorPlaceComponentAction.this.getContext().getShell(), dialogTitle, dialogMessage);
                        return;
                    }
                    for (ContributorPlaceComponentWrapper wrapper : LockContributorPlaceComponentAction.this.contributorPlaceComponentwrappers) {
                        LockContributorPlaceComponentAction.this.addComponent(operation, flowTarget, wrapper.getComponentHandle());
                    }
                }
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                LockContributorPlaceComponentAction.this.promptAndPerform(operation, flowTarget, (IProgressMonitor)progress.newChild(95));
            }
        });
    }

    protected void promptAndPerform(AbstractLockOperation operation, IWorkspaceConnection stream, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (stream != null) {
            String dialogTitle = Messages.LockContributorPlaceComponentAction_lock_component_title;
            String dialogMessage = NLS.bind((String)Messages.LockContributorPlaceComponentAction_lock_stream_message, (Object)stream.getName(), (Object[])new Object[0]);
            boolean performOperation = DialogUtil.openConfirm(this.getContext().getShell(), dialogTitle, dialogMessage, true);
            if (performOperation) {
                operation.run(monitor);
            }
        } else {
            String dialogTitle = Messages.LockContributoPlaceComponentAction_no_flow_target_title;
            String dialogMessage = NLS.bind((String)Messages.LockContributorPlaceComponentAction_no_flow_target_message, (Object)this.workspaceConnection.getName(), (Object[])new Object[0]);
            DialogUtil.openError(this.getContext().getShell(), dialogTitle, dialogMessage);
        }
    }

    protected String getOperationName() {
        return Messages.LockContributorPlaceComponentAction_operation_name;
    }

    protected AbstractLockOperation getOperation() {
        return (AbstractLockOperation)IOperationFactory.instance.getLockOperation((LockDilemmaHandler)new LockConfirmationHandler());
    }

    @Override
    protected AbstractLockOperation basicAddComponent(AbstractLockOperation operation, IWorkspaceConnection connection, IComponentHandle component) {
        ((LockOperation)operation).lock(connection, component);
        return operation;
    }

    protected boolean isEnabled() {
        return !this.contributorPlaceComponentwrappers.isEmpty();
    }
}

