/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.team;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LockConfirmationHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LockContributorPlaceAction
extends AbstractActionDelegate {
    protected List<ContributorPlaceWrapper> contributorPlaceWrappers = new ArrayList<ContributorPlaceWrapper>();

    public void selectionChanged(IAction action, ISelection selection) {
        this.clearState();
        super.selectionChanged(action, selection);
        for (Object object : this.getStructuredSelection().toList()) {
            if (!(object instanceof ContributorPlaceWrapper)) continue;
            ContributorPlaceWrapper wrapper = (ContributorPlaceWrapper)((Object)object);
            this.contributorPlaceWrappers.add(wrapper);
        }
        action.setEnabled(this.isEnabled());
    }

    private void clearState() {
        this.contributorPlaceWrappers.clear();
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        this.getOperationRunner().enqueue(this.getOperationName(), (Operation)new RepositoryOperation(this.contributorPlaceWrappers.get(0).getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (LockContributorPlaceAction.this.contributorPlaceWrappers.size() == 1) {
                    ContributorPlaceWrapper wrapper = LockContributorPlaceAction.this.contributorPlaceWrappers.get(0);
                    AbstractLockOperation operation = LockContributorPlaceAction.this.getOperation();
                    try {
                        IWorkspaceConnection flowTarget = null;
                        IWorkspaceConnection connection = wrapper.getWorkspaceConnection((IProgressMonitor)progress.newChild(5));
                        IFlowEntry flowEntry = connection.getFlowTable().getCurrentDeliverFlow();
                        if (flowEntry != null && flowEntry.getFlowNode() instanceof IWorkspaceHandle) {
                            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
                            flowTarget = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)flowEntry.getFlowNode(), (IProgressMonitor)progress.newChild(5));
                            LockContributorPlaceAction.this.addStream(operation, flowTarget);
                        }
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        LockContributorPlaceAction.this.promptAndPerform(operation, connection, flowTarget, (IProgressMonitor)progress.newChild(90));
                    }
                    catch (TeamRepositoryException e) {
                        problems.reportException((Throwable)e);
                    }
                }
            }
        });
    }

    protected void promptAndPerform(AbstractLockOperation operation, IWorkspaceConnection workspace, IWorkspaceConnection stream, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (stream != null) {
            String dialogTitle = Messages.LockContributorPlaceAction_lock_stream_title;
            String dialogMessage = NLS.bind((String)Messages.LockContributorPlaceAction_lock_stream_message, (Object)stream.getName(), (Object[])new Object[0]);
            boolean performOperation = DialogUtil.openConfirm(this.getContext().getShell(), dialogTitle, dialogMessage, true);
            if (performOperation) {
                operation.run(monitor);
            }
        } else {
            String dialogTitle = Messages.LockContributorPlaceAction_no_flow_target_title;
            String dialogMessage = NLS.bind((String)Messages.LockContributorPlaceAction_no_flow_target_message, (Object)workspace.getName(), (Object[])new Object[0]);
            DialogUtil.openError(this.getContext().getShell(), dialogTitle, dialogMessage);
        }
    }

    protected String getOperationName() {
        return Messages.LockContributorPlaceAction_operation_name;
    }

    protected AbstractLockOperation getOperation() {
        return (AbstractLockOperation)IOperationFactory.instance.getLockOperation((LockDilemmaHandler)new LockConfirmationHandler());
    }

    protected AbstractLockOperation addStream(AbstractLockOperation operation, IWorkspaceConnection stream) {
        ((LockOperation)operation).lock(stream);
        return operation;
    }

    protected boolean isEnabled() {
        return this.contributorPlaceWrappers.size() == 1;
    }
}

