/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.team;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockDialog;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockDialogInput;
import com.ibm.team.filesystem.ide.ui.internal.dialogs.lock.LockDialogResult;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.actions.teamplace.CommonAction;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LockConfirmationHandlerForVersionable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LockAction
extends CommonAction {
    @Override
    protected String getOperationName() {
        return Messages.LockAction_0;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List<IWorkspaceHandle> workspaceListFromSelection = LockAction.getWorkspaceListFromSelection(selection);
        HashMap<UUID, IWorkspaceHandle> handles = new HashMap<UUID, IWorkspaceHandle>();
        for (IWorkspaceHandle handle : workspaceListFromSelection) {
            handles.put(handle.getItemId(), handle);
        }
        if (handles.size() > 1) {
            JFaceUtils.showMessage((String)Messages.LockAction_1, (String)Messages.LockAction_2, (int)1);
            return;
        }
        if (handles.size() == 0) {
            JFaceUtils.showMessage((String)Messages.LockAction_1, (String)Messages.LockAction_5, (int)1);
            return;
        }
        this.runOnSelection(selection, new CommonAction.TeamPlaceRunnable(){

            @Override
            public IStatus run(IWorkspaceConnection teamPlace, Object[] selection, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
                final ITeamRepository repo = teamPlace.teamRepository();
                final ArrayList<IWorkspaceConnection> initialShown = new ArrayList<IWorkspaceConnection>();
                IWorkspaceConnection[] allCollaborations = FlowTableUtil.getAllAccessibleCollaborations((IWorkspaceConnection)teamPlace, (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)progress);
                int i = 0;
                while (i < allCollaborations.length) {
                    IWorkspaceConnection workspaceConnection = allCollaborations[i];
                    if (workspaceConnection != null && workspaceConnection.isStream()) {
                        initialShown.add(workspaceConnection);
                    }
                    ++i;
                }
                int initialSelectionCount = 0;
                IFlowEntry currentDeliverFlow = teamPlace.getFlowTable().getCurrentDeliverFlow();
                IWorkspaceHandle deliverFlowHandle = null;
                if (currentDeliverFlow != null) {
                    deliverFlowHandle = (IWorkspaceHandle)currentDeliverFlow.getFlowNode();
                    ++initialSelectionCount;
                }
                IFlowEntry defaultDeliverFlow = teamPlace.getFlowTable().getDefaultDeliverFlow();
                IWorkspaceHandle defaultFlowHandle = null;
                if (defaultDeliverFlow != null) {
                    defaultFlowHandle = (IWorkspaceHandle)defaultDeliverFlow.getFlowNode();
                    if (deliverFlowHandle != null && !deliverFlowHandle.sameItemId((IItemHandle)defaultFlowHandle)) {
                        ++initialSelectionCount;
                    }
                }
                final ArrayList<IWorkspace> initialSelection = new ArrayList<IWorkspace>();
                IWorkspace firstInitialSelection = null;
                int i2 = 0;
                while (i2 < allCollaborations.length) {
                    IWorkspaceConnection workspaceConnection = allCollaborations[i2];
                    if (workspaceConnection != null && workspaceConnection.isStream()) {
                        IWorkspace workspace = workspaceConnection.getResolvedWorkspace();
                        if (firstInitialSelection == null) {
                            firstInitialSelection = workspace;
                        }
                        if (deliverFlowHandle != null && deliverFlowHandle.sameItemId((IItemHandle)workspace)) {
                            initialSelection.add(workspace);
                        } else if (defaultFlowHandle != null && defaultFlowHandle.sameItemId((IItemHandle)workspace)) {
                            initialSelection.add(workspace);
                        }
                        if (initialSelectionCount == initialSelection.size()) break;
                    }
                    ++i2;
                }
                if (initialSelection.isEmpty() && firstInitialSelection != null) {
                    initialSelection.add(firstInitialSelection);
                }
                final LockDialogResult[] result = new LockDialogResult[1];
                LockAction.this.getContext().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        LockDialogInput input = new LockDialogInput(repo, initialShown, initialSelection, ((Object)((Object)LockAction.this)).getClass() == LockAction.class, null);
                        LockDialog dialog = new LockDialog(LockAction.this.getContext().getShell(), input);
                        if (dialog.open() == 0) {
                            MessageDialogWithToggle dialogOkCancel;
                            boolean prompt;
                            String actionTitle;
                            String actionMessage;
                            if (input.isLock()) {
                                actionMessage = Messages.LockStreamsMessage;
                                actionTitle = Messages.LockStreamsTitle;
                            } else {
                                actionMessage = Messages.UnlockStreamsMessage;
                                actionTitle = Messages.UnlockStreamsTitle;
                            }
                            boolean canceled = false;
                            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                            int numberOfStreams = dialog.getResult().getStreams().size();
                            if (numberOfStreams > 1 && (prompt = store.getBoolean("pref_prompt_streams_lock_unlock_dialog")) && (dialogOkCancel = MessageDialogWithToggle.openOkCancelConfirm((Shell)LockAction.this.getContext().getShell(), (String)actionTitle, (String)NLS.bind((String)actionMessage, (Object)numberOfStreams), (String)Messages.LockUnlockStreamsDontShow, (boolean)false, (IPreferenceStore)store, (String)"pref_prompt_streams_lock_unlock_dialog")).getReturnCode() == 1) {
                                canceled = true;
                            }
                            result[0] = canceled ? null : dialog.getResult();
                        }
                    }
                });
                if (result[0] == null) {
                    return Status.CANCEL_STATUS;
                }
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                ArrayList<IWorkspaceConnection> lockTargetConnections = new ArrayList<IWorkspaceConnection>();
                List<AbstractPlaceWrapper> targetStreams = result[0].getStreams();
                SubMonitor iterSub = sub.newChild(1).setWorkRemaining(targetStreams.size());
                for (AbstractPlaceWrapper stream : targetStreams) {
                    IWorkspaceConnection lockTargetConnection = stream.getWorkspaceConnection((IProgressMonitor)iterSub.newChild(1));
                    lockTargetConnections.add(lockTargetConnection);
                }
                LockOperationVisitor visitor = LockAction.this.newLockOperationVisitor(teamPlace, lockTargetConnections);
                return visitor.visitAndRun(selection, LockAction.this.getContext(), (IProgressMonitor)sub.newChild(99));
            }
        });
    }

    public LockOperationVisitor newLockOperationVisitor(IWorkspaceConnection sourceConnection, List<IWorkspaceConnection> connections) {
        return new LockOperationVisitor(sourceConnection, connections);
    }

    public static class LockOperationVisitor {
        private IWorkspaceConnection sourceConnection;
        private List<IWorkspaceConnection> lockTargetConnections;

        public LockOperationVisitor(IWorkspaceConnection sourceConnection, List<IWorkspaceConnection> lockTargetConnections) {
            this.sourceConnection = sourceConnection;
            this.lockTargetConnections = lockTargetConnections;
        }

        protected IWorkspaceConnection getSourceWorkspaceConnection() {
            return this.sourceConnection;
        }

        protected List<IWorkspaceConnection> getWorkspaceConnections() {
            return this.lockTargetConnections;
        }

        public IStatus visitAndRun(Object[] selection, UIContext context, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ILockOperation lockOperation = IOperationFactory.instance.getLockOperation((LockDilemmaHandler)new LockConfirmationHandlerForVersionable());
            SubMonitor subProgress = progress.newChild(1).setWorkRemaining(selection.length);
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                IShareable shareable;
                Object o = objectArray[n2];
                SubMonitor iterMon = subProgress.newChild(1).setWorkRemaining(100);
                if (o != null && Adapters.hasAdapter((Object)o, IShareable.class) && (shareable = (IShareable)Adapters.getAdapter((Object)o, IShareable.class)) != null) {
                    IShare share = shareable.getShare((IProgressMonitor)iterMon.newChild(50));
                    IVersionableHandle vh = shareable.getVersionable((IProgressMonitor)iterMon.newChild(50));
                    if (vh != null) {
                        for (IWorkspaceConnection lockTargetConnection : this.getWorkspaceConnections()) {
                            lockOperation.lock(this.sourceConnection, lockTargetConnection, share.getSharingDescriptor().getComponent(), vh);
                        }
                    }
                }
                ++n2;
            }
            lockOperation.run((IProgressMonitor)progress.newChild(99));
            return Status.OK_STATUS;
        }
    }
}

