/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.team;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.AccessControlPicker;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFileNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewSymbolicLinkNode;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroupHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ConfigureVersionableAccessControlAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.isEnabledFor(selection));
    }

    private boolean isEnabledFor(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            ITeamRepository singleRepository = null;
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object next : ss) {
                ITeamRepository repository = this.getRepository(next);
                if (repository == null) {
                    return false;
                }
                if (singleRepository == null) {
                    singleRepository = repository;
                    continue;
                }
                if (singleRepository.getId().equals((Object)repository.getId())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private ITeamRepository getRepository(Object object) {
        if (object instanceof AbstractFileSystemItemWrapper) {
            AbstractFileSystemItemWrapper w = (AbstractFileSystemItemWrapper)((Object)object);
            return w.getRepository();
        }
        if (object instanceof StructuralChangesViewFileNode) {
            StructuralChangesViewFileNode node = (StructuralChangesViewFileNode)object;
            return node.getNamespace().getRepository();
        }
        if (object instanceof StructuralChangesViewFolderNode) {
            StructuralChangesViewFolderNode node = (StructuralChangesViewFolderNode)object;
            return node.getNamespace().getRepository();
        }
        if (object instanceof StructuralChangesViewSymbolicLinkNode) {
            StructuralChangesViewSymbolicLinkNode node = (StructuralChangesViewSymbolicLinkNode)object;
            return node.getNamespace().getRepository();
        }
        AbstractFileSystemItemWrapper input = this.adapt(object);
        if (input != null) {
            return input.getRepository();
        }
        return null;
    }

    public void run(Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        final ITeamRepository repository = this.getTeamRepository(selection);
        final HashMap<ItemId<IComponent>, Set<ItemId>> versionableResult = new HashMap<ItemId<IComponent>, Set<ItemId>>();
        final AccessControlPicker.Access[] currentAccess = new AccessControlPicker.Access[1];
        final IAuditable[] scope = new IAuditable[1];
        if (!this.checkSelection(selection)) {
            JFaceUtils.showMessageBlocking((String)Messages.ConfigureVersionableAccessControlAction_inaccessibleSelectionTitle, (String)Messages.ConfigureVersionableAccessControlAction_inaccessibleSelectionMessage, (int)2);
            return;
        }
        ProgressMonitorDialog d = new ProgressMonitorDialog(shell);
        try {
            d.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        try {
                            Map versionablesByComponent = ConfigureVersionableAccessControlAction.this.getVersionablesByComponent(selection, (IProgressMonitor)progress.newChild(30));
                            versionableResult.putAll(versionablesByComponent);
                            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                            SubMonitor loopProgress = progress.newChild(70).setWorkRemaining(versionablesByComponent.size() * 2);
                            for (Map.Entry entry : versionablesByComponent.entrySet()) {
                                IComponentHandle componentHandle = (IComponentHandle)((ItemId)entry.getKey()).toHandle();
                                IVersionableHandle[] versionables = new IVersionableHandle[((Set)entry.getValue()).size()];
                                int i = 0;
                                for (ItemId versionable : (Set)entry.getValue()) {
                                    versionables[i++] = (IVersionableHandle)versionable.toHandle();
                                }
                                IVersionablePermissionsReport[] permissions = wm.getPermissions(versionables, componentHandle, (IProgressMonitor)loopProgress.newChild(1));
                                if (permissions.length == 0) {
                                    currentAccess[0] = AccessControlPicker.Access.COMPONENT;
                                } else if (permissions.length != 1 || permissions[0].getItemsIds().size() != versionables.length) {
                                    currentAccess[0] = null;
                                } else {
                                    IPermissionContextProvider context = permissions[0].getContext();
                                    IAuditableHandle readContext = null;
                                    if (context != null) {
                                        readContext = context.getReadContext();
                                    }
                                    if (readContext instanceof IContributorHandle) {
                                        currentAccess[0] = AccessControlPicker.Access.CONTRIBUTOR;
                                        scope[0] = (IAuditable)repository.itemManager().fetchCompleteItem((IItemHandle)readContext, 0, (IProgressMonitor)loopProgress.newChild(1));
                                    } else if (readContext instanceof IProcessAreaHandle) {
                                        currentAccess[0] = AccessControlPicker.Access.PROCESS_AREA;
                                        scope[0] = (IAuditable)repository.itemManager().fetchCompleteItem((IItemHandle)readContext, 0, (IProgressMonitor)loopProgress.newChild(1));
                                    } else {
                                        if (!(readContext instanceof IAccessGroupHandle)) continue;
                                        currentAccess[0] = AccessControlPicker.Access.ACCESS_GROUP;
                                        IAccessGroupClientService accessGroupService = (IAccessGroupClientService)repository.getClientLibrary(IAccessGroupClientService.class);
                                        scope[0] = accessGroupService.getAccessGroupForGroupContextId(readContext.getItemId(), (IProgressMonitor)progress.newChild(1));
                                    }
                                }
                                break;
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        progress.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UiPlugin.getDefault().getLog().log(StatusUtil.newStatus((Object)((Object)this), (int)2, (String)Messages.ConfigureVersionableAccessControlAction_cannotRetrievePermissionValue, (Throwable)e));
        }
        catch (InterruptedException e) {
            UiPlugin.getDefault().getLog().log(StatusUtil.newStatus((Object)((Object)this), (int)2, (String)Messages.ConfigureVersionableAccessControlAction_cannotRetrievePermissionValue, (Throwable)e));
        }
        PermissionParameter permissionParameter = this.promptForPermissionsContext(shell, repository, currentAccess[0], scope[0], versionableResult);
        IPermissionContextProvider provider = permissionParameter.getProvider();
        if (provider != null) {
            this.performSetPermissions(repository, versionableResult, permissionParameter.getProvider(), permissionParameter.isApplyToChildren());
        }
    }

    private boolean checkSelection(IStructuredSelection selection) {
        for (Object next : selection) {
            StructuralChangesViewNode node;
            if (next instanceof StructuralChangesViewFolderNode) {
                node = (StructuralChangesViewFolderNode)next;
                Set<FileChange> folderChanges = ((StructuralChangesViewFolderNode)node).getChangeFolder().getChanges();
                for (FileChange change : folderChanges) {
                    if (!change.getInitial().isDeleted() || !change.getFinal().isDeleted()) continue;
                    return false;
                }
                return true;
            }
            if (next instanceof StructuralChangesViewFileNode) {
                node = (StructuralChangesViewFileNode)next;
                FileChange change = ((StructuralChangesViewFileNode)node).getChange();
                return !change.getInitial().isDeleted() || !change.getFinal().isDeleted();
            }
            if (next instanceof StructuralChangesViewSymbolicLinkNode) {
                node = (StructuralChangesViewSymbolicLinkNode)next;
                FileChange change = ((StructuralChangesViewSymbolicLinkNode)node).getChange();
                return !change.getInitial().isDeleted() || !change.getFinal().isDeleted();
            }
            if (next instanceof AbstractFileSystemItemWrapper) {
                return true;
            }
            AbstractFileSystemItemWrapper input = this.adapt(next);
            if (input == null) continue;
            return true;
        }
        return false;
    }

    private ItemNamespace getNamespace(IStructuredSelection selection) {
        for (Object obj : selection) {
            AbstractFileSystemItemWrapper wrapper;
            if (obj instanceof FolderItemWrapper) {
                wrapper = (FolderItemWrapper)((Object)obj);
                return wrapper.getWorkspace();
            }
            if (obj instanceof StructuralChangesViewFolderNode) {
                StructuralChangesViewFolderNode node = (StructuralChangesViewFolderNode)obj;
                return node.getNamespace();
            }
            wrapper = this.adapt(obj);
            if (wrapper == null) continue;
            return wrapper.getWorkspace();
        }
        return null;
    }

    private PermissionParameter promptForPermissionsContext(Shell shell, ITeamRepository repository, AccessControlPicker.Access currentAccess, IAuditable scope, Map<ItemId<IComponent>, Set<ItemId>> selectedItems) {
        boolean containsFiles = false;
        boolean containsFolders = false;
        int itemCount = 0;
        if (selectedItems != null) {
            block0: for (Set<ItemId> items : selectedItems.values()) {
                if (items == null) continue;
                itemCount += items.size();
                for (ItemId item : items) {
                    if (containsFiles && containsFolders) continue block0;
                    if (item.getItemType() == IFolder.ITEM_TYPE) {
                        containsFolders = true;
                        continue;
                    }
                    containsFiles = true;
                }
            }
        }
        String dialogDescription = itemCount == 1 ? (containsFolders ? Messages.ConfigureVersionableAccessControlAction_DialogDescriptionForAFolder : NLS.bind((String)Messages.ConfigureVersionableAccessControlAction_DialogDescriptionForAFile, (Object)itemCount)) : (containsFiles && containsFolders ? NLS.bind((String)Messages.ConfigureVersionableAccessControlAction_DialogDescriptionForFilesAndFolders, (Object)itemCount) : (containsFolders ? NLS.bind((String)Messages.ConfigureVersionableAccessControlAction_DialogDescriptionForFolders, (Object)itemCount) : NLS.bind((String)Messages.ConfigureVersionableAccessControlAction_DialogDescriptionForFiles, (Object)itemCount)));
        AccessControlPicker picker = new AccessControlPicker(shell, repository, dialogDescription, containsFolders, currentAccess, this.getOperationRunner());
        picker.create();
        PermissionParameter permissionParameter = new PermissionParameter();
        if (scope != null) {
            picker.setScopeSelection(scope);
        }
        if (picker.open() == 0) {
            IPermissionContextProvider accessContext = picker.getAccessContext();
            if (accessContext == null) {
                accessContext = IPermissionContextProvider.FACTORY.createClear();
            }
            permissionParameter.setProvider(accessContext);
            permissionParameter.setApplyToChildren(picker.getApplyToChildren());
        }
        return permissionParameter;
    }

    private void performSetPermissions(final ITeamRepository repository, final Map<ItemId<IComponent>, Set<ItemId>> versionables, final IPermissionContextProvider context, boolean applyToFolders) {
        ItemNamespace namespace = null;
        if (applyToFolders) {
            namespace = this.getNamespace(this.getStructuredSelection());
        }
        final ItemNamespace namespaceParameter = namespace;
        this.getOperationRunner().enqueue(NLS.bind((String)Messages.ConfigureVersionableAccessControlAction_1, (Object)repository.getName()), new Operation(){

            public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        progress.setWorkRemaining(versionables.size());
                        IConnection connection = null;
                        if (namespaceParameter != null) {
                            connection = namespaceParameter.getConnection((IProgressMonitor)progress.newChild(1));
                        }
                        for (Map.Entry entry : versionables.entrySet()) {
                            IVersionableHandle[] versionables2 = new IVersionableHandle[((Set)entry.getValue()).size()];
                            int count = 0;
                            for (ItemId itemId : (Set)entry.getValue()) {
                                versionables2[count++] = (IVersionableHandle)itemId.toHandle();
                            }
                            if (connection == null) {
                                ConfigureVersionableAccessControlAction.this.performSetPermissions(repository, (ItemId<IComponent>)((ItemId)entry.getKey()), versionables2, context, progress.newChild(1));
                                continue;
                            }
                            ConfigureVersionableAccessControlAction.this.performSetPermissions(repository, (ItemId<IComponent>)((ItemId)entry.getKey()), versionables2, connection, context, progress.newChild(1));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private void performSetPermissions(ITeamRepository repository, ItemId<IComponent> componentId, IVersionableHandle[] versionables, IConnection connection, IPermissionContextProvider context, SubMonitor monitor) throws TeamRepositoryException {
        connection.setVersionablePermissions(versionables, (IComponentHandle)componentId.toHandle(), context, (IProgressMonitor)monitor);
    }

    private void performSetPermissions(ITeamRepository repository, ItemId<IComponent> componentId, IVersionableHandle[] versionables, IPermissionContextProvider context, SubMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
        manager.setPermissions(versionables, (IComponentHandle)componentId.toHandle(), context, (IProgressMonitor)monitor);
    }

    private ITeamRepository getTeamRepository(IStructuredSelection selection) {
        return this.getRepository(selection.getFirstElement());
    }

    private Map<ItemId<IComponent>, Set<ItemId>> getVersionablesByComponent(IStructuredSelection selection, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<ItemId<IComponent>, Set<ItemId>> versionables = new HashMap<ItemId<IComponent>, Set<ItemId>>();
        for (Object next : selection) {
            AbstractFileSystemItemWrapper input;
            StructuralChangesViewNode node;
            ItemNamespace namespace = null;
            ItemId itemId = null;
            if (next instanceof AbstractFileSystemItemWrapper) {
                AbstractFileSystemItemWrapper w = (AbstractFileSystemItemWrapper)((Object)next);
                namespace = w.getWorkspace();
                itemId = w.getFileItem().getItemId();
            } else if (next instanceof StructuralChangesViewFileNode) {
                node = (StructuralChangesViewFileNode)next;
                namespace = ((StructuralChangesViewFileNode)node).getNamespace();
                itemId = ((StructuralChangesViewFileNode)node).getChange().getItemId();
            } else if (next instanceof StructuralChangesViewFolderNode) {
                node = (StructuralChangesViewFolderNode)next;
                namespace = ((StructuralChangesViewFolderNode)node).getNamespace();
                itemId = ((StructuralChangesViewFolderNode)node).getChangeFolder().getPath().getItemId();
            } else if (next instanceof StructuralChangesViewSymbolicLinkNode) {
                node = (StructuralChangesViewSymbolicLinkNode)next;
                namespace = ((StructuralChangesViewSymbolicLinkNode)node).getNamespace();
                itemId = ((StructuralChangesViewSymbolicLinkNode)node).getChange().getItemId();
            } else if (next != null && (input = this.adapt(next)) != null) {
                namespace = input.getWorkspace();
                itemId = input.getItem();
            }
            if (namespace == null || itemId == null) continue;
            ItemId componentId = namespace.fetchComponentId(monitor);
            HashSet<ItemId> list = (HashSet<ItemId>)versionables.get(componentId);
            if (list == null) {
                list = new HashSet<ItemId>();
                versionables.put((ItemId<IComponent>)componentId, list);
            }
            list.add(itemId);
        }
        return versionables;
    }

    private AbstractFileSystemItemWrapper adapt(Object element) {
        IShareable shareable;
        if (element == null) {
            return null;
        }
        if (element instanceof IAdaptable && (shareable = (IShareable)((IAdaptable)element).getAdapter(IShareable.class)) != null) {
            try {
                return this.getWrapper(shareable, (IProgressMonitor)TempHelper.MONITOR);
            }
            catch (TeamRepositoryException e) {
                TempHelper.throwEx((TeamRepositoryException)e);
            }
        }
        return null;
    }

    private AbstractFileSystemItemWrapper getWrapper(IShareable shareable, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ITeamRepository repository;
            IVersionableHandle versionable = shareable.getRemote((IProgressMonitor)progress.newChild(50));
            if (versionable == null) {
                return null;
            }
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
            if (share == null) {
                return null;
            }
            ISharingDescriptor descr = share.getSharingDescriptor();
            try {
                repository = RepositoryUtils.getTeamRepository((ISharingDescriptor)descr);
            }
            catch (TeamRepositoryException e) {
                progress.done();
                return null;
            }
            StateId state = new StateId((IItemHandle)versionable);
            ItemNamespace namespace = CoreShareablesUtil.getNamespace((ITeamRepository)repository, (IContextHandle)descr.getConnectionHandle(), (IComponentHandle)descr.getComponent());
            Object t = AbstractFileSystemItemWrapper.newWrapper(state, shareable.getFullPath().toOSString(), namespace);
            return t;
        }
        finally {
            progress.done();
        }
    }

    private class PermissionParameter {
        private IPermissionContextProvider provider = null;
        private boolean applyToChildren = false;

        public IPermissionContextProvider getProvider() {
            return this.provider;
        }

        public void setProvider(IPermissionContextProvider provider) {
            this.provider = provider;
        }

        public boolean isApplyToChildren() {
            return this.applyToChildren;
        }

        public void setApplyToChildren(boolean applyToChildren) {
            this.applyToChildren = applyToChildren;
        }
    }
}

