/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.subcomponents;

import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.internal.operations.IUpdateSubcomponentOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.ui.wrapper.HierarchyData;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.MissingWorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RemoveAsSubcomponentAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        HierarchyData data;
        IHierarchicalComponentWrapper wrapper;
        Object elmement;
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        boolean actionEnabled = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).toList().size() == 1 && (elmement = ss.getFirstElement()) instanceof IHierarchicalComponentWrapper && !(wrapper = (IHierarchicalComponentWrapper)elmement).getWorkspace().isStream() && (data = wrapper.getHierarchyData()) != null && !data.getHierarchyNode().getAncestorPath().isEmpty()) {
            Object hierarcyNode = data.getHierarchyNode();
            List ancestorPath = hierarcyNode.getAncestorPath();
            UUID parentComponentUUID = (UUID)ancestorPath.get(ancestorPath.size() - 1);
            try {
                for (Object o : wrapper.getWorkspaceConnection().getComponents()) {
                    IComponentHandle componentInWorkspace;
                    if (!(o instanceof IComponentHandle) || !parentComponentUUID.equals((Object)(componentInWorkspace = (IComponentHandle)o).getItemId())) continue;
                    actionEnabled = true;
                    break;
                }
            }
            catch (Exception e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
        action.setEnabled(actionEnabled);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (!(selection.getFirstElement() instanceof IHierarchicalComponentWrapper)) {
            return;
        }
        final IHierarchicalComponentWrapper wrapper = (IHierarchicalComponentWrapper)selection.getFirstElement();
        final HierarchyData data = wrapper.getHierarchyData();
        if (wrapper.getWorkspace().isStream() || data == null || data.getHierarchyNode().getAncestorPath().isEmpty()) {
            return;
        }
        this.getOperationRunner().enqueue(Messages.RemoveAsSubcomponentAction_JOB_NAME, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IWorkspaceConnection workspace = wrapper.getWorkspaceConnection();
                IComponentHandle componentToRemove = wrapper.getComponentHandle();
                Object hierarcyNode = data.getHierarchyNode();
                List ancestorPath = hierarcyNode.getAncestorPath();
                UUID parentComponentUUID = (UUID)ancestorPath.get(ancestorPath.size() - 1);
                boolean toRemoveExistsInWorkspace = false;
                IComponentHandle parentComponentHandle = null;
                for (Object o : workspace.getComponents()) {
                    if (!(o instanceof IComponentHandle)) continue;
                    IComponentHandle handle = (IComponentHandle)o;
                    if (parentComponentUUID.equals((Object)handle.getItemId())) {
                        parentComponentHandle = handle;
                    }
                    if (componentToRemove.sameItemId((IItemHandle)handle)) {
                        toRemoveExistsInWorkspace = true;
                    }
                    if (parentComponentHandle != null && toRemoveExistsInWorkspace) break;
                }
                if (parentComponentHandle != null) {
                    String[] dialogButtons;
                    int returnCode;
                    String componentName = Messages.RemoveAsSubcomponentAction_INACCESSIBLE_COMPONENT;
                    String parentComponentName = Messages.RemoveAsSubcomponentAction_INACCESSIBLE_COMPONENT;
                    IFetchResult result = workspace.teamRepository().itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(componentToRemove, parentComponentHandle), 0, (IProgressMonitor)progress.newChild(50));
                    for (Object o : result.getRetrievedItems()) {
                        if (!(o instanceof IComponent)) continue;
                        IComponent c = (IComponent)o;
                        if (c.sameItemId((IItemHandle)componentToRemove)) {
                            componentName = c.getName();
                            continue;
                        }
                        if (!c.sameItemId((IItemHandle)parentComponentHandle)) continue;
                        parentComponentName = c.getName();
                    }
                    String dialogTitle = Messages.RemoveAsSubcomponentAction_CONFIRMATION_DIALOG_TITLE;
                    String dialogMessage = wrapper instanceof MissingWorkspaceComponentWrapper && ((MissingWorkspaceComponentWrapper)wrapper).getComponent() == null ? NLS.bind((String)Messages.RemoveAsSubcomponentAction_CONFIRMATION_DIALOG_DESCRIPTION_INACCESSIBLE, (Object)parentComponentName) : NLS.bind((String)Messages.RemoveAsSubcomponentAction_CONFIRMATION_DIALOG_DESCRIPTION, (Object)componentName, (Object)parentComponentName);
                    if (toRemoveExistsInWorkspace) {
                        dialogMessage = wrapper.getWorkspace().isStream() ? String.valueOf(dialogMessage) + Messages.RemoveAsSubcomponentAction_CONFIRMATION_DIALOG_DESCRIPTION_IN_STREAM : String.valueOf(dialogMessage) + Messages.RemoveAsSubcomponentAction_CONFIRMATION_DIALOG_DESCRIPTION_IN_WORKSPACE;
                    }
                    if ((returnCode = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])(dialogButtons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}), (int)3, (int)0, null)) == 0) {
                        IUpdateSubcomponentOperation operation = OperationFactory.getInstance().getUpdateSubcomponentOperation(UpdateDilemmaHandler.getDefault());
                        operation.removeSubcomponents(workspace, parentComponentHandle, Arrays.asList(componentToRemove), null);
                        operation.run((IProgressMonitor)progress.newChild(50));
                    }
                }
            }
        });
    }
}

