/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.subcomponents;

import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.internal.operations.IUpdateSubcomponentOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.filesystem.ui.wrapper.ComponentHierarchyData;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddSubcomponentAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        ComponentHierarchyData data;
        WorkspaceComponentWrapper wrapper;
        Object elmement;
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        boolean actionEnabled = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).toList().size() == 1 && (elmement = ss.getFirstElement()) instanceof WorkspaceComponentWrapper && !(wrapper = (WorkspaceComponentWrapper)elmement).getWorkspace().isStream() && (data = wrapper.getHierarchyData()) != null) {
            try {
                ArrayList<IComponentHandle> availableSubcomponents = new ArrayList<IComponentHandle>();
                boolean componentExistsInWorkspace = false;
                for (Object o : wrapper.getWorkspaceConnection().getComponents()) {
                    if (!(o instanceof IComponentHandle)) continue;
                    IComponentHandle componentInWorkspace = (IComponentHandle)o;
                    if (wrapper.getComponentHandle().sameItemId((IItemHandle)componentInWorkspace)) {
                        componentExistsInWorkspace = true;
                        continue;
                    }
                    availableSubcomponents.add(componentInWorkspace);
                }
                if (!availableSubcomponents.isEmpty() && componentExistsInWorkspace) {
                    actionEnabled = true;
                }
            }
            catch (Exception e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
        action.setEnabled(actionEnabled);
    }

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        if (!(selection.getFirstElement() instanceof WorkspaceComponentWrapper)) {
            return;
        }
        final WorkspaceComponentWrapper parentWrapper = (WorkspaceComponentWrapper)selection.getFirstElement();
        final IWorkspaceConnection workspaceConnection = parentWrapper.getWorkspaceConnection();
        if (workspaceConnection.isStream() || parentWrapper.getHierarchyData() == null) {
            return;
        }
        this.getOperationRunner().enqueue(Messages.AddSubcomponentAction_PICK_SUBCOMPONENT_JOB_NAME, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                ArrayList<IComponentHandle> componentHandlesInWorkspace = new ArrayList<IComponentHandle>();
                for (Object o : workspaceConnection.getComponents()) {
                    if (!(o instanceof IComponentHandle)) continue;
                    componentHandlesInWorkspace.add((IComponentHandle)o);
                }
                if (!componentHandlesInWorkspace.isEmpty()) {
                    IFetchResult result = workspaceConnection.teamRepository().itemManager().fetchCompleteItemsPermissionAware(componentHandlesInWorkspace, 0, monitor);
                    final ArrayList<WorkspaceComponentWrapper> availableSubcomponents = new ArrayList<WorkspaceComponentWrapper>();
                    for (Object o : result.getRetrievedItems()) {
                        IComponent c;
                        if (!(o instanceof IComponent) || (c = (IComponent)o).sameItemId((IItemHandle)parentWrapper.getComponent())) continue;
                        availableSubcomponents.add(WorkspaceComponentWrapper.newWrapper(workspaceConnection, c));
                    }
                    final IComponentHierarchyResult hierarchy = workspaceConnection.getComponentHierarchy(null);
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            final List selectedSubcomponents = AddSubcomponentAction.this.selectSubcomponents(parentWrapper, availableSubcomponents, hierarchy);
                            if (selectedSubcomponents != null && !selectedSubcomponents.isEmpty()) {
                                AddSubcomponentAction.this.getOperationRunner().enqueue(Messages.AddSubcomponentAction_ADD_SUBCOMPONENT_JOB_NAME, (Operation)new RepositoryOperation(){

                                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                        IUpdateSubcomponentOperation operation = OperationFactory.getInstance().getUpdateSubcomponentOperation(UpdateDilemmaHandler.getDefault());
                                        operation.addSubcomponents(workspaceConnection, (IComponentHandle)parentWrapper.getComponent(), (Collection)selectedSubcomponents, null);
                                        operation.run((IProgressMonitor)progress.newChild(100));
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    private List<IComponentHandle> selectSubcomponents(final WorkspaceComponentWrapper parentComponent, List<WorkspaceComponentWrapper> availableSubcomponents, final IComponentHierarchyResult hierarchy) {
        Collections.sort(availableSubcomponents, new Comparator<WorkspaceComponentWrapper>(){

            @Override
            public int compare(WorkspaceComponentWrapper object1, WorkspaceComponentWrapper object2) {
                return object1.getComponent().getName().compareToIgnoreCase(object2.getComponent().getName());
            }
        });
        ElementListSelectionDialog pickerDialog = new ElementListSelectionDialog(this.getContext().getShell(), (ILabelProvider)new LocalWorkspaceChangesViewLabelProvider());
        pickerDialog.setElements(availableSubcomponents.toArray());
        pickerDialog.setTitle(Messages.AddSubcomponentAction_SELECT_SUBCOMPONENT_DIALOG_TITLE);
        pickerDialog.setMessage(NLS.bind((String)Messages.AddSubcomponentAction_SELECT_SUBCOMPONENT_DIALOG_DESCRIPTION, (Object)parentComponent.getComponent().getName()));
        pickerDialog.setHelpAvailable(false);
        pickerDialog.setStatusLineAboveButtons(true);
        pickerDialog.setMultipleSelection(true);
        pickerDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                return AddSubcomponentAction.this.validateSubcomponentSelection(parentComponent, selection, hierarchy.getParentToChildrenMap());
            }
        });
        pickerDialog.open();
        if (pickerDialog.getResult() != null) {
            ArrayList<IComponentHandle> selection = new ArrayList<IComponentHandle>();
            Object[] objectArray = pickerDialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof WorkspaceComponentWrapper) {
                    WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)o;
                    selection.add((IComponentHandle)wrapper.getComponent());
                }
                ++n2;
            }
            return selection;
        }
        return null;
    }

    private IStatus validateSubcomponentSelection(WorkspaceComponentWrapper parentComponent, Object[] selection, Map<UUID, Collection<IComponentHandle>> parentToChildrenMap) {
        IStatus status = StatusUtil.newStatus((Object)((Object)this), (int)0, (String)"");
        ArrayList<WorkspaceComponentWrapper> componentsCreatingCycles = new ArrayList<WorkspaceComponentWrapper>();
        ArrayList<WorkspaceComponentWrapper> componentsAlreadyChildren = new ArrayList<WorkspaceComponentWrapper>();
        Collection<IComponentHandle> currentChildren = parentToChildrenMap.get(parentComponent.getComponent().getItemId());
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof WorkspaceComponentWrapper) {
                WorkspaceComponentWrapper selectedWrapper = (WorkspaceComponentWrapper)o;
                IComponent selectedComponent = selectedWrapper.getComponent();
                if (parentComponent.getHierarchyData() != null) {
                    HashSet<UUID> ancestorPath = new HashSet<UUID>(((IComponentHierarchyNode)parentComponent.getHierarchyData().getHierarchyNode()).getAncestorPath());
                    ancestorPath.add(parentComponent.getComponent().getItemId());
                    if (this.createsCycle((IComponentHandle)selectedComponent, ancestorPath, parentToChildrenMap)) {
                        componentsCreatingCycles.add(selectedWrapper);
                    }
                }
                if (currentChildren != null) {
                    for (IComponentHandle child : currentChildren) {
                        if (!child.sameItemId((IItemHandle)selectedComponent)) continue;
                        componentsAlreadyChildren.add(selectedWrapper);
                        break;
                    }
                }
            }
            ++n2;
        }
        if (componentsCreatingCycles.size() == 1) {
            status = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)NLS.bind((String)Messages.AddSubcomponentAction_VALIDATION_CREATES_CYCLE, (Object)((WorkspaceComponentWrapper)componentsCreatingCycles.get(0)).getComponent().getName()));
        } else if (componentsCreatingCycles.size() > 1) {
            status = StatusUtil.newStatus((Object)((Object)this), (int)4, (String)NLS.bind((String)Messages.AddSubcomponentAction_VALIDATION_CREATES_CYCLES, (Object)componentsCreatingCycles.size()));
        } else if (componentsAlreadyChildren.size() == 1) {
            status = StatusUtil.newStatus((Object)((Object)this), (int)2, (String)NLS.bind((String)Messages.AddSubcomponentAction_VALIDATION_ALREADY_SUBCOMPONENT, (Object)((WorkspaceComponentWrapper)componentsAlreadyChildren.get(0)).getComponent().getName()));
        } else if (componentsAlreadyChildren.size() > 1) {
            status = StatusUtil.newStatus((Object)((Object)this), (int)2, (String)NLS.bind((String)Messages.AddSubcomponentAction_VALIDATION_ALREADY_SUBCOMPONENTS, (Object)componentsAlreadyChildren.size()));
        }
        return status;
    }

    private boolean createsCycle(IComponentHandle node, Set<UUID> ancestorPath, Map<UUID, Collection<IComponentHandle>> hierarchyMap) {
        if (ancestorPath.contains(node.getItemId())) {
            return true;
        }
        Collection<IComponentHandle> children = hierarchyMap.get(node.getItemId());
        if (children != null && !children.isEmpty()) {
            HashSet<UUID> newAncestorPath = new HashSet<UUID>(ancestorPath);
            newAncestorPath.add(node.getItemId());
            for (IComponentHandle child : children) {
                if (!this.createsCycle(child, newAncestorPath, hierarchyMap)) continue;
                return true;
            }
        }
        return false;
    }
}

