/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.search;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.AbstractSearchAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.search.SearchForChangeSetsAction;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryView;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetSearchCriteriaPart;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class SearchForChangeSetsByContributorAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final IHistoryEntry historyEntry = (IHistoryEntry)Adapters.getAdapter((Object)selection.getFirstElement(), IHistoryEntry.class);
        final UIContext context = this.getContext();
        context.getUserOperationRunner().enqueue(Messages.SearchByUserAction_fetchSearchCriteriaJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                final ChangeSetSearchCriteriaPart.Input searchCriteria = HistoryView.getEquivalentSearchCriteria(historyEntry.getRepository(), historyEntry.getDynamicContext().getNamespace(), historyEntry.getTargetItem(), monitor);
                IContributorHandle contributor = (IContributorHandle)historyEntry.getCreatedBy().toHandle();
                searchCriteria.getSearchCriteria().setAuthor(contributor);
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractSearchAction.promptAndSearch(context, SearchForChangeSetsAction.ARGS, searchCriteria);
                    }
                });
            }
        });
    }
}

