/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.search;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.wrapper.BaselineQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.LockQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceQueryWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchInput;
import com.ibm.team.internal.filesystem.ui.views.search.AbstractSearchPage;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.baseline.BaselineSearchView;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetSearchView;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentSearchView;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchCriteriaPart;
import com.ibm.team.internal.filesystem.ui.views.search.lock.LockSearchView;
import com.ibm.team.internal.filesystem.ui.views.search.snapshot.SnapshotSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.snapshot.SnapshotSearchView;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.WorkspaceSearchView;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.databinding.DatabindingUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSearchQuery;
import com.ibm.team.repository.rcp.ui.internal.parts.WizardPageHost;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.wizards.IRunnableWithResult;
import com.ibm.team.repository.rcp.ui.wizards.WizardUtil;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.dto.NameFilter;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractSearchAction
extends AbstractActionDelegate {
    private SearchActionArgs searchActionArgs;

    public AbstractSearchAction(SearchActionArgs searchActionArgs) {
        this.searchActionArgs = searchActionArgs;
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        Object partInput = this.createPartInput(firstElement);
        AbstractSearchAction.promptAndSearch(this.getContext(), this.searchActionArgs, partInput);
    }

    public static void promptAndSearch(final UIContext context, final SearchActionArgs searchActionArgs, Object partInput) {
        IPartResult<AbstractSearchInput> partResult = new IPartResult<AbstractSearchInput>(){

            public void setResult(AbstractSearchInput result) {
                AbstractSearchAction.openSearch(context, searchActionArgs.searchViewImage, result, searchActionArgs.searchViewClass);
            }
        };
        AbstractSearchAction.promptAndSearch(context.getShell(), searchActionArgs, partInput, partResult);
    }

    public static <T extends AbstractSearchInput> void promptAndSearch(Shell shell, SearchActionArgs searchActionArgs, Object partInput, IPartResult<T> partResult) {
        AbstractSearchAction.promptAndSearch(partInput, searchActionArgs.partClass, searchActionArgs.wizardTitle, searchActionArgs.wizardTitleImage, shell, searchActionArgs.wizardTitle, searchActionArgs.helpContextId, partResult);
    }

    public static ITeamRepository getRepository(Object firstElement) {
        ITeamRepository repo = null;
        if (firstElement instanceof ITeamRepository) {
            repo = (ITeamRepository)firstElement;
        } else if (firstElement instanceof IProcessArea) {
            IProcessArea ta = (IProcessArea)firstElement;
            repo = ClientRepositoryUtil.getRepository((IItemHandle)ta);
        }
        if (repo == null) {
            repo = ClientRepositoryUtil.getDefaultRepository();
        }
        return repo;
    }

    protected abstract Object createPartInput(Object var1);

    public static InputFromDomainSubtree getInputFromDomainSubtree(Object o) {
        DomainSubtreeRoot dsr;
        Object categoryElement;
        if (o instanceof DomainSubtreeRoot && (categoryElement = (dsr = (DomainSubtreeRoot)o).getCategoryElement()) instanceof IProcessAreaHandle) {
            IProcessAreaHandle handle = (IProcessAreaHandle)categoryElement;
            ITeamRepository repository = AbstractSearchAction.getRepository(handle);
            return new InputFromDomainSubtree(repository, handle);
        }
        return null;
    }

    private static SearchWizardPageHost createWizardPage(Object partInput, Class partClass, String wizardTitle, ImageDescriptor wizardTitleImage) {
        SearchWizardPageHost wizardPage = new SearchWizardPageHost("SearchCriteria", wizardTitleImage, partInput, (IPartFactory)new PartFactory(partClass));
        wizardPage.setDescription(Messages.ChangeSetSearchCriteriaWizardPage_pageDescription);
        wizardPage.setTitle(wizardTitle);
        return wizardPage;
    }

    public static <T extends AbstractSearchInput> void promptAndSearch(Object partInput, Class partClass, String wizardTitle, ImageDescriptor wizardTitleImage, Shell shell, String dialogTitle, String helpContextId, final IPartResult<T> result) {
        final SearchWizardPageHost wizardPage = AbstractSearchAction.createWizardPage(partInput, partClass, wizardTitle, wizardTitleImage);
        WizardUtil.open((Shell)shell, (String)dialogTitle, (String)Messages.ChangeSetSearchCriteriaPart_searchButton, (boolean)false, (IWizardPage)wizardPage, (IRunnableWithResult)new IRunnableWithResult<Boolean>(){

            public Boolean run() {
                AbstractPart part = wizardPage.getPart();
                if (part instanceof AbstractSearchCriteriaPart) {
                    AbstractSearchCriteriaPart searchPart = (AbstractSearchCriteriaPart)part;
                    result.setResult(searchPart.getResult());
                }
                return true;
            }
        }, (String)helpContextId);
    }

    public static void openSearch(final UIContext context, final ImageDescriptor image, final AbstractSearchInput input, final Class<? extends AbstractSearchPage> clazz) {
        PartSearchQuery.ExistingSearchView searchView = PartSearchQuery.findSearchResultViewPart((Object)input);
        if (searchView != null) {
            final PartSearchQuery query = searchView.getPartSearchQuery();
            final ISearchResultViewPart srvp = searchView.getSearchResultViewPart();
            SWTUtil.greedyExec((Display)context.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    NewSearchUI.runQueryInBackground((ISearchQuery)query, (ISearchResultViewPart)srvp);
                }
            });
        } else {
            context.getUserOperationRunner().enqueue(Messages.AbstractSearchInput_computingSearchNameJobName, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    Display display = context.getDisplay();
                    String searchName = input.getSearchName(monitor);
                    AbstractSearchAction.openSearch(display, image, searchName, input, clazz);
                }
            });
        }
    }

    public static void openSearch(Display display, ImageDescriptor image, String searchName, Object input, Class clazz) {
        final PartSearchQuery query = new PartSearchQuery(display, input, searchName, searchName, image, (IPartFactory)new PartFactory(clazz));
        SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
        });
    }

    public static void openSearch(UIContext uiContext, QueryItemWrapper wrapper) {
        if (wrapper instanceof BaselineQueryWrapper) {
            AbstractSearchAction.runBaselineQuery(uiContext, (BaselineQueryWrapper)wrapper);
        } else if (wrapper instanceof ChangeSetQueryWrapper) {
            AbstractSearchAction.runChangeSetQuery(uiContext, (ChangeSetQueryWrapper)wrapper);
        } else if (wrapper instanceof ComponentQueryWrapper) {
            AbstractSearchAction.runComponentQuery(uiContext, (ComponentQueryWrapper)wrapper);
        } else if (wrapper instanceof LockQueryWrapper) {
            AbstractSearchAction.runLockQuery(uiContext, (LockQueryWrapper)wrapper);
        } else if (wrapper instanceof SnapshotQueryWrapper) {
            AbstractSearchAction.runSnapshotQuery(uiContext, (SnapshotQueryWrapper)wrapper);
        } else if (wrapper instanceof WorkspaceQueryWrapper) {
            AbstractSearchAction.runWorkspaceQuery(uiContext, (WorkspaceQueryWrapper)wrapper);
        }
    }

    public static void runBaselineQuery(UIContext uiContext, BaselineQueryWrapper wrapper) {
        IItemSearchCriteria itemSearchCriteria = wrapper.getQueryItem().getSearchCriteria();
        if (itemSearchCriteria instanceof IBaselineSearchCriteria) {
            IBaselineSearchCriteria searchCriteriaDTO = (IBaselineSearchCriteria)itemSearchCriteria;
            BaselineSearchCriteria uiSearchCriteria = BaselineSearchCriteria.createFromSearchCriteriaDTO(wrapper.getRepository(), searchCriteriaDTO);
            AbstractSearchAction.openSearch(uiContext, ImagePool.QUERY_BASELINE, uiSearchCriteria, BaselineSearchView.class);
        }
    }

    public static void runChangeSetQuery(UIContext uiContext, ChangeSetQueryWrapper wrapper) {
        ITeamRepository repo = wrapper.getRepository();
        IQueryItem query = wrapper.getQueryItem();
        IChangeSetSearchCriteria searchCriteria = (IChangeSetSearchCriteria)query.getSearchCriteria();
        int maxResults = ChangeSetSearchCriteriaPart.getChangeSetSearchMaxResults();
        ChangeSetSearchCriteria criteria = new ChangeSetSearchCriteria(repo, searchCriteria, maxResults);
        AbstractSearchAction.openSearch(uiContext, ImagePool.QUERY_CHANGE_SET, criteria, ChangeSetSearchView.class);
    }

    public static void runComponentQuery(UIContext uiContext, ComponentQueryWrapper wrapper) {
        ITeamRepository repo = wrapper.getRepository();
        IQueryItem query = wrapper.getQueryItem();
        IComponentSearchCriteria searchCriteria = (IComponentSearchCriteria)query.getSearchCriteria();
        String nameStartsWith = "";
        NameFilter nameFilter = searchCriteria.getOptionalNameFilter();
        if (nameFilter != null && nameFilter.getMatchPattern() != null) {
            nameStartsWith = nameFilter.getMatchPattern();
        }
        ItemId owner = ItemId.getNullItem((IItemType)IContributor.ITEM_TYPE);
        if (searchCriteria.getFilterByOwnerOptional().size() > 0) {
            owner = ItemId.create((IItemHandle)((IItemHandle)searchCriteria.getFilterByOwnerOptional().get(0)));
        }
        ComponentSearchCriteria criteria = new ComponentSearchCriteria(repo, null, nameStartsWith, (ItemId<? extends IAuditable>)owner);
        AbstractSearchAction.openSearch(uiContext, ImagePool.QUERY_COMPONENT, criteria, ComponentSearchView.class);
    }

    public static void runLockQuery(UIContext uiContext, LockQueryWrapper wrapper) {
        ITeamRepository repo = wrapper.getRepository();
        IQueryItem query = wrapper.getQueryItem();
        ILockSearchCriteria searchCriteria = (ILockSearchCriteria)query.getSearchCriteria();
        int maxResults = LockSearchCriteriaPart.getLockSearchMaxResults();
        List<SiloedItemId<IVersionable>> versionableHandles = Collections.emptyList();
        Collection versionables = searchCriteria.getVersionables();
        LockSearchCriteria criteria = new LockSearchCriteria(repo, searchCriteria.getStreams(), searchCriteria.getComponents(), searchCriteria.getContributor(), versionableHandles, maxResults);
        AbstractSearchAction.openSearch(uiContext, ImagePool.QUERY_LOCK, criteria, LockSearchView.class);
    }

    public static void runSnapshotQuery(UIContext uiContext, SnapshotQueryWrapper wrapper) {
        IItemSearchCriteria itemSearchCriteria = wrapper.getQueryItem().getSearchCriteria();
        if (itemSearchCriteria instanceof IBaselineSetSearchCriteria) {
            IBaselineSetSearchCriteria searchCriteriaDTO = (IBaselineSetSearchCriteria)wrapper.getQueryItem().getSearchCriteria();
            SnapshotSearchCriteria uiSearchCriteria = SnapshotSearchCriteria.createFromSearchCriteriaDTO(wrapper.getRepository(), searchCriteriaDTO);
            AbstractSearchAction.openSearch(uiContext, ImagePool.QUERY_SNAPSHOT, uiSearchCriteria, SnapshotSearchView.class);
        }
    }

    public static void runWorkspaceQuery(UIContext uiContext, ITeamRepository repo, IQueryItem query) {
        IItemSearchCriteria itemSearchCriteria = query.getSearchCriteria();
        if (itemSearchCriteria instanceof IWorkspaceSearchCriteria) {
            IWorkspaceSearchCriteria searchCriteria = (IWorkspaceSearchCriteria)itemSearchCriteria;
            PlaceSearchCriteria criteria = PlaceSearchCriteria.createFromSearchCriteriaDTO(repo, null, searchCriteria);
            Object type = PlaceSearchCriteria.TYPE_ANY;
            if (2 == searchCriteria.getWorkspaceKind()) {
                type = PlaceSearchCriteria.TYPE_WORKSPACE;
            } else if (1 == searchCriteria.getWorkspaceKind()) {
                type = PlaceSearchCriteria.TYPE_STREAM;
            }
            ImageDescriptor icon = type == PlaceSearchCriteria.TYPE_WORKSPACE ? ImagePool.QUERY_WORKSPACE : ImagePool.QUERY_STREAM;
            AbstractSearchAction.openSearch(uiContext, icon, criteria, WorkspaceSearchView.class);
        }
    }

    public static void runWorkspaceQuery(UIContext uiContext, WorkspaceQueryWrapper wrapper) {
        ITeamRepository repo = wrapper.getRepository();
        IQueryItem query = wrapper.getQueryItem();
        AbstractSearchAction.runWorkspaceQuery(uiContext, repo, query);
    }

    public static class InputFromDomainSubtree {
        private ITeamRepository repository;
        private IProcessAreaHandle processAreaHandle;

        public InputFromDomainSubtree(ITeamRepository repository, IProcessAreaHandle processAreaHandle) {
            this.repository = repository;
            this.processAreaHandle = processAreaHandle;
        }

        public ITeamRepository getRepository() {
            return this.repository;
        }

        public IProcessAreaHandle getProcessAreaHandle() {
            return this.processAreaHandle;
        }
    }

    public static class SearchActionArgs {
        public final Class partClass;
        public final String wizardTitle;
        public final ImageDescriptor wizardTitleImage;
        public final String helpContextId;
        public final ImageDescriptor searchViewImage;
        public final Class<? extends AbstractSearchPage> searchViewClass;

        public SearchActionArgs(Class partClass, String wizardTitle, String helpContextId, ImageDescriptor wizardTitleImage, ImageDescriptor searchViewImage, Class<? extends AbstractSearchPage> searchViewClass) {
            this.partClass = partClass;
            this.wizardTitle = wizardTitle;
            this.wizardTitleImage = wizardTitleImage;
            this.helpContextId = helpContextId;
            this.searchViewImage = searchViewImage;
            this.searchViewClass = searchViewClass;
        }
    }

    private static final class SearchWizardPageHost
    extends WizardPageHost {
        private SearchWizardPageHost(String pageName, ImageDescriptor titleImage, Object input, IPartFactory partFactory) {
            super(pageName, titleImage, input, partFactory);
        }

        protected MnemonicGenerator createMnemonicGenerator() {
            MnemonicGenerator mnemonics = new MnemonicGenerator(true);
            mnemonics.reserve(LegacyActionTools.extractMnemonic((String)Messages.ChangeSetSearchCriteriaPart_searchButton));
            return mnemonics;
        }

        protected void createBody(Composite parent) {
            super.createBody(parent);
            AbstractPart part = this.getPart();
            if (part instanceof AbstractSearchCriteriaPart) {
                AbstractSearchCriteriaPart searchPart = (AbstractSearchCriteriaPart)part;
                DatabindingUtil.bindMessage((DialogPage)this, (IObservableValue)searchPart.getValidationStatus());
            }
        }
    }
}

