/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInCompareEditorAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnMarkAsResolvedDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IVersionableChange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class UpdateVersionableChangeResolvedStateAction
extends AbstractPortAction {
    public static void updateVersionableChangeResolvedState(IStructuredSelection selection, final boolean resolved, final UpdateCurrentPatchDilemmaHandler dilemmaHandler, final IWorkbenchPage page, final Shell shell, IOperationRunner runner) {
        final HashSet<VersionableChangeNode> allVersionableChangeNodes = new HashSet<VersionableChangeNode>(selection.size());
        for (Object object : selection.toList()) {
            if (!(object instanceof VersionableChangeNode)) continue;
            allVersionableChangeNodes.add((VersionableChangeNode)object);
        }
        if (allVersionableChangeNodes.size() > 0) {
            final HashMap versionableChangeNodeMap = new HashMap();
            for (VersionableChangeNode versionableChangeNode : allVersionableChangeNodes) {
                ArrayList<VersionableChangeNode> versionableChangeNodes;
                HashMap<UUID, ArrayList<VersionableChangeNode>> componentToPortMap;
                ITeamRepository repo = versionableChangeNode.getRepository();
                UUID workspaceUUID = versionableChangeNode.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                UUID componentUUID = versionableChangeNode.getComponent().getItemId();
                HashMap workspaceToComponentMap = (HashMap)versionableChangeNodeMap.get(repo);
                if (workspaceToComponentMap == null) {
                    workspaceToComponentMap = new HashMap();
                }
                if ((componentToPortMap = (HashMap<UUID, ArrayList<VersionableChangeNode>>)workspaceToComponentMap.get(workspaceUUID)) == null) {
                    componentToPortMap = new HashMap<UUID, ArrayList<VersionableChangeNode>>();
                }
                if ((versionableChangeNodes = (ArrayList<VersionableChangeNode>)componentToPortMap.get(componentUUID)) == null) {
                    versionableChangeNodes = new ArrayList<VersionableChangeNode>();
                }
                versionableChangeNodes.add(versionableChangeNode);
                componentToPortMap.put(componentUUID, versionableChangeNodes);
                workspaceToComponentMap.put(workspaceUUID, componentToPortMap);
                versionableChangeNodeMap.put(repo, workspaceToComponentMap);
            }
            String jobName = resolved ? Messages.UpdateVersionableChangeResolvedStateAction_MARK_AS_DONE_JOB_NAME : Messages.UpdateVersionableChangeResolvedStateAction_MARK_AS_UNDONE_JOB_NAME;
            runner.enqueue(jobName, (Operation)new RepositoryOperation(versionableChangeNodeMap.keySet()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    int size = allVersionableChangeNodes.size();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 10));
                    if (resolved) {
                        OpenVersionableChangeInCompareEditorAction.saveOpenCompareEditors(versionableChangeNodeMap, page, shell, (IProgressMonitor)progress.newChild(size));
                    }
                    progress.setWorkRemaining(size * 9);
                    ArrayList<VersionableChangeNode> compareEditorsToClose = new ArrayList<VersionableChangeNode>();
                    for (Map.Entry repoToWorkspaceMapEntry : versionableChangeNodeMap.entrySet()) {
                        for (Map.Entry workspaceToComponentMap : ((Map)repoToWorkspaceMapEntry.getValue()).entrySet()) {
                            for (Map.Entry componentToVersionableChangesMap : ((Map)workspaceToComponentMap.getValue()).entrySet()) {
                                ICurrentPatch currentPort;
                                List versionableChangeNodes = (List)componentToVersionableChangesMap.getValue();
                                if (versionableChangeNodes.size() <= 0) continue;
                                IWorkspaceConnection workspaceConnection = ((VersionableChangeNode)versionableChangeNodes.get(0)).getWorkspaceConnection();
                                IComponent componentHandle = ((VersionableChangeNode)versionableChangeNodes.get(0)).getComponent();
                                IUpdateCurrentPatchOperation op = OperationFactory.getInstance().getUpdateCurrentPortOperation((UpdateCurrentPatchDilemmaHandler)(dilemmaHandler == null ? new WarnMarkAsResolvedDilemmaHandler(shell) : dilemmaHandler));
                                op.setContext(workspaceConnection, (IComponentHandle)componentHandle);
                                for (VersionableChangeNode node : versionableChangeNodes) {
                                    if (resolved) {
                                        op.markAsResolved(node.getVersionable(), null, resolved);
                                        continue;
                                    }
                                    op.markAsUnresolved(node.getVersionable(), null);
                                }
                                op.run((IProgressMonitor)progress.newChild(9));
                                if (!resolved || (currentPort = workspaceConnection.getCurrentPatch((IComponentHandle)componentHandle)) == null) continue;
                                for (VersionableChangeNode node : versionableChangeNodes) {
                                    IVersionableChange updatedChange = currentPort.getVersionableChange(node.getVersionableChange().getId());
                                    if (updatedChange == null || !updatedChange.isResolved()) continue;
                                    compareEditorsToClose.add(node);
                                }
                            }
                        }
                    }
                    OpenVersionableChangeInCompareEditorAction.closeNonDirtyCompareEditors(compareEditorsToClose, page, shell);
                    progress.done();
                }
            });
        }
    }
}

