/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInCompareEditorAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnMarkAsResolvedDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeDetail;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IVersionableChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class UpdateChangeDetailResolvedStateAction
extends AbstractPortAction {
    public static void updateChangeDetailResolvedState(IStructuredSelection selection, final boolean resolved, final UpdateCurrentPatchDilemmaHandler dilemmaHandler, final IWorkbenchPage page, final Shell shell, IOperationRunner runner) {
        final HashSet<AbstractChangeDetailNode> allAbstractChangeDetailNodes = new HashSet<AbstractChangeDetailNode>(selection.size());
        final HashSet<ContentChangeDetailNode> contentChangeDetails = new HashSet<ContentChangeDetailNode>();
        for (Object object : selection.toList()) {
            if (object instanceof AbstractChangeDetailNode) {
                allAbstractChangeDetailNodes.add((AbstractChangeDetailNode)object);
            }
            if (!(object instanceof ContentChangeDetailNode)) continue;
            contentChangeDetails.add((ContentChangeDetailNode)object);
        }
        if (allAbstractChangeDetailNodes.size() > 0) {
            final HashMap changeDetailNodeMap = new HashMap();
            for (AbstractChangeDetailNode changeDetailNode : allAbstractChangeDetailNodes) {
                ArrayList<AbstractChangeDetailNode> changeDetailNodes;
                HashMap<UUID, ArrayList<AbstractChangeDetailNode>> componentToPortMap;
                ITeamRepository repo = changeDetailNode.getRepository();
                UUID workspaceUUID = changeDetailNode.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                UUID componentUUID = changeDetailNode.getComponent().getItemId();
                HashMap workspaceToComponentMap = (HashMap)changeDetailNodeMap.get(repo);
                if (workspaceToComponentMap == null) {
                    workspaceToComponentMap = new HashMap();
                }
                if ((componentToPortMap = (HashMap<UUID, ArrayList<AbstractChangeDetailNode>>)workspaceToComponentMap.get(workspaceUUID)) == null) {
                    componentToPortMap = new HashMap<UUID, ArrayList<AbstractChangeDetailNode>>();
                }
                if ((changeDetailNodes = (ArrayList<AbstractChangeDetailNode>)componentToPortMap.get(componentUUID)) == null) {
                    changeDetailNodes = new ArrayList<AbstractChangeDetailNode>();
                }
                changeDetailNodes.add(changeDetailNode);
                componentToPortMap.put(componentUUID, changeDetailNodes);
                workspaceToComponentMap.put(workspaceUUID, componentToPortMap);
                changeDetailNodeMap.put(repo, workspaceToComponentMap);
            }
            String jobName = resolved ? Messages.UpdateChangeDetailResolvedStateAction_MARK_AS_DONE_JOB_NAME : Messages.UpdateChangeDetailResolvedStateAction_MARK_AS_UNDONE_JOB_NAME;
            runner.enqueue(jobName, (Operation)new RepositoryOperation(changeDetailNodeMap.keySet()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    int size = allAbstractChangeDetailNodes.size();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 10 + contentChangeDetails.size()));
                    if (resolved) {
                        for (ContentChangeDetailNode contentChangeDetailNode : contentChangeDetails) {
                            OpenVersionableChangeInCompareEditorAction.saveOpenCompareEditors(contentChangeDetailNode.getParentNode(), page, shell, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                    progress.setWorkRemaining(size * 10);
                    ArrayList<VersionableChangeNode> compareEditorsToClose = new ArrayList<VersionableChangeNode>();
                    for (Map.Entry repoToWorkspaceMapEntry : changeDetailNodeMap.entrySet()) {
                        for (Map.Entry workspaceToComponentMap : ((Map)repoToWorkspaceMapEntry.getValue()).entrySet()) {
                            for (Map.Entry componentToVersionableChangesMap : ((Map)workspaceToComponentMap.getValue()).entrySet()) {
                                ICurrentPatch currentPort;
                                List changeDetailNodes = (List)componentToVersionableChangesMap.getValue();
                                if (changeDetailNodes.size() <= 0) continue;
                                IWorkspaceConnection workspaceConnection = ((AbstractChangeDetailNode)changeDetailNodes.get(0)).getWorkspaceConnection();
                                IComponent componentHandle = ((AbstractChangeDetailNode)changeDetailNodes.get(0)).getComponent();
                                IUpdateCurrentPatchOperation op = OperationFactory.getInstance().getUpdateCurrentPortOperation((UpdateCurrentPatchDilemmaHandler)(dilemmaHandler == null ? new WarnMarkAsResolvedDilemmaHandler(shell) : dilemmaHandler));
                                op.setContext(workspaceConnection, (IComponentHandle)componentHandle);
                                for (AbstractChangeDetailNode node : changeDetailNodes) {
                                    if (resolved) {
                                        op.markAsResolved(node.getParentNode().getVersionable(), Collections.singleton(node.getChangeDetail().getId()), true);
                                        continue;
                                    }
                                    op.markAsUnresolved(node.getParentNode().getVersionable(), Collections.singleton(node.getChangeDetail().getId()));
                                }
                                op.run((IProgressMonitor)progress.newChild(10));
                                if (!resolved || (currentPort = workspaceConnection.getCurrentPatch((IComponentHandle)componentHandle)) == null) continue;
                                for (AbstractChangeDetailNode node : changeDetailNodes) {
                                    IChangeDetail changeDetail;
                                    IVersionableChange versionableChange;
                                    VersionableChangeNode versionableChangeNode;
                                    if (!(node instanceof ContentChangeDetailNode) || (versionableChangeNode = node.getParentNode()) == null || (versionableChange = currentPort.getVersionableChange(versionableChangeNode.getVersionableChange().getId())) == null || (changeDetail = versionableChange.getChangeDetail(node.getChangeDetailID())) == null || !changeDetail.isResolved()) continue;
                                    compareEditorsToClose.add(versionableChangeNode);
                                }
                            }
                        }
                    }
                    OpenVersionableChangeInCompareEditorAction.closeNonDirtyCompareEditors(compareEditorsToClose, page, shell);
                    progress.done();
                }
            });
        }
    }
}

